#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/tcp.h>

#include "inet.h"

int inet_server_socket(guint16 port)
{
  struct sockaddr_in name;
  int curstate;
  int fd;
  
  if ((fd = socket(PF_INET, SOCK_STREAM, 0)) < 0)
    {
      g_message("INET: Could not create socket.");
      return -1;
    }

  curstate = 1;
  setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &curstate, sizeof(curstate));

  curstate = 1;
  setsockopt(fd, IPPROTO_TCP, TCP_NODELAY, &curstate, sizeof(curstate));

  name.sin_family = AF_INET;
  name.sin_port = htons (port);
  name.sin_addr.s_addr = htonl (INADDR_ANY);

  if (bind(fd, (struct sockaddr *) &name, sizeof (name)) < 0)
    {
      g_message("INET: Could not bind socket.");
      close(fd);
      return -1;
    }

  if (listen(fd, 5) < 0)
    {
      g_message("INET: Could not make socket listen.");
      close(fd);
      return -1;
    }

  g_message("INET: Success created server socket on port %i.", port);

  return fd;
}

int inet_server_accept(int fd)
{
  struct sockaddr_in client;
  size_t size;
  int sock;
  int curstate;
  
  size = sizeof(client);
  if ((sock = accept(fd, (struct sockaddr*) &client, &size)) < 0)
    return -1;

  curstate = 1;
  setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, &curstate, sizeof(curstate));

  g_message("INET: Recieved connection from host %s, port %hd.", inet_ntoa(client.sin_addr), ntohs(client.sin_port));
  return sock;
}
