#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <pthread.h>
#include <netinet/tcp.h>

#include <asdutil.h>

#include "inet.h"
#include "asdlib.h"
#include "asderrno.h"

int inet_try_connect(gchar* hostname, guint16 port)
{  
  int fd;
  struct hostent *h;
  struct sockaddr_in name;
  int curstate;

  asd_set_errno(PROTOCOL_ASD_ERROR_SUCCESS);

  if (port == 0)
    port = PROTOCOL_ASD_INET_PORT;

  if (hostname == NULL)
    hostname = "localhost";

  if ((fd = socket(PF_INET, SOCK_STREAM, 0)) < 0)
    {
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return -1;
    }

  curstate = 1;
  setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &curstate, sizeof(curstate));

  curstate = 1;
  setsockopt(fd, IPPROTO_TCP, TCP_NODELAY, &curstate, sizeof(curstate));

  name.sin_family = AF_INET;
  name.sin_port = htons (port);
  
  pthread_cleanup_push(fd_cleanup_handler, &fd);

  if (!(h = gethostbyname(hostname)))  //FIXME! Not threadsafe
    {
      close(fd);
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return -1;
    }

  name.sin_addr = *(struct in_addr *) h->h_addr;
  if (connect(fd, (struct sockaddr *) &name, sizeof (name)) < 0)
    {
      close(fd);
      asd_set_errno(PROTOCOL_ASD_LOCAL_ERROR_SYSTEM);
      return -1;
    }

  pthread_cleanup_pop(0);

  return fd;
}
