/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#endif
#include "inifile.h"

void hlpScreen()
{	exit(127);
}

int dispVal(void * const arg)
{
	puts(  "------------");
	printf("Value:      \"%s\"\n", cfgGetValName(NULL));
	printf("Data:       \"%s\"\n", cfgGetValData(NULL));
	printf("Type:       \"%s\"\n", cfgTypeString(cfgGetValType(NULL)));
	printf("Comment:    \"%s\"\n", cfgGetValComment(NULL));
	printf("Decomp.data:\"%s\"\n", cfgGetValData(NULL));
	return 0;
}
int cpyVal(void * const arg)
{
	return cfgCreateDataLineINI(cfgGetValName(NULL), cfgGetValData(NULL)
		, cfgGetValType(NULL), cfgGetValTrustlevel(NULL));
}

#define P "Enum ["
int dispSec(const Cfg_secEnumData * const data, void * const arg)
{	char *p;
	int rv;

	if(!data)
		abort();

	if((rv = cfgOpenEnumSection(data)) != CFG_ERR_NONE)
		return rv;

	if(data->cfgi_keyname) {
		p = malloc(strlen(data->cfgi_keyname) + sizeof(P) + 1);
		if(!p) abort();
		strcpy(p, P);
		strcat(p, data->cfgi_keyname);
		strcat(p, "]");
	}
	else if((p = strdup("Enum []")) == NULL)
		abort();

	puts("=======================");
	fputs("Section: ", stdout);
	puts(data->cfgi_keyname? data->cfgi_keyname: "<NULL>");

	rv = cfgEnumValues(CFG_FSTD, dispVal, NULL);
	if(rv)
		cfgViewErrorINI(p, rv);
	free(p);

	return 0;
}

main(int argc, char **argv)
{	int rv;
	char *p;

	rv = cfgInitINI();
	if(rv)
		cfgViewErrorINI("Init", rv);
	rv = cfgEnumSections(CFG_FSTD, dispSec, NULL);
	if(rv)
		cfgViewErrorINI("Enum Sections", rv);
	rv = cfgEraseSection("just a test");
	if(rv)
		cfgViewErrorINI("Erase Section", rv);
	else if((rv = cfgCreateStringINI("test value", "test data")) != 0)
		cfgViewErrorINI("Add test value", rv);
	else if((rv = cfgOpenSection(NULL)) != 0)
		cfgViewErrorINI("Open Section NULL", rv);
	else if((rv = cfgEnumValues(CFG_FSTD, cpyVal, NULL)) != 0)
		cfgViewErrorINI("Enum Values of NULL", rv);
	else if((rv = cfgCloseWrite()) != 0)
		cfgViewErrorINI("Close write", rv);
	else if((rv = cfgEnumValues(CFG_FSTD, dispVal, NULL)) != 0)
		cfgViewErrorINI("Disp new section", rv);
	rv = cfgExitINI();
	if(rv)
		cfgViewErrorINI("Exit", rv);

	return 0;
}
