/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_GS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgGetSigned
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Scan an option as signed number
he(ader files): 
lo(ng description): Check if the current option applies to the signed number
	type and perform the actions, if so.\par
	The number must fall into the boundary: \tok{low <= *num <= high}.\newline
	If \tok{radix == 0}, the number is interpreted the C-style.\par
	On success the value of \para{*num} has been changed to the
	specified number.
pr(erequistes): 
re(lated to): 
se(condary subsystems): 
va: 
 \item		0: success, *num changed
 \item		1: number exceeds range
 \item		>=10: (position + 10) where the first non-numerical is
xr(ef): 
im(port): 
fi(le): cfg_gs.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <portable.h>
#include "str.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_GS.C 1.6 2001/02/27 01:28:02 ska Exp ska $";
#endif

int cfgGetSigned(struct Cfg_Getopt * const optstru, int * const num
 , int low, int high, int radix)
{	inM(int, long) n;
	char *endp, *p;

	DBG_ENTER("cfgGetSigned", Suppl_cmdline)

	assert(optstru);

	switch(optArgType()) {
	case CFG_TERROR:
		DBG_RETURN_I( 2)

	case CFG_TINTEGER:
		*num = optArgInteger();
		DBG_RETURN_I( 0)

	case CFG_TBOOLEAN:		/* invalid type */
		break;

	default:				/* unknown == string */
		if(!*(p = skipws(optArgString())))
			DBG_RETURN_I( 10)		/* no digit at all */

		endp = 0;
		n = strtol(p, &endp, radix);
		if(endp && *skipws(endp))		/* error */
			DBG_RETURN_I( (endp - optArgString()) + 10)

		if(low <= n && n <= high) {
			*num = (int)n;
			DBG_RETURN_I( 0)
		}
	}

	DBG_RETURN_I( 1)
}
