/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_EQV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgCmpName
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Compare two names
he(ader files): 
lo(ng description): Compare two names, if they are equal to each other,
	following the rules associated to the naming convention for names
	of sections and values within INI files and the names of options.\par
	A \tok{NULL} value is considered "less than", non-\tok{NULL} values,
	but equal to other \tok{NULL} values.\par
	Currently a name is constructed as following:\newline
	<value name> ::= [{<blank>}] <word> [{ <delimiter> <word> }] [{<blank>}]\newline
	<delimiter> ::= {<blank>} | '-' | '_'
pr(erequistes): 
va(lue): 0: both are equal\item <0: 1st name ordered prior 2nd name
	\item >0: 1st name ordered behind 2nd name
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_eqv.c
in(itialized by): 
wa(rning): If both parameters are \tok{NULL}, this function returns \tok{0}.
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <ctype.h>
#include <portable.h>
#include "str.h"
#include "dynstr.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_EQV.C 1.5 1999/12/13 02:21:57 ska Exp ska $";
#endif

/*
 *	Return the next chacacter and collapse delimiters
 */
#define ch(poi) ch_(&(poi))
static int ch_(const char ** Xp)
{	const char *p = *Xp;
	int c;

	if((c = *p) == 0)
		return 0;

	if(isspace(c) || c == '-' || c == '_') {
		while(isspace(c = *++p) || c == '-' || c == '_');
		c = ' ';
	}
	else ++p;

	*Xp = p;
	return toUpper(c);
}

int cfgCmpName(const char * const v1, const char * const v2)
{	const char *p, *q;
	int c, b, d;

	DBG_ENTER("cfgComName", Suppl_cmdline)
	DBG_ARGUMENTS( ("nam1:\"%s\", nam2:\"%s\"", v1, v2) )

	chkHeap

	if(v1 == v2)		return  0;		/* equal, even if NULL */
	if(!v1)				return -1;
	if(!v2)				return  1;

	p = skipws(v1);
	q = skipws(v2);

	do {
		c = ch(p);
		b = ch(q);
		if(!c || !b) {
			/* Ignore trailing blanks */
			if(c == ' ')	c = ch(p);
			if(b == ' ')	b = ch(q);

			DBG_RETURN_I( c - b)
		}
	} while((d = c - b) == 0);

	DBG_RETURN_I( d)
}
