
#include "mod.h"
#include <string.h>
#include <stdlib.h>

#include "xmp.h"
static struct xmp_module_info mi;
static int mod_length, tpo, bpm;
static double seconds;

static int mod_playing = FALSE;
static int mod_init = FALSE;

void *mod_thread(void *foo);

static void player_callback(unsigned long i)
{
   unsigned long msg = i >> 4;
   static int row, pos, pat;

   switch (i & 0xf) {
   case XMP_ECHO_BPM:
      bpm = msg & 0xff;
      tpo = msg >> 8;
      break;
   case XMP_ECHO_ORD:
      pos = msg & 0xff;
      pat = msg >> 8;
      break;
   case XMP_ECHO_ROW:
      row = msg & 0xff;
      seconds += 60.0 * tpo / (24 * bpm);
      break;
   }
}

void xmp_seek_to_frame(int second)
{
   if (second > seconds)
      xmp_ord_next();
   if (second < seconds)
      xmp_ord_prev();
}


int xmp_play(int start_second, char *song)
{
   struct xmp_options opt;

   if (!song) {
      fprintf(stderr, "No playlist loaded\n");
      return 0;
   }

   xmp_init(0, NULL, &opt);
   opt.verbose = 0;
   xmp_register_event_callback(player_callback);

   if (xmp_open_audio(&opt) < 0) {
      fprintf(stderr, "Can't open audio device");
      return 0;
   }

   if ((mod_length = xmp_load_module(song)) < 0) {
      fprintf(stderr, "Error loading file: %s\n", song);
      xmp_close_audio();
      return 0;
   }

   xmp_get_module_info(&mi);
   seconds = 0;
   if (strlen(mi.title)) {
      cur_item->name = Erealloc(cur_item->name, strlen(mi.title) + strlen(cur_item->name));
      strcpy((char *) (strchr(cur_item->name, '-') + 2), mi.title);
   }
   cur_item->length = mod_length / 1000;

   pthread_create(&player_thread, NULL, mod_thread, NULL);
   return 1;
}


void xmp_pause_it(void)
{
   xmp_mod_pause();
}


void *mod_thread(void *foo)
{
   mod_playing = TRUE;
   mod_init = TRUE;
   mod_length = xmp_play_module();
   end_song = TRUE;
   mod_playing = FALSE;
   return NULL;
}

void xmp_stop(int playing)
{
   if (!mod_init)
      return;
   xmp_stop_module();
   while (mod_playing)
      usleep(500);
   pthread_join(player_thread, NULL);
   xmp_close_audio();
   end_song = FALSE;
   mod_init = FALSE;
}

int xmp_is_file(char *path)
{
   char *temp = NULL;

   if (!path)
      return 0;
   if ((temp = strrchr(path, '.'))) {
      if (!strcasecmp((temp + 1), "xm"))
	 return 1;
      if (!strcasecmp((temp + 1), "mod"))
	 return 1;
      if (!strcasecmp((temp + 1), "s3m"))
	 return 1;
      if (!strcasecmp((temp + 1), "stm"))
	 return 1;
      if (!strcasecmp((temp + 1), "mtm"))
	 return 1;
      if (!strcasecmp((temp + 1), "ptm"))
	 return 1;
      if (!strcasecmp((temp + 1), "okt"))
	 return 1;
      if (!strcasecmp((temp + 1), "far"))
	 return 1;
      if (!strcasecmp((temp + 1), "wow"))
	 return 1;
      if (!strcasecmp((temp + 1), "669"))
	 return 1;
      if (!strcasecmp((temp + 1), "alm"))
	 return 1;
      if (!strcasecmp((temp + 1), "mod"))
	 return 1;
      if (!strcasecmp((temp + 1), "Z"))
	 return 1;
      if (!strcasecmp((temp + 1), "zip"))
	 return 1;
      if (!strcasecmp((temp + 1), "lha"))
	 return 1;
      if (!strcasecmp((temp + 1), "lzh"))
	 return 1;
      if (!strcasecmp((temp + 1), "bz2"))
	 return 1;
      if (!strcasecmp((temp + 1), "mdz"))
	 return 1;
      if (!strcasecmp((temp + 1), "gz"))
	 return 1;
   }
   return 0;
}

void xmp_version_info(char *id, char *version, char *copyright)
{
   strcpy(id, "xmp");
   strcpy(version, "1.1.6");
   strcpy(copyright, "1996-1998 Claudio Matsuoka and Hipolito Carraro Jr");
}

void xmp_ini(void)
{
}

void xmp_get_info(struct playlist_item *song)
{
   char *temp;

   temp = strrchr(song->path, '/');
   if (temp + 1) {
      temp++;
      song->name = duplicate(temp);
   }
   song->length = mod_length / 1000;
}

struct player_plugin *setup_plugin(void)
{
   struct player_plugin *temp = Emalloc(sizeof(struct player_plugin));

   temp->init = xmp_ini;
   temp->config = xmp_config;
   temp->seek_to_frame = xmp_seek_to_frame;
   temp->play = xmp_play;
   temp->stop = xmp_stop;
   temp->pause_it = xmp_pause_it;
   temp->is_file = xmp_is_file;
   temp->get_info = xmp_get_info;
   temp->version_info = xmp_version_info;
   return temp;
}
