#!/bin/sh

echo "Removing all .deps/"
find . -name ".deps" | xargs rm -rf

echo "Fixing all of my tabs to spaces.."
for z in `find . -name '*.[ch]'`
  do zz=`echo ${z}.$$`
  echo "Fixing $z"
  cat $z | sed -e 's/	/        /g' > $zz
  mv -f $zz $z
done

echo "Indenting all source file to sanity."

find . -name "*.[ch]" -print | xargs indent -bad -l80 -bap -br -i3 -lp -nce -npcs -npsl

echo "Removing all *~"
find .  -name "*~" | xargs rm -rf
