
#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>
#include "widget.h"

extern char *HomeDir;

void Find_gtkrc(void)
{
   char *filename = NULL;

   if (exists("/usr/local/share/gtkrc"))
      gtk_rc_parse("/usr/local/share/gtkrc");
   if (exists("/usr/share/gtkrc"))
      gtk_rc_parse("/usr/share/gtkrc");
   filename = Emalloc(strlen(HomeDir) + strlen("/.gtkrc") + 1);
   strcpy(filename, HomeDir);
   strcat(filename, "/.gtkrc");
   if (exists(filename))
      gtk_rc_parse(filename);
   filename = Erealloc(filename, strlen(HomeDir) + strlen("/.emusic/.gtkrc") + 1);
   strcpy(filename, HomeDir);
   strcat(filename, "/.emusic/.gtkrc");
   if (exists(filename))
      gtk_rc_parse(filename);
   Efree(filename);
}

void InitX(int *argc, char **argv[])
{
   XGCValues gcvals;
   int black;

   EDBUG(1, "InitX");
   EisWM = FALSE;
   if (!XInitThreads()) {
      fprintf(stderr, "****************************************************************************\n");
      fprintf(stderr, "Your xlibs don't think that they're thread-safe.  Ungrade, upgrade..\n");
      fprintf(stderr, "eMusic will continue to run, but be warned..  XIO Errors are in your future.\n");
      fprintf(stderr, "****************************************************************************\n");
   }
   gtk_set_locale();
   gtk_init(argc, argv);
   Find_gtkrc();
   disp = (Display *) gdk_display;
/*   if ((disp = XOpenDisplay(NULL)) == NULL) {
   fprintf(stderr, "Can't open Display\n");
   exit(-1);
   } */
   screen = DefaultScreen(disp);
   root = DefaultRootWindow(disp);
   imlib = Imlib_init(disp);
   fnlib = Fnlib_init(imlib);
   depth = imlib->x.depth;
   visual = imlib->x.visual;
   fg = XCreateGC(disp, root, 0, &gcvals);
   bg = XCreateGC(disp, root, 0, &gcvals);
   black = BlackPixel(disp, screen);
   XSetBackground(disp, fg, black);
   XSetForeground(disp, bg, black);
   setlocale(LC_ALL, "");
   if (!XSupportsLocale()) {
      fprintf(stderr, "locale not supported by Xlib. locale set to C");
      setlocale(LC_ALL, "C");
   }
   XSetLocaleModifiers("");
   setlocale(LC_ALL, NULL);
   if ((EisWM = FindE()))
      SetUpE();
   EDBUG_RETURN_;
}

Window CreateClearWin(Window parent, int x, int y, int w, int h)
{
   XSetWindowAttributes xatrib;
   Window win;

   EDBUG(6, "CreateClearWin");
   xatrib.background_pixmap = ParentRelative;
   xatrib.override_redirect = TRUE;
   win = XCreateWindow(disp, parent, x, y, w, h, 0, depth, InputOutput, visual,
		       CWBackPixmap | CWOverrideRedirect, &xatrib);
   XSelectInput(disp, win, KeyPressMask | ButtonPressMask | ButtonReleaseMask |
		EnterWindowMask | LeaveWindowMask | ButtonMotionMask |
		ExposureMask);
   EDBUG_RETURN(win);
}

Window CreateWin(Window parent, int x, int y, int w, int h)
{
   XSetWindowAttributes xatrib;
   Window win;

   EDBUG(6, "CreateWin");
   xatrib.override_redirect = TRUE;
   win = XCreateWindow(disp, parent, x, y, w, h, 0, depth, InputOutput, visual,
		       CWOverrideRedirect, &xatrib);
   XSelectInput(disp, win, KeyPressMask | ButtonPressMask | ButtonReleaseMask |
		EnterWindowMask | LeaveWindowMask | ButtonMotionMask |
		ExposureMask | PointerMotionMask);
   EDBUG_RETURN(win);
}
