
#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#define _GNU_SOURCE 1

#ifdef HAVE_FEATURES_H
#include <features.h>
#endif
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xproto.h>
#include <X11/extensions/shape.h>
#include <X11/Xthreads.h>
#include <X11/Xlocale.h>
#include <Imlib.h>
#include <Fnlib.h>
#include <StringList.h>
#include <gtk/gtk.h>

#include "../../config.h"

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include "x.h"
#include "imagedat.h"
#include "actions.h"
#include "button.h"
#include "slider.h"
#include "textbox.h"
#include "listbox.h"
#include "back.h"
#include "container.h"
#include "filebox.h"
#include "status.h"
#include "strip.h"
#include "dialog.h"

#include "ecomm.h"

#define BUTTON      1
#define MULTIBUTTON 2
#define SLIDER      3
#define TEXTBOX     4
#define LISTBOX     5
#define BACKGROUND  6
#define CONTAINER   7
#define FILEBOX     8
#define WIDGET      9
#define STATUS      10
#define STRIP       11
#define DIALOG      12

extern int deferred;

struct _widget {
   void *widget;
   int type;
   struct _widget *next;
};

typedef struct {
   Window win;
   int exposed;
   struct _widget *first;
   struct _widget *last;
   int raised;
   int state;
   int visible;
   int deferred;
   int offset_x, offset_y;
   int x, y, w, h;
   int shaped;
} Widget;

void ScaleWidget(Widget * widget, double scale_w, double scale_h);
void ResizeWidget(Widget * widget, int new_w, int new_h);
void RaiseLowerWidget(Widget * widget);
int FindEventWidget(Widget * widget, XEvent ev);
void MoveWidget(Widget * widget, Widget * offset, int x, int y);
void UnhideWidget(Widget * widget);
void HideWidget(Widget * widget);
void CreateWidget(Widget * widget);
void FreeWidget(Widget * widget);
void MinimizeWidgets(void);
