#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include "widget.h"
#include "../econfig.h"
#include "../file.h"
#include "../plugin.h"
#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>

FileBox *File;

void DefaultsFileBox(FileBox * filebox)
{
   filebox->cdmode = FALSE;
   filebox->recurse = FALSE;
   filebox->okdone = FALSE;
   filebox->gtk_return_path = NULL;
}

void recursive_button(GtkWidget * button, GtkFileSelection * file)
{
   File->recurse = GTK_TOGGLE_BUTTON(button)->active;
}

void file_ok_sel(GtkWidget * w, GtkFileSelection * file)
{
   File->gtk_return_path = duplicate(gtk_file_selection_get_filename(GTK_FILE_SELECTION(file)));
   gtk_widget_destroy(GTK_WIDGET(file));
}

void destroy(GtkWidget * w, gpointer data)
{
   gtk_main_quit();
}

FileBox *ConfigFileBox(FILE * file)
{
   FileBox *filebox = Emalloc(sizeof(FileBox));

   EDBUG(5, "ConfigFileBox");
   DefaultsFileBox(filebox);
   File = filebox;
   EDBUG_RETURN(filebox);
}

void PopUpFileBox(FileBox * filebox)
{
   GtkWidget *button;

   EDBUG(5, "PopUpFileBox");
   filebox->file = gtk_file_selection_new("eMusic");
/*   gtk_window_set_modal(GTK_WINDOW(filebox->file), TRUE); */
   gtk_signal_connect(GTK_OBJECT(filebox->file), "destroy", GTK_SIGNAL_FUNC(destroy), NULL);
   gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filebox->file)->ok_button), "clicked", GTK_SIGNAL_FUNC(file_ok_sel), GTK_OBJECT(filebox->file));
   gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filebox->file)->cancel_button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(filebox->file));
   button = gtk_check_button_new_with_label("Recursive");
   gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(recursive_button), (gpointer) filebox->file);
   gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(filebox->file)->action_area), button, FALSE, FALSE, 0);
   gtk_widget_show(button);
   if (filebox->gtk_return_path)
      gtk_file_selection_set_filename(GTK_FILE_SELECTION(filebox->file), (gchar *) filebox->gtk_return_path);
   else
      gtk_file_selection_set_filename(GTK_FILE_SELECTION(filebox->file), "Hmmm..");
   gtk_widget_show(filebox->file);
   filebox->okdone = FALSE;
   filebox->recurse = FALSE;
   gtk_main();
   if (filebox->gtk_return_path) {
      filebox->okdone = TRUE;
   }
   else {
      filebox->okdone = FALSE;
   }
   if (filebox->callback);
   filebox->callback(filebox->gtk_return_path);
   EDBUG_RETURN_;
}

void FreeFileBox(FileBox * filebox)
{
   EDBUG(5, "FreeFileBox");
   Efree(filebox);
   filebox = NULL;
   EDBUG_RETURN_;
}

void SetFileBoxCallback(FileBox * filebox, void (*call) (char *))
{
   filebox->callback = call;
}
