
#include "widget.h"
#include "../econfig.h"

void HideDialog(Dialog * dialog)
{
   EDBUG(5, "HideDialog");
   if (dialog->visible) {
      XUnmapWindow(disp, dialog->win);
      dialog->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideDialog(Dialog * dialog)
{
   EDBUG(5, "UnhideDialog");
   if (!dialog->visible) {
      XMapWindow(disp, dialog->win);
      dialog->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void CreateDialog(Dialog * dialog)
{
}

void DefaultsDialog(Dialog * dialog)
{
   dialog->x = dialog->y = dialog->w = dialog->h = 0;
   dialog->back = NULL;
   dialog->ok = dialog->cancel = NULL;
   dialog->progress = NULL;
   dialog->info = NULL;
   dialog->done = dialog->okdone = FALSE;
   dialog->visible = TRUE;
}

Dialog *ConfigDialog(FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   Dialog *dialog = Emalloc(sizeof(Dialog));

   EDBUG(5, "ConfigDialog");
   DefaultsDialog(dialog);
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("VISIBLE", s1, 7)) {
	    dialog->state = parsebool(s2);
	    dialog->deferred = deferred = !dialog->state;
	 }
	 else if (!strncmp("BEGIN", s1, 5)) {
	    upstr(s2);
	    if (!strncmp("BACKGROUND", s2, 10)) {
	       dialog->back = ConfigBack(file);
	       dialog->win = dialog->back->win;
	       dialog->h = dialog->back->h;
	       dialog->w = dialog->back->w;
	    }
	    else if (!strncmp("OK", s2, 2))
	       dialog->ok = ConfigButton(dialog->win, file);
	    else if (!strncmp("CANCEL", s2, 6))
	       dialog->cancel = ConfigButton(dialog->win, file);
	    else if (!strncmp("PROGRESS_SLIDER", s2, 8))
	       dialog->progress = ConfigSlider(dialog->win, file);
	    else if (!strncmp("TEXTBOX", s2, 7))
	       dialog->info = ConfigTextBox(dialog->win, file);
	 }
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      CreateDialog(dialog);
   else
      dialog->visible = FALSE;
   deferred = FALSE;
   EDBUG_RETURN(dialog);
}

void PopUpDialog(Dialog * dialog, char *msg, int ok, int cancel, int slider)
{
   EDBUG(5, "PopUpDialog");
   if (dialog->visible)
      EDBUG_RETURN_;
   if (dialog->deferred) {
      deferred = TRUE;
      CreateBack(dialog->back);
      dialog->win = dialog->back->win;
      if (dialog->ok)
	 CreateButton(dialog->ok, dialog->win);
      if (dialog->cancel)
	 CreateButton(dialog->cancel, dialog->win);
      if (dialog->progress)
	 CreateSlider(dialog->progress, dialog->win);
      if (dialog->info)
	 CreateTextBox(dialog->info, dialog->win);
      deferred = FALSE;
   }
   if (dialog->info && msg)
      SetTextTextBox(dialog->info, msg);
   UnhideDialog(dialog);
   if (dialog->info)
      UpdateTextBox(dialog->info);
   if (dialog->ok && !ok)
      HideButton(dialog->ok);
   if (dialog->cancel && !cancel)
      HideButton(dialog->cancel);
   if (dialog->progress && !slider)
      HideSlider(dialog->progress);
   if (dialog->progress)
      SetSliderPosition(dialog->progress, 0.01);
   dialog->visible = TRUE;
   EDBUG_RETURN_;
}

void EventDialog(Dialog * dialog, XEvent ev)
{
   fprintf(stderr, "event dialog..\n");
   EDBUG(5, "EventDialog");
   if (dialog->ok && isEventButton(dialog->ok, ev))
      EventButton(dialog->ok, ev);
   else if (dialog->cancel && isEventButton(dialog->cancel, ev))
      EventButton(dialog->cancel, ev);
   EDBUG_RETURN_;
}

void KillDialog(Dialog * dialog)
{
   EDBUG(5, "KillDialog");
   if (!dialog->visible)
      EDBUG_RETURN_;
   HideDialog(dialog);
   dialog->callback();
   EDBUG_RETURN_;
}

void ResizeDialog(Dialog * dialog)
{
}
