struct player_plugin {
   void (*init) (void);
   void (*config) (char *left, char *right);
   void (*seek_to_frame) (int second);
   int (*play) (int start_second, char *song);
   void (*pause_it) (void);
   void (*stop) (int playing);
   int (*is_file) (char *path);
   void (*get_info) (struct playlist_item * song);
   void (*version_info) (char *id, char *version, char *copyright);
   char *id;
   char *version;
   char *copyright;
   void *handle;
   int loaded;
   char *soname;
   struct player_plugin *next;
};

typedef struct {
   struct player_plugin *first;
   struct player_plugin *current;
   int number;
} Players;

struct analysis_plugin {
   int (*init_analysis) (Window win, int w, int h);
   void (*do_analysis) (char *buffer, int size);
   void (*close_analysis) (void);
   void (*version_info) (char *id, char *version, char *copyright);
   void (*config_analysis) (char *left, char *right);
   char *id;
   char *version;
   char *copyright;
   void *handle;
   int size;
   int loaded;
   struct analysis_plugin *next;
};

typedef struct {
   struct analysis_plugin *first;
   struct analysis_plugin *current;
   int number;
} Analysis;

extern Players *players;
extern Analysis *analysis;

struct player_plugin *ReturnPlayerPlugin(char *search);
void UnloadPlayerPlugin(struct player_plugin *plug);
void UnloadAllPlayerPlugins(void);
int LoadPlayerPlugin(struct player_plugin *plug);
void InitPlayers(char *path);
void FreePlayers(void);

struct analysis_plugin *ReturnAnalysisPlugin(char *search);
void InitAnalysis(char *path);
void FreeAnalysis(void);

int getnumtracks_cda(void);
