#include "emusic.h"

Players *players = NULL;
Analysis *analysis = NULL;

void seek_to_frame_none(int second)
{
}

int play_none(int start_second, char *song)
{
   fprintf(stderr, "no player can handle %s, bug me about it..\n", song);
   return 0;
}

void pause_it_none(void)
{
}

void stop_none(int playing)
{
}

int is_file_none(char *path)
{
   return TRUE;
}

void get_info_none(struct playlist_item *song)
{
   char *temp;

   EDBUG(7, "get_info_none");
   temp = strrchr(song->path, '/');
   if (temp) {
      temp++;
      if (temp)
	 song->name = duplicate(temp);
   }
   song->length = 0;
   EDBUG_RETURN_;
}

struct player_plugin *DummyPlayer(void)
{
   struct player_plugin *cur;

   EDBUG(6, "DummyPlayer");
   cur = Emalloc(sizeof(struct player_plugin));

   cur->init = NULL;
   cur->config = NULL;
   cur->seek_to_frame = seek_to_frame_none;
   cur->play = play_none;
   cur->pause_it = pause_it_none;
   cur->stop = stop_none;
   cur->is_file = is_file_none;
   cur->get_info = get_info_none;
   cur->id = duplicate("Dummy player");
   cur->version = duplicate("0.0");
   cur->version_info = NULL;
   cur->loaded = FALSE;
   cur->next = NULL;
   cur->handle = NULL;
   EDBUG_RETURN(cur);
}

struct player_plugin *ReturnPlayerPlugin(char *search)
{
   struct player_plugin *cur;

   EDBUG(5, "ReturnPlayerPlugin");
   if (!players)
      EDBUG_RETURN(NULL);
   cur = players->first;
   while (cur) {
      if (!strcasecmp(search, cur->id))
	 EDBUG_RETURN(cur);
      if (strstr(cur->id, search))
	 EDBUG_RETURN(cur);
      cur = cur->next;
   }
   EDBUG_RETURN(NULL);
}

void UnloadPlayerPlugin(struct player_plugin *plug)
{
   EDBUG(5, "UnloadPlayerPlugin");
   if (plug->loaded && plug->handle) {
      if (strcmp("genwrap", plug->id) && strcmp("ascd", plug->id)) {
	 plug->loaded = FALSE;
	 fprintf(stderr, "unloading plugin %s\n", plug->id);
	 dlclose(plug->handle);
	 plug->handle = 0;
      }
   }
   EDBUG_RETURN_;
}

void UnloadAllPlayerPlugins(void)
{
   struct player_plugin *cur;

   EDBUG(5, "UnloadAllPlayerPlugins");
   if (!players)
      EDBUG_RETURN_;
   cur = players->first;
   cur = cur->next;
   while (cur) {
      UnloadPlayerPlugin(cur);
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

int loadPlayerSyms(struct player_plugin *plug)
{
   char *error;
   struct player_plugin *temp = NULL;
   struct player_plugin *(*setup_syms) (void);
   char id[FILEPATH_LEN_MAX];
   char version[FILEPATH_LEN_MAX];
   char copyright[FILEPATH_LEN_MAX];

   EDBUG(4, "loadPlayerSyms");
   if (!plug)
      EDBUG_RETURN(FALSE);
   plug->handle = dlopen(plug->soname, RTLD_NOW);
   if (!plug->handle)
      EDBUG_RETURN(FALSE);
   setup_syms = (struct player_plugin * (*)(void)) (dlsym(plug->handle, "setup_plugin"));
   if (setup_syms)
      temp = setup_syms();
   if (!temp)
      EDBUG_RETURN(FALSE);
   plug->init = temp->init;
   plug->config = temp->config;
   plug->seek_to_frame = temp->seek_to_frame;
   plug->play = temp->play;
   plug->pause_it = temp->pause_it;
   plug->stop = temp->stop;
   plug->is_file = temp->is_file;
   plug->get_info = temp->get_info;
   plug->version_info = temp->version_info;
   if ((error = dlerror()) != NULL) {
      fprintf(stderr, "%s\n", error);
      exit(-1);
   }
   plug->version_info(id, version, copyright);
   if (plug->id)
      Efree(plug->id);
   plug->id = duplicate(id);
   if (plug->version)
      Efree(plug->version);
   plug->version = duplicate(version);
   if (plug->copyright)
      Efree(plug->copyright);
   plug->copyright = duplicate(copyright);
   plug->loaded = TRUE;
   plug->init();
   players->number++;
   Efree(temp);
   EDBUG_RETURN(TRUE);
}

int LoadPlayerPlugin(struct player_plugin *plug)
{
   int i = FALSE;

   EDBUG(4, "LoadPlayerPlugin");
   if (!plug->loaded) {
      i = loadPlayerSyms(plug);
      if (i) {
	 plug->loaded = TRUE;
	 plug->init();
      }
   }
   EDBUG_RETURN(i);
}

void InitPlayers(char *path)
{
   struct player_plugin *cur = NULL;
   char *tempname, *buffer;
   FILE *temp;
   int i = 0;

   EDBUG(4, "InitPlayers");
   fprintf(stderr, "Looking for plugins...\n");
   players = Emalloc(sizeof(Players));
   players->first = DummyPlayer();
   cur = players->first;
   players->number = 1;
   tempname = Emalloc(FILEPATH_LEN_MAX);
   tmpnam(tempname);
   if (!(temp = fopen(tempname, "w"))) {
      fprintf(stderr, "Couldn't read modules from %s\n", path);
      Efree(tempname);
      EDBUG_RETURN_;
   }
   if (strlen(path) > 1)
      if (path[(strlen(path) - 1)] == '/')
	 path[(strlen(path) - 1)] = '\0';
   i = dodirtolist(path, "*.so.0", temp, 0);
   fclose(temp);
   fprintf(stderr, "     Player Modules:\n");
   if (!i) {
      if (!(temp = fopen(tempname, "r"))) {
	 fprintf(stderr, "Couldn't read modules from %s\n", path);
	 Efree(tempname);
	 EDBUG_RETURN_;
      }
      buffer = Emalloc(FILEPATH_LEN_MAX);
      memset(buffer, 0, FILEPATH_LEN_MAX);
      cur->next = Emalloc(sizeof(struct player_plugin));

      while (GetNextLine(buffer, temp)) {
	 cur->next->soname = duplicate(buffer);
	 cur->next->id = cur->next->version = cur->next->copyright = NULL;
	 if (loadPlayerSyms(cur->next)) {
	    cur = cur->next;
	    printf("\t%s %s, (C) %s\n", cur->id, cur->version, cur->copyright);
	 }
	 else {
	    fprintf(stderr, "%s\n", dlerror());
	    exit(-1);
	 }
	 cur->next = Emalloc(sizeof(struct player_plugin));
      }
      players->current = players->first;
      fclose(temp);
      Efree(buffer);
   }
   if (cur->next)
      Efree(cur->next);
   cur->next = NULL;
   rm(tempname);
   Efree(tempname);
   printf("\n");
   EDBUG_RETURN_;
}

void FreePlayers(void)
{
   struct player_plugin *cur, *prev;

   EDBUG(4, "FreePlayers");
   if (!players)
      EDBUG_RETURN_;
   cur = players->first;
   while (cur) {
      prev = cur;
      cur = cur->next;
      if (prev->loaded)
	 UnloadPlayerPlugin(prev);
      Efree(prev->id);
      Efree(prev->version);
      Efree(prev->copyright);
      Efree(prev);
      prev = NULL;
   }
   Efree(players);
   players = NULL;
   EDBUG_RETURN_;
}

struct analysis_plugin *ReturnAnalysisPlugin(char *search)
{
   struct analysis_plugin *cur;

   EDBUG(4, "ReturnAnalysisPlugin");
   if (!analysis)
      EDBUG_RETURN(NULL);
   cur = analysis->first;
   while (cur) {
      if (!strcasecmp(search, cur->id))
	 EDBUG_RETURN(cur);
      if (strstr(cur->id, search))
	 EDBUG_RETURN(cur);
      cur = cur->next;
   }
   EDBUG_RETURN(NULL);
}

int init_analysis_none(Window win, int w, int h)
{
   return 0;
}

void do_analysis_none(char *buffer, int size)
{
   usleep(500);
}

void close_analysis_none(void)
{
}

struct analysis_plugin *DummyAnalysis(void)
{
   struct analysis_plugin *cur;
   cur = Emalloc(sizeof(struct analysis_plugin));

   EDBUG(6, "DummyAnalysis");
   cur->init_analysis = init_analysis_none;
   cur->do_analysis = do_analysis_none;
   cur->close_analysis = close_analysis_none;
   cur->version_info = NULL;
   cur->id = duplicate("none");
   cur->version = NULL;
   cur->copyright = NULL;
   cur->handle = NULL;
   cur->next = NULL;
   EDBUG_RETURN(cur);
}

void InitAnalysis(char *path)
{
   struct analysis_plugin *cur = NULL;
   char *tempname, *buffer, *soname;
   FILE *temp;
   void *handle = NULL;
   int i = 0;

   EDBUG(4, "InitAnalysis");
   analysis = Emalloc(sizeof(Analysis));
   analysis->first = DummyAnalysis();
   cur = analysis->first;
   analysis->number = 1;
   tempname = Emalloc(FILEPATH_LEN_MAX);
   tmpnam(tempname);
   if (!(temp = fopen(tempname, "w"))) {
      fprintf(stderr, "Couldn't read modules from %s\n", path);
      Efree(tempname);
      EDBUG_RETURN_;
   }
   if (strlen(path) > 1)
      if (path[(strlen(path) - 1)] == '/')
	 path[(strlen(path) - 1)] = '\0';
   i = dodirtolist(path, "*.so.0", temp, 0);
   fclose(temp);
   printf("     Analysis Modules:\n");
   if (!i) {
      if (!(temp = fopen(tempname, "r"))) {
	 fprintf(stderr, "Couldn't read modules from %s\n", path);
	 Efree(tempname);
	 EDBUG_RETURN_;
      }
      buffer = Emalloc(FILEPATH_LEN_MAX);
      memset(buffer, 0, FILEPATH_LEN_MAX);
      cur->next = Emalloc(sizeof(struct analysis_plugin));

      while (GetNextLine(buffer, temp)) {
	 soname = duplicate(buffer);
	 handle = dlopen(soname, RTLD_LAZY);
	 Efree(soname);
	 if (handle) {
	    char *error;
	    char id[FILEPATH_LEN_MAX];
	    char version[FILEPATH_LEN_MAX];
	    char copyright[FILEPATH_LEN_MAX];

	    cur = cur->next;
	    cur->handle = handle;
	    cur->init_analysis = (int (*)(Window, int, int)) dlsym(handle, "init_analysis");
	    cur->do_analysis = (void (*)(char *, int)) dlsym(handle, "do_analysis");
	    cur->close_analysis = (void (*)(void)) dlsym(handle, "close_analysis");
	    cur->version_info = (void (*)(char *, char *, char *)) dlsym(handle, "version_info");
	    cur->config_analysis = (void (*)(char *, char *)) dlsym(handle, "config_analysis");
	    if ((error = dlerror()) != NULL) {
	       fprintf(stderr, "%s\n", error);
	       exit(-1);
	    }
	    (*cur->version_info) (id, version, copyright);
	    printf("\t%s %s, (C) %s\n", id, version, copyright);
	    cur->id = duplicate(id);
	    cur->version = duplicate(version);
	    cur->copyright = duplicate(copyright);
	    analysis->number++;
	 }
	 else {
	    fprintf(stderr, "%s\n", dlerror());
	    exit(-1);
	 }
	 cur->next = Emalloc(sizeof(struct analysis_plugin));
      }
      analysis->current = analysis->first;
      fclose(temp);
      Efree(buffer);
   }
   if (cur->next)
      Efree(cur->next);
   cur->next = NULL;
   rm(tempname);
   Efree(tempname);
   printf("\n");
   EDBUG_RETURN_;
}

void FreeAnalysis(void)
{
   struct analysis_plugin *cur, *prev;

   EDBUG(6, "FreeAnalysis");
   if (!analysis)
      EDBUG_RETURN_;
   cur = analysis->first;
   while (cur) {
      prev = cur;
      cur = cur->next;
      Efree(prev->id);
      Efree(prev->version);
      Efree(prev->copyright);
      if (prev->handle)
	 dlclose(prev->handle);
      Efree(prev);
      prev = NULL;
   }
   Efree(analysis);
   analysis = NULL;
   EDBUG_RETURN_
}

int getnumtracks_cda(void)
{
   struct player_plugin *cd;
   int (*getnumtracks) (void);

   EDBUG(4, "getnumtracks_cda");
   cd = ReturnPlayerPlugin("cd");
   if (!cd)
      EDBUG_RETURN(0);
   getnumtracks = (int (*)(void)) dlsym(cd->handle, "getnumtracks");
   if (!getnumtracks)
      EDBUG_RETURN(0);
   EDBUG_RETURN(getnumtracks());
}
