#include "emusic.h"

#define UNDEF   0
#define MAIN    1
#define EMP3    2
#define PLIST   3
#define AMP     4
#define FILEWIN 5
#define AUDIO   6
#define INFO    7
#define ANALYZE 8
#define XMP     9
#define OLD     10
#define PLAYER  11

void splitstring(char *left, char *right, char *data)
{
   EDBUG(7, "splitstring");
   memset(left, 0, strlen(left));
   memset(right, 0, strlen(right));
   sscanf(data, "%s %[^\n]", left, right);
   upstr(left);
   EDBUG_RETURN_;
}

char *upstr(char *src)
{
   int i;

   EDBUG(7, "upstr");
   for (i = 0; i < strlen(src); i++)
      src[i] = toupper(src[i]);
   EDBUG_RETURN(src);
}

void getcoords(char *data, int *x, int *y)
{
   int n;

   EDBUG(7, "getcoords");
   n = sscanf(data, "%i %i", x, y);
   if (n < 2) {
      fprintf(stderr, "Not enough coords on a line that needs em\n");
      exit(-1);
   }
   EDBUG_RETURN_;
}

int parsebool(char *data)
{
   EDBUG(7, "parsebool");
   if (!data)
      EDBUG_RETURN(FALSE);
   data[0] = toupper(data[0]);
   if ((data[0] == 'T') || (data[0] == 'Y') || (data[0] == '1')) {
      EDBUG_RETURN(TRUE);
   }
   else if ((data[0] == 'F') || (data[0] == 'N') || (data[0] == '0')) {
      EDBUG_RETURN(FALSE);
   }
   else {
      fprintf(stderr, "Sorry, don't understand that bool %c.", data[0]);
      exit(-1);
   }
}

void _loadconfig(char *file)
{
   char *home;
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   FILE *in;
   struct player_plugin *config_player = NULL;
   struct analysis_plugin *config_analyzer = NULL;
   int context = UNDEF;

   EDBUG(2, "_loadconfig");
   home = duplicate(HomeDir);
   home = Erealloc(home, strlen(home) + strlen(file) + 2);
   strcat(home, file);
   if ((in = fopen(home, "r")) == NULL) {
      char *home2, *temp1, *temp2;

      fprintf(stderr, "Error, I can't find your %s, installing default\n", home);
      home2 = duplicate(HomeDir);
      home2 = Erealloc(home2, strlen(home2) + 10);
      strcat(home2, "/.emusic");
      if (!isdir(home2))
	 md(home2);
      free(home2);
      temp1 = Emalloc(strlen(ThemeDir) + strlen(file) + 2);
      strcpy(temp1, ThemeDir);
      temp2 = strrchr(file, '/');
      strcat(temp1, temp2);
      cp(temp1, home);
      if ((in = fopen(home, "r")) == NULL) {
	 fprintf(stderr, "Error in copying %s to ~/.emusic, do it manually\n",
		 temp1);
	 exit(-1);
      }
      Efree(temp1);
      Efree(home);
   }
   while (GetNextLine(st, in)) {
      splitstring(s1, s2, st);
      if (!strncmp("BEGIN", s1, 5)) {
	 if (!(config_player = ReturnPlayerPlugin(s2))) {
	    if (!(config_analyzer = ReturnAnalysisPlugin(s2))) {
	       upstr(s2);
	       if (!strncmp("MAIN", s2, 4))
		  context = MAIN;
	       else if (!strncmp("EMUSIC", s2, 4))
		  context = OLD;
	       else if (!strncmp("PLAYEDITWIN", s2, 5))
		  context = OLD;
	       else if (!strncmp("FILE", s2, 4))
		  context = OLD;
	       else if (!strncmp("AUDIO", s2, 5))
		  context = AUDIO;
	       else
		  context = UNDEF;
	    }
	    else
	       context = ANALYZE;
	 }
	 else
	    context = PLAYER;
      }
      if (context == MAIN)
	 ConfigMain(s1, s2);
      else if (context == AUDIO)
	 ConfigAudio(s1, s2);
      else if (context == PLAYER) {
	 if (!config_player->loaded)
	    if (LoadPlayerPlugin(config_player))
	       continue;
	 config_player->config(s1, s2);
      }
      else if (context == ANALYZE)
	 config_analyzer->config_analysis(s1, s2);
      else if (context == OLD) {
	 fprintf(stderr, "old style config..  quitting so you can update\n");
	 exit(-1);
      }
      if (!strncmp("END", s1, 3))
	 context = UNDEF;
   }
   EDBUG_RETURN_;
}

void loadconfig(char *path)
{
   int sucessful = FALSE;

   EDBUG(1, "loadconfig");
   if (path) {
      _loadconfig(path);
      EDBUG_RETURN_;
   }
   if (themepath && !textmode) {
      sucessful = Load_Theme();
      if (!sucessful) {
	 fprintf(stderr, "Couldn't load %s, dying\n", themepath);
	 Unload_Theme(FALSE, NULL);
	 exit(-1);
      }
   }
   else if (!textmode) {
      fprintf(stderr, "No theme specified, and not in textmode, so I'm dying...\n");
      exit(-1);
   }
   EDBUG_RETURN_;
}
