
#include "emusic.h"

int LoadCacheItem(struct playlist_item *song)
{
   char *filename;
   FILE *file;
   char buffer[FILEPATH_LEN_MAX];
   char *temp;

   EDBUG(7, "LoadCacheItem");
   filename = Emalloc(strlen(HomeDir) + strlen(song->path) + 20);
   strcpy(filename, HomeDir);
   strcat(filename, "/.emusic/.cache/");
   strcat(filename, song->path);
   if (!exists(filename))
      EDBUG_RETURN(FALSE);
   if (!(file = fopen(filename, "r")))
      EDBUG_RETURN(FALSE);
   Efree(filename);
   fgets(buffer, FILEPATH_LEN_MAX, file);
   if (song->name)
      Efree(song->name);
   temp = strrchr(buffer, '\n');
   temp[0] = '\0';
   song->name = duplicate(buffer);
   fgets(buffer, FILEPATH_LEN_MAX, file);
   song->length = atoi(buffer);
   fgets(buffer, FILEPATH_LEN_MAX, file);
   temp = strrchr(buffer, '\n');
   temp[0] = '\0';
   temp = duplicate(buffer);
   song->player = ReturnPlayerPlugin(buffer);
   fclose(file);
   EDBUG_RETURN(TRUE);
}

void SaveItemCache(struct playlist_item *song)
{
   char *filename;
   FILE *file;
   int dummy;
   char *temp = Emalloc(strlen(song->name) + 1);

   EDBUG(7, "SaveItemCache");
   filename = Emalloc(strlen(HomeDir) + strlen(song->path) + 20);
   strcpy(filename, HomeDir);
   strcat(filename, "/.emusic/.cache/");
   strcat(filename, song->path);
   if (!exists(filename))
      mkdirs(filename);
   if (!(file = fopen(filename, "w")))
      EDBUG_RETURN_;
   if (!sscanf(song->name, "(%d) - %[^\n]", &dummy, temp))
      strcpy(temp, song->name);
   fprintf(file, "%s\n", temp);
   fprintf(file, "%d\n", song->length);
   fprintf(file, "%s\n", song->player->id);
   fclose(file);
   Efree(filename);
   EDBUG_RETURN_;
}
