/*  VER 011   TAB P   $Id: mfilter.c,v 1.5 1998/09/09 07:32:12 src Exp $
 *
 *  filter based on message ID
 *
 *  copyright 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: mfilter.c,v $
 *  Revision 1.5  1998/09/09 07:32:12  src
 *  Version 1.1
 *
 *  Revision 1.4  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.3  1998/07/12 09:39:29  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"

#include <fcntl.h>

/*
 *  return a status as to whether the message should be removed
 *  based on the message ID
 */
int  
do_mfilter(char *msgid)
{
    int inf,outf;
    int st;
    char buf[2048];

    if (!mfilter) return 0;

    progtitle("mfilter");
    inf = open("/dev/null",O_RDWR);
    outf = dup(inf);      
    /* BUG: silly... */
    sprintf(buf, "%1024.1024s \"%512.512s\"",mfilter,msgid);
    st = script(buf,inf,outf);
    close(inf);
    close(outf);

    switch (st) {
    case -1:
	log_msg(L_ERR,"can't run mfilter: %s",mfilter);
	mfilter = 0; /* give up filter */
	return 0;
    case 0:
	log_msg(L_DEBUGMORE,"no filter for %s",msgid);
	return 0;
    default:
	log_msg(L_DEBUG,"filtering %s",msgid);
	return 1;
    }
}

