/*  VER 057  TAB P   $Id: history.c,v 1.10 1998/09/14 05:27:34 src Exp $
 *  
 *  history database lookup
 *
 *  copyright 1996, 1997, 1998 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: history.c,v $
 *  Revision 1.10  1998/09/14 05:27:34  src
 *  Declared offset
 *
 *  Revision 1.9  1998/09/09 07:32:11  src
 *  Version 1.1
 *
 *  Revision 1.8  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.7  1998/07/12 09:39:28  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "news.h"

#include <errno.h>

#if WITH_HISTORY

#ifdef HAVE_LIBDBZ
#  include <dbz.h>
#  undef HAVE_LIBDBM
#else
#  ifdef HAVE_LIBDBM
#    include <dbm.h>
#  else
#    include "../dbz/dbz.h"
#  endif
#endif

#ifndef HAVE_LIBDBM
#if DBZ_VERSION==6
#  define dbminit   dbzinit
#  define dbmclose  dbzclose
#else
#  define dbminit   dbzdbminit
#  define fetch     dbzdbmfetch
#  define dbmclose  dbzdbmclose
#endif
#endif

/* negative if error (or disable) */
int hist_open = 0;

/*
 *  look up history database
 *  will convert message ID to news character case conventions
 *  return true if found there
 */
int 
history_lookup(char *msgid)
{
    if (hist_open <= 0) {
	if (hist_open == 0) {
	    char historyname[PATH_MAX];
	
	    build_alt_filename(historyname,news_home(),HISTORY,history);

	    if (dbminit(historyname) == -1) {
		if (errno == EDOM)
		    log_msg(L_ERR,"database \"%s\" in wrong format",historyname);
		else 
		    log_msg(L_ERRno,"can't open database \"%s\"",historyname);
		hist_open = -1;
		return 0;
	    }
	    log_msg(L_DEBUGMORE,"history file %s opened",historyname);
	    hist_open = 1;
	} else {
	    return 0;
	}
    } 

    /* 
     *  look up database 
     */
#if DBZ_VERSION==6
    {
	HASH key = HashMessageID(msgid);
#  ifdef DO_TAGGED_HASH
	OFFSET_T offset = dbzfetch(key);
#  else
	idxrec ionevalue;
	idxrecext iextvalue;
	int offset = 0;
	if (innconf->extendeddbz) {
	    if (!dbzfetch(key, &iextvalue))
		offset = -1;
	    /* offset = iextvalue.offset[HISTOFFSET]; */
	} else {
	    if (!dbzfetch(key, &ionevalue))
		offset = -1;
	    /* offset = ionevalue.offset; */
	}
#  endif
	if (offset < 0) {
	    log_msg(L_DEBUGMORE,"msgid %s not in history",msgid);
	    return 0;
	}
    }
#else
    {
	/*
	 *  dbz v.3
	 */
	datum key;
	datum val;
	char *p;
	int len = strlen(msgid);

	/* convert host name to lower case */
	if ((p = strchr(msgid,'@'))) {
	    while (*++p) *p = tolower(*p);
	}

	key.dptr = msgid;
	key.dsize = len+1;
	
	val = fetch(key);
	if (!(val.dptr)) {
	    log_msg(L_DEBUGMORE,"msgid %s not in history",msgid);
	    return 0;
	}
    }
#endif
    /* OK, we found it */
    return 1;
}

/*
 *  done with history database
 */
void 
history_done(void)
{
    if (hist_open > 0) {
	dbmclose();
	hist_open = 0; 
    }
}

#else /* WITH_HISTORY */

int 
history_lookup(char *msgid) 
{   return 0; 
}
void 
history_done(void)
{ 
}
#endif
