/*
   Pathetic Writer
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

/*
   Module name:    selection.c

   This module handles selection: grabbing, releasing, cutting, pasting.

   The selection uses a custom target PW_BLOCK, which is simple
   plaintext. No formatting is preserved.

   All in all, plenty good enough for now.
*/

#include <stdio.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/StdSel.h>

#include "../common/cmalloc.h"
#include "../common/fonts.h"

#include "../pw/pw.h"
#include "xpw.h"

Atom target_atom;	/* used for selection */

int pack_string_selection(buffer *buf, char *data,
		int r1, int c1, int r2, int c2)
{
	int n = 0;

	if (r2 > line_last_used(buf)) r2 = line_last_used(buf);
	while (n < 30000 && (r1 < r2 || (r1 == r2 && c1 <= c2))) {
		int c = peek_char(buf, r1, c1);
		data[n++] = c?c:'\n';
		if (c1 < line_length(buf, r1)) c1++;
		else r1++, c1 = 0;
	}
	data[n] = '\0';
	return 0;
}

/* this one only does plaintext for now */
int pack_selection(buffer *buf, char *data,
		int r1, int c1, int r2, int c2)
{
	return pack_string_selection(buf, data, r1, c1, r2, c2);
}

Boolean convert_proc(Widget w,
	Atom *selection, Atom *target, Atom *type_return,
	XtPointer *value_return, unsigned long *length_return,
	int *format_return)
{
	window *wl = find_window_by_widget(w);
	XSelectionRequestEvent *req = XtGetSelectionRequest(w,
		*selection, (XtRequestId) NULL);

	/* handle all required atoms, and the one that we use */
	/* Xt already handles MULTIPLE, no branch necessary */
	if (*target == XA_TARGETS(XtDisplay(w))) {
		Atom *targetP;
		Atom *std_targets;
		unsigned long std_length;
		XmuConvertStandardSelection(w, req->time, selection,
			target, type_return,
			(XPointer *)&std_targets,
			&std_length, format_return);
		*value_return = XtMalloc(sizeof(Atom)*(std_length+1));
		targetP = *(Atom **)value_return;
		*length_return = std_length+1;
		*targetP++ = target_atom;
		memcpy(targetP, std_targets, sizeof(Atom)*std_length);
		XtFree((char *)std_targets);
		*type_return = XA_ATOM;
		*format_return = sizeof(Atom)*8;
		return True;
	} else if (*target == target_atom) {
		/* handle normal selection */
		char *data;

		/* Use a fixed size buffer for now */
		*length_return = 32000;

		data = XtMalloc(*length_return);
		pack_selection(wl->buf, data,
				wl->blku.row, wl->blku.col,
				wl->blkl.row, wl->blkl.col);

		*value_return = data;

		*type_return = target_atom;

		*format_return = 8;
		return True;
	} else if (*target == XA_STRING) {
		/* handle string selections (from outside PW) */
		char *data;
		*length_return = 32000;
		data = XtMalloc(*length_return);
		pack_string_selection(wl->buf, data,
			wl->blku.row, wl->blku.col,
			wl->blkl.row, wl->blkl.col);
		*value_return = data;
		*length_return = strlen(data);
		*type_return = XA_STRING;
		*format_return = 8;
		return True;
	} else {
		if (XmuConvertStandardSelection(w, CurrentTime, selection,
				target, type_return, (XPointer *)value_return,
				length_return, format_return))
			return True;
		else {
			XtWarning("PW: unsupported selection type\n");
			return False;
		}
	}
	/*NOTREACHED*/
}

void lose_ownership_proc(Widget w, Atom *selection)
{
	window *wl = find_window_by_widget(w);

	wl->blku.row = wl->blku.col = -1;
	wl->blkl.row = wl->blkl.col = -1;

	pr_scr_flag = TRUE;	/* Is this enough? */	
	show_cur(wl);
}

void transfer_done_proc(void)
{
	; /* no need to do anything at all */
}

int unpack_string_selection(buffer *buf, char *data, int row, int col)
{
	char *p;

	while (*data) {		/* NUL marks end of data */
		p = strchr(data, '\n');		/* look for eol */
		if (p) {	/* found one; copy data, then split line */
			*p = '\0';
			ins_text(buf, make_position(row, col),
				(unsigned char *)data,
				ret_format(buf, row, col));
			split_line(buf, row, col+strlen(data));
			row++;
			col = 0;
			data = p+1;	/* start of next line */
		} else {	/* last line; copy data, no split */
			ins_text(buf, make_position(row, col),
				(unsigned char *)data,
				ret_format(buf, row, col));
			data += strlen(data);	/* end of data */
		}
	}
	return 0;
}

int unpack_selection(buffer *buf, char *data, int row, int col)
{
	return unpack_string_selection(buf, data, row, col);
}

void string_requestor_callback(Widget w, XtPointer client_data,
        Atom *selection, Atom *type, XtPointer value,
        unsigned long *length, int *format)
{
        if ((value == NULL) && (*length == 0)) {
                XBell(XtDisplay(w), 100);
                XtWarning("PW: no selection or selection timed out\n");
        } else {
                unpack_string_selection(w_list->buf, (char *)value,
                        get_point(w_list).row, get_point(w_list).col);
                w_list->buf->change = TRUE;
                XtFree((char *)value);
                pr_scr_flag = TRUE;
        }
	show_cur(w_list);
}

void requestor_callback(Widget w, XtPointer client_data,
	Atom *selection, Atom *type, XtPointer value,
	unsigned long *length, int *format)
{
	if ((value == NULL) && (*length == 0)) {
        /* if we asked for a PW_BLOCK and got a null response,
           we'll ask again, this time for an XA_STRING */
                XtGetSelectionValue(w, XA_PRIMARY, XA_STRING,
                        string_requestor_callback,
                        NULL, CurrentTime);     /* NULL is bogus event */
	} else {
		unpack_selection(w_list->buf, (char *)value,
			get_point(w_list).row, get_point(w_list).col);
		w_list->buf->change = TRUE;

		XtFree((char *)value);
		pr_scr_flag = TRUE;
	}
	show_cur(w_list);
}

