/* Primitives for scale/offset transforms. */

#ifndef XFORM_H
#define XFORM_H

#include "rect.h"

typedef struct xform {
  double scale;
  double off_x, off_y;
} xform;

void xform_point (point *dst, const xform *x, const point *src);
void xform_rect (rect *dst, const xform *x, const rect *src);
void xform_inv (xform *dst, const xform *src);
/* This is also where xform_compose would go. */

/* Would transformations of regions go here or in region? Probably in
   region, just because there's a lot more region stuff than xform
   stuff going on in those routines. That just goes to show you the
   perils of breaking code into modules. */

#endif
