/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Dick Porter <dick@cymru.net>
 *
 */

#ifndef _ORBIT_IR_H_
#define _ORBIT_IR_H_

#include "orbit_types.h"

extern void CORBA_IRObject_destroy(
	CORBA_IRObject obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_IRObject__get_def_kind(
	CORBA_IRObject obj,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_Contained_describe(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern void CORBA_Contained_move(
	CORBA_Contained obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_Contained__get_id(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern void CORBA_Contained__set_id(
	CORBA_Contained obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_Contained__get_name(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern void CORBA_Contained__set_name(
	CORBA_Contained obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_Contained__get_version(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern void CORBA_Contained__set_version(
	CORBA_Contained obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_Contained__get_defined_in(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_Contained__get_absolute_name(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_Contained__get_containing_repository(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern void CORBA_Contained_destroy(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_Contained__get_def_kind(
	CORBA_Contained obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_IDLType__get_type(
	CORBA_IDLType obj,
	CORBA_Environment *ev);

extern void CORBA_IDLType_destroy(
	CORBA_IDLType obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_IDLType__get_def_kind(
	CORBA_IDLType obj,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_Container_lookup(
	CORBA_Container obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_Container_contents(
	CORBA_Container obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_Container_lookup_name(
	CORBA_Container obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_Container_describe_contents(
	CORBA_Container obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_Container_create_module(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_Container_create_constant(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_Container_create_struct(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_Container_create_union(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_Container_create_enum(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_Container_create_alias(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_Container_create_interface(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_Container_create_exception(
	CORBA_Container obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern void CORBA_Container_destroy(
	CORBA_Container obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_Container__get_def_kind(
	CORBA_Container obj,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_Repository_lookup_id(
	CORBA_Repository obj,
	CORBA_RepositoryId search_id,
	CORBA_Environment *ev);

extern CORBA_PrimitiveDef *CORBA_Repository_get_primitive(
	CORBA_Repository obj,
	CORBA_PrimitiveKind kind,
	CORBA_Environment *ev);

extern CORBA_StringDef *CORBA_Repository_create_string(
	CORBA_Repository obj,
	CORBA_unsigned_long bound,
	CORBA_Environment *ev);

extern CORBA_WstringDef *CORBA_Repository_create_wstring(
	CORBA_Repository obj,
	CORBA_unsigned_long bound,
	CORBA_Environment *ev);

extern CORBA_SequenceDef *CORBA_Repository_create_sequence(
	CORBA_Repository obj,
	CORBA_unsigned_long bound,
	CORBA_IDLType element_type,
	CORBA_Environment *ev);

extern CORBA_ArrayDef *CORBA_Repository_create_array(
	CORBA_Repository obj,
	CORBA_unsigned_long length,
	CORBA_IDLType element_type,
	CORBA_Environment *ev);

extern CORBA_FixedDef *CORBA_Repository_create_fixed(
	CORBA_Repository obj,
	CORBA_unsigned_short digits,
	CORBA_short scale,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_Repository_lookup(
	CORBA_Repository obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_Repository_contents(
	CORBA_Repository obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_Repository_lookup_name(
	CORBA_Repository obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_Repository_describe_contents(
	CORBA_Repository obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_Repository_create_module(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_Repository_create_constant(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_Repository_create_struct(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_Repository_create_union(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_Repository_create_enum(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_Repository_create_alias(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_Repository_create_interface(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_Repository_create_exception(
	CORBA_Repository obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern void CORBA_Repository_destroy(
	CORBA_Repository obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_Repository__get_def_kind(
	CORBA_Repository obj,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_ModuleDef_lookup(
	CORBA_ModuleDef obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_ModuleDef_contents(
	CORBA_ModuleDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_ModuleDef_lookup_name(
	CORBA_ModuleDef obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_ModuleDef_describe_contents(
	CORBA_ModuleDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_ModuleDef_create_module(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_ModuleDef_create_constant(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_ModuleDef_create_struct(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_ModuleDef_create_union(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_ModuleDef_create_enum(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_ModuleDef_create_alias(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_ModuleDef_create_interface(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_ModuleDef_create_exception(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern void CORBA_ModuleDef_destroy(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_ModuleDef__get_def_kind(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_ModuleDef_describe(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern void CORBA_ModuleDef_move(
	CORBA_ModuleDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_ModuleDef__get_id(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern void CORBA_ModuleDef__set_id(
	CORBA_ModuleDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_ModuleDef__get_name(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern void CORBA_ModuleDef__set_name(
	CORBA_ModuleDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_ModuleDef__get_version(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern void CORBA_ModuleDef__set_version(
	CORBA_ModuleDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_ModuleDef__get_defined_in(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_ModuleDef__get_absolute_name(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_ModuleDef__get_containing_repository(
	CORBA_ModuleDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_ConstantDef__get_type(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_ConstantDef__get_type_def(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef__set_type_def(
	CORBA_ConstantDef obj,
	CORBA_IDLType type_def,
	CORBA_Environment *ev);

extern CORBA_any *CORBA_ConstantDef__get_value(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef__set_value(
	CORBA_ConstantDef obj,
	CORBA_any value,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef_move(
	CORBA_ConstantDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_ConstantDef__get_id(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef__set_id(
	CORBA_ConstantDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_ConstantDef__get_name(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef__set_name(
	CORBA_ConstantDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_ConstantDef__get_version(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef__set_version(
	CORBA_ConstantDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_ConstantDef__get_defined_in(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_ConstantDef__get_absolute_name(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_ConstantDef__get_containing_repository(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern void CORBA_ConstantDef_destroy(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_ConstantDef__get_def_kind(
	CORBA_ConstantDef obj,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_TypedefDef_describe(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern void CORBA_TypedefDef_move(
	CORBA_TypedefDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_TypedefDef__get_id(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern void CORBA_TypedefDef__set_id(
	CORBA_TypedefDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_TypedefDef__get_name(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern void CORBA_TypedefDef__set_name(
	CORBA_TypedefDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_TypedefDef__get_version(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern void CORBA_TypedefDef__set_version(
	CORBA_TypedefDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_TypedefDef__get_defined_in(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_TypedefDef__get_absolute_name(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_TypedefDef__get_containing_repository(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern void CORBA_TypedefDef_destroy(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_TypedefDef__get_def_kind(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_TypedefDef__get_type(
	CORBA_TypedefDef obj,
	CORBA_Environment *ev);

extern CORBA_StructMemberSeq *CORBA_StructDef__get_members(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern void CORBA_StructDef__set_members(
	CORBA_StructDef obj,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_StructDef_describe(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern void CORBA_StructDef_move(
	CORBA_StructDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_StructDef__get_id(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern void CORBA_StructDef__set_id(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_StructDef__get_name(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern void CORBA_StructDef__set_name(
	CORBA_StructDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_StructDef__get_version(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern void CORBA_StructDef__set_version(
	CORBA_StructDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_StructDef__get_defined_in(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_StructDef__get_absolute_name(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_StructDef__get_containing_repository(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern void CORBA_StructDef_destroy(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_StructDef__get_def_kind(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_StructDef__get_type(
	CORBA_StructDef obj,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_StructDef_lookup(
	CORBA_StructDef obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_StructDef_contents(
	CORBA_StructDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_StructDef_lookup_name(
	CORBA_StructDef obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_StructDef_describe_contents(
	CORBA_StructDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_StructDef_create_module(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_StructDef_create_constant(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_StructDef_create_struct(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_StructDef_create_union(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_StructDef_create_enum(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_StructDef_create_alias(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_StructDef_create_interface(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_StructDef_create_exception(
	CORBA_StructDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_UnionDef__get_discriminator_type(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_UnionDef__get_discriminator_type_def(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef__set_discriminator_type_def(
	CORBA_UnionDef obj,
	CORBA_IDLType discriminator_type_def,
	CORBA_Environment *ev);

extern CORBA_UnionMemberSeq *CORBA_UnionDef__get_members(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef__set_members(
	CORBA_UnionDef obj,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_UnionDef_describe(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef_move(
	CORBA_UnionDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_UnionDef__get_id(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef__set_id(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_UnionDef__get_name(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef__set_name(
	CORBA_UnionDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_UnionDef__get_version(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef__set_version(
	CORBA_UnionDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_UnionDef__get_defined_in(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_UnionDef__get_absolute_name(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_UnionDef__get_containing_repository(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern void CORBA_UnionDef_destroy(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_UnionDef__get_def_kind(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_UnionDef__get_type(
	CORBA_UnionDef obj,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_UnionDef_lookup(
	CORBA_UnionDef obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_UnionDef_contents(
	CORBA_UnionDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_UnionDef_lookup_name(
	CORBA_UnionDef obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_UnionDef_describe_contents(
	CORBA_UnionDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_UnionDef_create_module(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_UnionDef_create_constant(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_UnionDef_create_struct(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_UnionDef_create_union(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_UnionDef_create_enum(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_UnionDef_create_alias(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_UnionDef_create_interface(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_UnionDef_create_exception(
	CORBA_UnionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumMemberSeq *CORBA_EnumDef__get_members(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern void CORBA_EnumDef__set_members(
	CORBA_EnumDef obj,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_EnumDef_describe(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern void CORBA_EnumDef_move(
	CORBA_EnumDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_EnumDef__get_id(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern void CORBA_EnumDef__set_id(
	CORBA_EnumDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_EnumDef__get_name(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern void CORBA_EnumDef__set_name(
	CORBA_EnumDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_EnumDef__get_version(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern void CORBA_EnumDef__set_version(
	CORBA_EnumDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_EnumDef__get_defined_in(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_EnumDef__get_absolute_name(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_EnumDef__get_containing_repository(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern void CORBA_EnumDef_destroy(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_EnumDef__get_def_kind(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_EnumDef__get_type(
	CORBA_EnumDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_AliasDef__get_original_type_def(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern void CORBA_AliasDef__set_original_type_def(
	CORBA_AliasDef obj,
	CORBA_IDLType original_type_def,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_AliasDef_describe(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern void CORBA_AliasDef_move(
	CORBA_AliasDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_AliasDef__get_id(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern void CORBA_AliasDef__set_id(
	CORBA_AliasDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_AliasDef__get_name(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern void CORBA_AliasDef__set_name(
	CORBA_AliasDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_AliasDef__get_version(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern void CORBA_AliasDef__set_version(
	CORBA_AliasDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_AliasDef__get_defined_in(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_AliasDef__get_absolute_name(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_AliasDef__get_containing_repository(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern void CORBA_AliasDef_destroy(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_AliasDef__get_def_kind(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_AliasDef__get_type(
	CORBA_AliasDef obj,
	CORBA_Environment *ev);

extern CORBA_PrimitiveKind CORBA_PrimitiveDef__get_kind(
	CORBA_PrimitiveDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_PrimitiveDef__get_type(
	CORBA_PrimitiveDef obj,
	CORBA_Environment *ev);

extern void CORBA_PrimitiveDef_destroy(
	CORBA_PrimitiveDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_PrimitiveDef__get_def_kind(
	CORBA_PrimitiveDef obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_long CORBA_StringDef__get_bound(
	CORBA_StringDef obj,
	CORBA_Environment *ev);

extern void CORBA_StringDef__set_bound(
	CORBA_StringDef obj,
	CORBA_unsigned_long bound,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_StringDef__get_type(
	CORBA_StringDef obj,
	CORBA_Environment *ev);

extern void CORBA_StringDef_destroy(
	CORBA_StringDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_StringDef__get_def_kind(
	CORBA_StringDef obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_long CORBA_WstringDef__get_bound(
	CORBA_WstringDef obj,
	CORBA_Environment *ev);

extern void CORBA_WstringDef__set_bound(
	CORBA_WstringDef obj,
	CORBA_unsigned_long bound,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_WstringDef__get_type(
	CORBA_WstringDef obj,
	CORBA_Environment *ev);

extern void CORBA_WstringDef_destroy(
	CORBA_WstringDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_WstringDef__get_def_kind(
	CORBA_WstringDef obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_short CORBA_FixedDef__get_digits(
	CORBA_FixedDef obj,
	CORBA_Environment *ev);

extern void CORBA_FixedDef__set_digits(
	CORBA_FixedDef obj,
	CORBA_unsigned_short digits,
	CORBA_Environment *ev);

extern CORBA_short CORBA_FixedDef__get_scale(
	CORBA_FixedDef obj,
	CORBA_Environment *ev);

extern void CORBA_FixedDef__set_scale(
	CORBA_FixedDef obj,
	CORBA_short scale,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_FixedDef__get_type(
	CORBA_FixedDef obj,
	CORBA_Environment *ev);

extern void CORBA_FixedDef_destroy(
	CORBA_FixedDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_FixedDef__get_def_kind(
	CORBA_FixedDef obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_long CORBA_SequenceDef__get_bound(
	CORBA_SequenceDef obj,
	CORBA_Environment *ev);

extern void CORBA_SequenceDef__set_bound(
	CORBA_SequenceDef obj,
	CORBA_unsigned_long bound,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_SequenceDef__get_element_type(
	CORBA_SequenceDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_SequenceDef__get_element_type_def(
	CORBA_SequenceDef obj,
	CORBA_Environment *ev);

extern void CORBA_SequenceDef__set_element_type_def(
	CORBA_SequenceDef obj,
	CORBA_IDLType element_type_def,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_SequenceDef__get_type(
	CORBA_SequenceDef obj,
	CORBA_Environment *ev);

extern void CORBA_SequenceDef_destroy(
	CORBA_SequenceDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_SequenceDef__get_def_kind(
	CORBA_SequenceDef obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_long CORBA_ArrayDef__get_length(
	CORBA_ArrayDef obj,
	CORBA_Environment *ev);

extern void CORBA_ArrayDef__set_length(
	CORBA_ArrayDef obj,
	CORBA_unsigned_long length,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_ArrayDef__get_element_type(
	CORBA_ArrayDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_ArrayDef__get_element_type_def(
	CORBA_ArrayDef obj,
	CORBA_Environment *ev);

extern void CORBA_ArrayDef__set_element_type_def(
	CORBA_ArrayDef obj,
	CORBA_IDLType element_type_def,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_ArrayDef__get_type(
	CORBA_ArrayDef obj,
	CORBA_Environment *ev);

extern void CORBA_ArrayDef_destroy(
	CORBA_ArrayDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_ArrayDef__get_def_kind(
	CORBA_ArrayDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_ExceptionDef__get_type(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern CORBA_StructMemberSeq *CORBA_ExceptionDef__get_members(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern void CORBA_ExceptionDef__set_members(
	CORBA_ExceptionDef obj,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_ExceptionDef_describe(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern void CORBA_ExceptionDef_move(
	CORBA_ExceptionDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_ExceptionDef__get_id(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern void CORBA_ExceptionDef__set_id(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_ExceptionDef__get_name(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern void CORBA_ExceptionDef__set_name(
	CORBA_ExceptionDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_ExceptionDef__get_version(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern void CORBA_ExceptionDef__set_version(
	CORBA_ExceptionDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_ExceptionDef__get_defined_in(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_ExceptionDef__get_absolute_name(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_ExceptionDef__get_containing_repository(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern void CORBA_ExceptionDef_destroy(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_ExceptionDef__get_def_kind(
	CORBA_ExceptionDef obj,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_ExceptionDef_lookup(
	CORBA_ExceptionDef obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_ExceptionDef_contents(
	CORBA_ExceptionDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_ExceptionDef_lookup_name(
	CORBA_ExceptionDef obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_ExceptionDef_describe_contents(
	CORBA_ExceptionDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_ExceptionDef_create_module(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_ExceptionDef_create_constant(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_ExceptionDef_create_struct(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_ExceptionDef_create_union(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_ExceptionDef_create_enum(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_ExceptionDef_create_alias(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_ExceptionDef_create_interface(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_ExceptionDef_create_exception(
	CORBA_ExceptionDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_AttributeDef__get_type(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_AttributeDef__get_type_def(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef__set_type_def(
	CORBA_AttributeDef obj,
	CORBA_IDLType type_def,
	CORBA_Environment *ev);

extern CORBA_AttributeMode CORBA_AttributeDef__get_mode(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef__set_mode(
	CORBA_AttributeDef obj,
	CORBA_AttributeMode mode,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_AttributeDef_describe(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef_move(
	CORBA_AttributeDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_AttributeDef__get_id(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef__set_id(
	CORBA_AttributeDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_AttributeDef__get_name(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef__set_name(
	CORBA_AttributeDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_AttributeDef__get_version(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef__set_version(
	CORBA_AttributeDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_AttributeDef__get_defined_in(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_AttributeDef__get_absolute_name(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_AttributeDef__get_containing_repository(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern void CORBA_AttributeDef_destroy(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_AttributeDef__get_def_kind(
	CORBA_AttributeDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_OperationDef__get_result(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern CORBA_IDLType *CORBA_OperationDef__get_result_def(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_result_def(
	CORBA_OperationDef obj,
	CORBA_IDLType result_def,
	CORBA_Environment *ev);

extern CORBA_ParDescriptionSeq *CORBA_OperationDef__get_params(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_params(
	CORBA_OperationDef obj,
	CORBA_ParDescriptionSeq *params,
	CORBA_Environment *ev);

extern CORBA_OperationMode CORBA_OperationDef__get_mode(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_mode(
	CORBA_OperationDef obj,
	CORBA_OperationMode mode,
	CORBA_Environment *ev);

extern CORBA_ContextIdSeq *CORBA_OperationDef__get_contexts(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_contexts(
	CORBA_OperationDef obj,
	CORBA_ContextIdSeq *contexts,
	CORBA_Environment *ev);

extern CORBA_ExceptionDefSeq *CORBA_OperationDef__get_exceptions(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_exceptions(
	CORBA_OperationDef obj,
	CORBA_ExceptionDefSeq *exceptions,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_OperationDef_describe(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef_move(
	CORBA_OperationDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_OperationDef__get_id(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_id(
	CORBA_OperationDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_OperationDef__get_name(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_name(
	CORBA_OperationDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_OperationDef__get_version(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef__set_version(
	CORBA_OperationDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_OperationDef__get_defined_in(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_OperationDef__get_absolute_name(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_OperationDef__get_containing_repository(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern void CORBA_OperationDef_destroy(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_OperationDef__get_def_kind(
	CORBA_OperationDef obj,
	CORBA_Environment *ev);

extern CORBA_boolean CORBA_InterfaceDef_is_a(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId interface_id,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef_FullInterfaceDescription *CORBA_InterfaceDef_describe_interface(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_AttributeDef *CORBA_InterfaceDef_create_attribute(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_AttributeMode mode,
	CORBA_Environment *ev);

extern CORBA_OperationDef *CORBA_InterfaceDef_create_operation(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType result,
	CORBA_OperationMode mode,
	CORBA_ParDescriptionSeq *params,
	CORBA_ExceptionDefSeq *exceptions,
	CORBA_ContextIdSeq *contexts,
	CORBA_Environment *ev);

extern CORBA_InterfaceDefSeq *CORBA_InterfaceDef__get_base_interfaces(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern void CORBA_InterfaceDef__set_base_interfaces(
	CORBA_InterfaceDef obj,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_Contained *CORBA_InterfaceDef_lookup(
	CORBA_InterfaceDef obj,
	CORBA_ScopedName search_name,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_InterfaceDef_contents(
	CORBA_InterfaceDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_ContainedSeq *CORBA_InterfaceDef_lookup_name(
	CORBA_InterfaceDef obj,
	CORBA_Identifier search_name,
	CORBA_long levels_to_search,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_Environment *ev);

extern CORBA_Container_DescriptionSeq *CORBA_InterfaceDef_describe_contents(
	CORBA_InterfaceDef obj,
	CORBA_DefinitionKind limit_type,
	CORBA_boolean exclude_inherited,
	CORBA_long max_returned_objs,
	CORBA_Environment *ev);

extern CORBA_ModuleDef *CORBA_InterfaceDef_create_module(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_ConstantDef *CORBA_InterfaceDef_create_constant(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType type,
	CORBA_any value,
	CORBA_Environment *ev);

extern CORBA_StructDef *CORBA_InterfaceDef_create_struct(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_UnionDef *CORBA_InterfaceDef_create_union(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType discriminator_type,
	CORBA_UnionMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_EnumDef *CORBA_InterfaceDef_create_enum(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_EnumMemberSeq *members,
	CORBA_Environment *ev);

extern CORBA_AliasDef *CORBA_InterfaceDef_create_alias(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_IDLType original_type,
	CORBA_Environment *ev);

extern CORBA_InterfaceDef *CORBA_InterfaceDef_create_interface(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Environment *ev);

extern CORBA_ExceptionDef *CORBA_InterfaceDef_create_exception(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Identifier name,
	CORBA_VersionSpec version,
	CORBA_StructMemberSeq *members,
	CORBA_Environment *ev);

extern void CORBA_InterfaceDef_destroy(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_DefinitionKind CORBA_InterfaceDef__get_def_kind(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_Contained_Description *CORBA_InterfaceDef_describe(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern void CORBA_InterfaceDef_move(
	CORBA_InterfaceDef obj,
	CORBA_Container new_container,
	CORBA_Identifier new_name,
	CORBA_VersionSpec new_version,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_InterfaceDef__get_id(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern void CORBA_InterfaceDef__set_id(
	CORBA_InterfaceDef obj,
	CORBA_RepositoryId id,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_InterfaceDef__get_name(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern void CORBA_InterfaceDef__set_name(
	CORBA_InterfaceDef obj,
	CORBA_Identifier name,
	CORBA_Environment *ev);

extern CORBA_VersionSpec CORBA_InterfaceDef__get_version(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern void CORBA_InterfaceDef__set_version(
	CORBA_InterfaceDef obj,
	CORBA_VersionSpec version,
	CORBA_Environment *ev);

extern CORBA_Container *CORBA_InterfaceDef__get_defined_in(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_ScopedName CORBA_InterfaceDef__get_absolute_name(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_Repository *CORBA_InterfaceDef__get_containing_repository(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_InterfaceDef__get_type(
	CORBA_InterfaceDef obj,
	CORBA_Environment *ev);

extern CORBA_boolean CORBA_TypeCode_equal(
	CORBA_TypeCode obj,
	CORBA_TypeCode tc,
	CORBA_Environment *ev);

extern CORBA_TCKind CORBA_TypeCode_kind(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_RepositoryId CORBA_TypeCode_id(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_TypeCode_name(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_long CORBA_TypeCode_member_count(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_Identifier CORBA_TypeCode_member_name(
	CORBA_TypeCode obj,
	CORBA_unsigned_long index,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_TypeCode_member_type(
	CORBA_TypeCode obj,
	CORBA_unsigned_long index,
	CORBA_Environment *ev);

extern CORBA_any *CORBA_TypeCode_member_label(
	CORBA_TypeCode obj,
	CORBA_unsigned_long index,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_TypeCode_discriminator_type(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_long CORBA_TypeCode_default_index(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_long CORBA_TypeCode_length(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_TypeCode CORBA_TypeCode_content_type(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_unsigned_short CORBA_TypeCode_fixed_digits(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_short CORBA_TypeCode_fixed_scale(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_long CORBA_TypeCode_param_count(
	CORBA_TypeCode obj,
	CORBA_Environment *ev);

extern CORBA_any *CORBA_TypeCode_parameter(
	CORBA_TypeCode obj,
	CORBA_long index,
	CORBA_Environment *ev);

#endif /* !_ORBIT_IR_H_ */
