#include "orbit-c-backend.h"

#include <stdlib.h>
#include <string.h>

typedef struct {
  FILE *of;
  IDL_tree tree, extra;
  GArray *subnames, *subtypes, *sublabels;
} CBETCInfo;

static void orbit_tc_do_type_enum(CBETCInfo *tci);
static void orbit_tc_do_type_sequence(CBETCInfo *tci);
static void orbit_tc_do_type_struct(CBETCInfo *tci);
static void orbit_tc_do_type_union(CBETCInfo *tci);
static void orbit_tc_do_type_alias(CBETCInfo *tci);

static void
orbit_output_typecode_substruct(FILE *of, IDL_tree ts, char* type, char* name, 
				CORBA_unsigned_long sub_parts, char **array,
				gboolean quote_items)
{
  int i;
  if(!array || !*array)
    return;
  fprintf(of, "const %s TC_", type);
  orbit_cbe_write_typename(of, ts);
  fprintf(of, "_struct_%s[] = {", name);
  for(i = 0; i<sub_parts && array[i]!=NULL; i++) {
    if(i) fprintf(of, ", ");
    if(quote_items)
      fprintf(of, "\"%s\"", array[i]);
    else
      fprintf(of, "%s", array[i]);
  }
  fprintf(of, "};\n\n");
}

static void
orbit_output_typecode_substruct_entry(FILE *of, IDL_tree ts, char* name, 
				      char **array )
{
  if(!array || !*array)
    fprintf(of, "NULL");
  else
    {
      fprintf(of, "TC_");
      orbit_cbe_write_typename(of, ts);
      fprintf(of, "_struct_%s", name);
    }
}

static void
orbit_output_typecode_items(FILE *of, IDL_tree ts,
			    CORBA_TCKind kind,
			    char *name, char *repo_id,
			    CORBA_unsigned_long length,
			    CORBA_unsigned_long sub_parts,
			    char **subnames,
			    char **subtypes,
			    char **sublabels,
			    char *discriminator,
			    CORBA_unsigned_long recurse_depth,
			    CORBA_long default_index,
			    CORBA_unsigned_short digits,
			    CORBA_short scale)
{
  orbit_output_typecode_substruct(of, ts, "char*", "subnames", sub_parts, subnames, TRUE);
  orbit_output_typecode_substruct(of, ts, "CORBA_TypeCode", "subtypes", sub_parts, subtypes, FALSE);
  orbit_output_typecode_substruct(of, ts, "CORBA_any", "sublabels", sub_parts, sublabels, FALSE);
  fprintf(of, "const struct CORBA_TypeCode_struct TC_");
  orbit_cbe_write_typename(of, ts);
  fprintf(of, " = {\n");

  /* tis lame to use a switch. should index an array instead. */
  switch(kind) {
  case CORBA_tk_null:
    fprintf(of, "CORBA_tk_null"); break;
  case CORBA_tk_void:
    fprintf(of, "CORBA_tk_void"); break;
  case CORBA_tk_short:
    fprintf(of, "CORBA_tk_short"); break;
  case CORBA_tk_long:
    fprintf(of, "CORBA_tk_long"); break;
  case CORBA_tk_ushort:
    fprintf(of, "CORBA_tk_ushort"); break;
  case CORBA_tk_ulong:
    fprintf(of, "CORBA_tk_ulong"); break;
  case CORBA_tk_float:
    fprintf(of, "CORBA_tk_float"); break;
  case CORBA_tk_double:
    fprintf(of, "CORBA_tk_double"); break;
  case CORBA_tk_boolean:
    fprintf(of, "CORBA_tk_boolean"); break;
  case CORBA_tk_char:
    fprintf(of, "CORBA_tk_char"); break;
  case CORBA_tk_octet:
    fprintf(of, "CORBA_tk_octet"); break;
  case CORBA_tk_any:
    fprintf(of, "CORBA_tk_any"); break;
  case CORBA_tk_TypeCode:
    fprintf(of, "CORBA_tk_TypeCode"); break;
  case CORBA_tk_Principal:
    fprintf(of, "CORBA_tk_Principal"); break;
  case CORBA_tk_objref:
    fprintf(of, "CORBA_tk_objref"); break;
  case CORBA_tk_struct:
    fprintf(of, "CORBA_tk_struct"); break;
  case CORBA_tk_union:
    fprintf(of, "CORBA_tk_union"); break;
  case CORBA_tk_enum:
    fprintf(of, "CORBA_tk_enum"); break;
  case CORBA_tk_string:
    fprintf(of, "CORBA_tk_string"); break;
  case CORBA_tk_sequence:
    fprintf(of, "CORBA_tk_sequence"); break;
  case CORBA_tk_array:
    fprintf(of, "CORBA_tk_array"); break;
  case CORBA_tk_alias:
    fprintf(of, "CORBA_tk_alias"); break;
  case CORBA_tk_except:
    fprintf(of, "CORBA_tk_except"); break;
  case CORBA_tk_longlong:
    fprintf(of, "CORBA_tk_longlong"); break;
  case CORBA_tk_ulonglong:
    fprintf(of, "CORBA_tk_ulonglong"); break;
  case CORBA_tk_longdouble:
    fprintf(of, "CORBA_tk_longdouble"); break;
  case CORBA_tk_wchar:
    fprintf(of, "CORBA_tk_wchar"); break;
  case CORBA_tk_wstring:
    fprintf(of, "CORBA_tk_wstring"); break;
  case CORBA_tk_fixed:
    fprintf(of, "CORBA_tk_fixed"); break;
  case CORBA_tk_recursive:
    fprintf(of, "CORBA_tk_recursive"); break;
  case CORBA_tk_last:
    fprintf(of, "CORBA_tk_last"); break;
  default:
    g_error("Unhandled value in case statement.");
  }

  fprintf(of, " /* kind */, \"%s\" /* name */, \"%s\" /* repo_id */, %d /* length */, %d /* sub_parts */,\n", name, repo_id, length, sub_parts);

  fprintf(of, "(char **)");
  orbit_output_typecode_substruct_entry(of, ts, "subnames", subnames);
  fprintf(of, " /* subnames */,\n(CORBA_TypeCode *)");
  orbit_output_typecode_substruct_entry(of, ts, "subtypes", subtypes);
  fprintf(of, " /* subtypes */,\n(CORBA_any *)");
  orbit_output_typecode_substruct_entry(of, ts, "sublabels", sublabels);
  fprintf(of, " /* sublabels (NYI) */,\n%s /* discriminator */, %u /* recurse_depth */,\n%d /* default_index */, %hu /* digits */, %hd /* scale */\n", discriminator?discriminator:"NULL",
	  recurse_depth, default_index, digits, scale);

  fprintf(of, "};\n");
}

void orbit_output_typecode(FILE *of, IDL_tree ts)
{
  CBETCInfo tcinfo;

  if(!enable_typecodes)
    return;

  tcinfo.of = of;
  tcinfo.tree = ts;
  tcinfo.subnames = g_array_new(TRUE, FALSE, sizeof(char *));
  tcinfo.subtypes = g_array_new(TRUE, FALSE, sizeof(char *));
  tcinfo.sublabels = g_array_new(TRUE, FALSE, sizeof(char *));

 restart:
  switch(IDL_NODE_TYPE(ts)) {
  case IDLN_IDENT:
    tcinfo.extra = ts;
    ts = tcinfo.tree = IDL_TYPE_DCL(IDL_get_parent_node(ts, IDLN_TYPE_DCL, NULL)).type_spec;
    goto restart;
    break;
  case IDLN_TYPE_SEQUENCE:
    orbit_tc_do_type_sequence(&tcinfo);
    break;
  case IDLN_TYPE_ENUM:
    orbit_tc_do_type_enum(&tcinfo);
    break;
  case IDLN_EXCEPT_DCL:
  case IDLN_TYPE_STRUCT:
    orbit_tc_do_type_struct(&tcinfo);
    break;
  case IDLN_TYPE_UNION:
    orbit_tc_do_type_union(&tcinfo);
    break;
  case IDLN_TYPE_INTEGER:
  case IDLN_TYPE_FLOAT:
  case IDLN_TYPE_CHAR:
  case IDLN_TYPE_WIDE_CHAR:
  case IDLN_TYPE_BOOLEAN:
  case IDLN_TYPE_OCTET:
  case IDLN_TYPE_STRING:
  case IDLN_TYPE_WIDE_STRING:
    orbit_tc_do_type_alias(&tcinfo);
    break;
  default:
    g_warning("Don't know how to output typecode for %s",
	      IDL_tree_type_names[IDL_NODE_TYPE(ts)]);
    break;
  }

  g_array_free(tcinfo.subnames, TRUE);
  g_array_free(tcinfo.subtypes, TRUE);
  g_array_free(tcinfo.sublabels, TRUE);
}

static void
orbit_tc_do_type_enum(CBETCInfo *tci)
{
/* enum */
  char *id;
  IDL_tree curitem;

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_TYPE_ENUM(tci->tree).ident), "_", 0);

  for(curitem = IDL_TYPE_ENUM(tci->tree).enumerator_list; curitem;
      curitem = IDL_LIST(curitem).next)
    g_array_append_val(tci->subnames, IDL_IDENT(IDL_LIST(curitem).data).str);

  orbit_output_typecode_items(tci->of, tci->tree,
			      CORBA_tk_enum, id, id,
			      0, 
			      IDL_list_length(IDL_TYPE_ENUM(tci->tree).enumerator_list),
			      (char **)tci->subnames->data, NULL, NULL,
			      NULL /* discrim */, 0, 0, 0, 0);
  
  free(id);
}

static void
orbit_tc_do_type_sequence(CBETCInfo *tci)
{
  char *id, *ctmp;
  char *dummy[2];
  GString *tmpstr = g_string_new(NULL);
  CORBA_unsigned_long len;

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(tci->extra), "_", 0);

  ctmp = orbit_cbe_get_typename(IDL_TYPE_SEQUENCE(tci->tree).simple_type_spec);

  g_string_sprintf(tmpstr, "(CORBA_TypeCode)&TC_%s", ctmp);
  free(ctmp);

  dummy[0] = tmpstr->str;

  dummy[1] = NULL;

  if(IDL_TYPE_SEQUENCE(tci->tree).positive_int_const)
    len = IDL_INTEGER(IDL_TYPE_SEQUENCE(tci->tree).positive_int_const).value;
  else
    len = 0;

  orbit_output_typecode_items(tci->of, tci->extra,
			      CORBA_tk_sequence, id, id,
			      len,
			      1, NULL, dummy, NULL,
			      NULL /* discrim */, 0, 0, 0, 0);

  g_string_free(tmpstr, TRUE);
  free(id);
}

static void
orbit_tc_do_type_struct(CBETCInfo *tci)
{
  char *id, *ctmp, *appendtype, *appendname;
  GString *tmpstr = g_string_new(NULL);
  IDL_tree curitem, curdcl, curmember;
  int i, n;

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(IDL_TYPE_STRUCT(tci->tree).ident), "_", 0);

  n = 0;
  for(curitem = IDL_TYPE_STRUCT(tci->tree).member_list; curitem;
      curitem = IDL_LIST(curitem).next) {
    curmember = IDL_LIST(curitem).data;

    ctmp = orbit_cbe_get_typename(IDL_MEMBER(curmember).type_spec);
    g_string_sprintf(tmpstr, "(CORBA_TypeCode)&TC_%s", ctmp);
    free(ctmp);

    for(curdcl = IDL_MEMBER(curmember).dcls; curdcl;
	curdcl = IDL_LIST(curdcl).next) {
      appendtype = strdup(tmpstr->str);
      appendname = IDL_IDENT(IDL_LIST(curdcl).data).str;

      g_array_append_val(tci->subtypes, appendtype);
      g_array_append_val(tci->subnames, appendname);

      n++;
    }
  }

  orbit_output_typecode_items(tci->of, tci->tree,
			      CORBA_tk_struct, id, id,
			      0,
			      n,
			      (char **)tci->subnames->data,
			      (char **)tci->subtypes->data, NULL,
			      NULL /* discrim */, 0, 0, 0, 0);

  if( tci->subtypes->data )
    /*for(i = 0; g_array_index(tci->subtypes, char *, i); i++) {*/
    for(i = 0; i<n && g_array_index(tci->subtypes, char *, i)!=NULL; i++) {
      free(g_array_index(tci->subtypes, char *, i));
    }

  g_string_free(tmpstr, TRUE);
  free(id);
}

static void 
orbit_tc_do_type_union(CBETCInfo *tci)
{
}

static void
orbit_tc_do_type_alias(CBETCInfo *tci)
{  
  char *id, *ctmp;
  char *dummy[2];
  GString *tmpstr = g_string_new(NULL);

  id = IDL_ns_ident_to_qstring(IDL_IDENT_TO_NS(tci->extra), "_", 0);

  ctmp = orbit_cbe_get_typename(tci->tree);

  g_string_sprintf(tmpstr, "(CORBA_TypeCode)&TC_%s", ctmp);
  free(ctmp);

  dummy[0] = tmpstr->str;
  dummy[1] = NULL;

  orbit_output_typecode_items(tci->of, tci->extra,
			      CORBA_tk_alias, id, id,
			      0,
			      1, NULL, dummy, NULL,
			      NULL /* discrim */, 0, 0, 0, 0);
  g_string_free(tmpstr, TRUE);
}
