/*  Sclient
 *  Copyright (C) 1999 Heathen (the.heathen@swipnet.se)
 *		  1999 Drizzt  (doc.day@swipnet.se)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "config.h"

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "font.h"

int check_sclient_dir (gchar *dirname)
{
    struct stat file_stat;
    int return_val = 0;
    gchar buf[256];

    if ( stat (dirname, &file_stat) == 0) /* can we stat ~/.sclient? */
    {
        if ( !(S_ISDIR(file_stat.st_mode))) /* if it's not a directory */
        {
            g_snprintf (buf, 256, "%s already exists and is not a directory!", dirname);
            popup_window (buf);
            return_val = -1;
        }
    }
    else /* it must not exist */
    {
        g_snprintf (buf, 256, "%s does not exist, Creating it as a directory.", dirname);
        popup_window (buf);

        if ((mkdir (dirname, 0777)) == 0) /* this isn't dangerous, umask modifies it */
        {
            g_snprintf (buf, 256, "%s created.", dirname);
            popup_window (buf);
	    do_manual();
        }
        else
        {
            g_snprintf (buf, 256, "%s NOT created: %s", dirname, strerror (errno));
            popup_window (buf);
            return_val = errno;
        }
    }

    return (return_val);
}

void load_font ( )
{
    FILE *fp;
    gchar *home, filename[255] = "";
    gchar line[255];

    font.FontName = g_strdup ("-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1"); //("fixed");
    
    home = getenv ("HOME");

    g_snprintf (filename, 255, "%s%s", home, "/.sclient");
    if (check_sclient_dir (filename) != 0)
        return;

    g_snprintf (filename, 254, "%s%s", home, "/.sclient/font");

    fp = fopen (filename, "r");

    if ( fp == NULL )
        return;

    while ( fgets (line, 80, fp) != NULL )
    {
        gchar pref[25];
        gchar value[250];

        sscanf (line, "%s %[^\n]", pref, value);

        if ( !strcmp (pref, "FontName") )
        {
            font.FontName = g_strdup (value);
        }
    }

    if ( !font.FontName )
        font.FontName = g_strdup ("-adobe-courier-medium-r-normal-*-*-120-*-*-m-*-iso8859-1");

    font_normal = gdk_font_load (font.FontName);
    fclose (fp);
}

void save_font ()
{
    gchar *home, filename[256] = "";
    FILE *fp;
    gchar buf[256];

    home = getenv ("HOME");

    g_snprintf (filename, 255, "%s%s", home, "/.sclient");
    if (check_sclient_dir (filename) != 0)
        return;

    g_snprintf (filename, 255, "%s%s", home, "/.sclient/font");

    fp = fopen (filename, "w");

    if ( fp == NULL )
    {
        sprintf (buf, "You must create the directory %s/.sclient before you can save.",
                 home);
        popup_window (buf);
        return;
    }

    if ( strlen (font.FontName) > 0 )
        fprintf (fp, "FontName %s\n", font.FontName);
    
    fclose (fp);
}


void font_font_selected (GtkWidget *button, GtkFontSelectionDialog *fs)
{
    gchar *temp, buf[256];

    temp = gtk_font_selection_get_font_name (GTK_FONT_SELECTION (fs->fontsel));
    if (temp == NULL) {
        sprintf (buf, "The selected Font isn't valid, be sure to select a font that does exist.");
        popup_window (buf);
        return;
    }

    g_free (font.FontName);
    font.FontName = g_strdup (temp);
    font_normal = gdk_font_load (font.FontName);
    g_free (temp);
    save_font();
    gtk_widget_destroy (GTK_WIDGET (fs));    
}

void window_font (GtkWidget *button, gpointer data)
{
    GtkWidget *fontw;

    fontw = gtk_font_selection_dialog_new ("Font Selection...");
    gtk_font_selection_dialog_set_preview_text (GTK_FONT_SELECTION_DIALOG (fontw),
                                                "This is a sample text?");

    gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG (fontw), font.FontName);

    gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fontw)->ok_button), "clicked",
                        GTK_SIGNAL_FUNC (font_font_selected), fontw);

    gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG (fontw)->cancel_button), "clicked",
                        GTK_SIGNAL_FUNC (close_window),fontw);

    gtk_widget_show (fontw);
}


