//
//  Login.app
// 
//  Copyright (c) 1997, 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "SwitchUser.h"


SwitchUser::SwitchUser(struct passwd *pw)
{
    Pw = pw;
}


SwitchUser::~SwitchUser()
{
    // Never called
}


void SwitchUser::Login(char* cmd)
{
    SetEnvironment();
    SetUserId();
    Execute(cmd);
}


void SwitchUser::SetEnvironment()
{
    char *term = getenv("TERM");
    environ = (char **) new char*[2];
    environ[0] = 0;
    if(term)
        putenv(StrConcat("TERM=", term));
    putenv(StrConcat("HOME=", Pw->pw_dir));
    putenv(StrConcat("SHELL=", Pw->pw_shell));
    putenv(StrConcat("USER=", Pw->pw_name));
    putenv(StrConcat("LOGNAME=", Pw->pw_name));
    putenv(StrConcat("PATH=", DEFAULT_PATH));
    putenv("DISPLAY=:0.0");
    putenv(StrConcat("MAIL="_PATH_MAILDIR"/", Pw->pw_name));
    chdir(Pw->pw_dir);
}


void SwitchUser::SetUserId()
{
    if( (Pw == 0) ||
        (initgroups(Pw->pw_name, Pw->pw_gid) != 0) ||
        (setgid(Pw->pw_gid) != 0) ||    
        (setuid(Pw->pw_uid) != 0) )
    {
        cerr << APPNAME << ": could not switch user id" << endl;
        exit(ERR_EXIT);
    }
}


void SwitchUser::Execute(char* cmd)
{
    char *args[4];
    char* shell = strdup(Pw->pw_shell);
    char *shell_basename = BaseName(shell);

    args[0] = new char[strlen(shell_basename) + 2];
    strcpy(args[0], "-");
    strcat(args[0], shell_basename);
    args[1] = "-c";
    args[2] = cmd;
    args[3] = 0;

    execv(shell, args);
    cerr << APPNAME << ": could not execute login command" << endl;
}


char* SwitchUser::BaseName(const char* name)
{
    const char *base = name;

    while(*name)
    {
        if(*name == '/')
            base = name + 1;
        ++name;
    }
    
    return (char*) base;
}


char* SwitchUser::StrConcat(const char* str1, const char* str2)
{
    char* tmp = new char[strlen(str1) + strlen(str2) + 1];
    strcpy(tmp, str1);
    strcat(tmp, str2);
    return tmp;
}

