/*
 * Hardware tuning for the VIA 82C597_0 Host bridge
 */

#define PCI_DEVICE_ID_VIA_597_0 0x0597

// Note, The tweaks commented out are done so until they have
// been double checked - DJ.
static Tweaks_t VIA_82C597_0_Tweaks[] = {
	/* Tagname					Reg	Mask 		Bit	Description	*/
	{ "LEVEL_2_CACHE",			0x50,	1<<6|1<<7,	1<<7,	"Level 2 Cache"},
	{ "LINEAR_BURST",			0x50,	1<<5,		1<<5,	"Linear burst"},
	{ "BACKOFF_CPU",			0x51,	1<<5,		0<<5,	"Backoff CPU"},
	{ "LEVEL2_WRITETHROUGH",	0x52,	1<<0,		1<<0,	"Level 2 Cache Write through"},
	{ "LEVEL2_FILL_ON_SINGLE_RD",0x52,	1<<2,		1<<2,	"Level 2 Cache fill on single read"},
	{ "READ_AROUND_WRITE",		0x53,	1<<7,		1<<7,	"Read around write"},
	{ "CACHE_READ_PIPELINE",	0x53,	1<<6,		1<<6,	"Cache read pipeline"},
	{ "CACHE_WRITE_PIPELINE",	0x53,	1<<5,		1<<5,	"Cache write pipeline"},
	{ "DRAM_READ_PIPELINE",		0x53,	1<<4,		1<<4,	"DRAM read pipeline"},
	{ "BURST_REFRESH",			0x68,	1<<2,		1<<2,	"Burst refresh"},
//    { "DRAM_ARBIT_POLICY",	0x6b,	1<<6|1<<7,	1<<6,	"DRAM arbitration policy"},
	{ "1T_DDR_WR_RD_TURNAROUND",0x6c,	1<<4,		0<<4,	"1T DDR write to read turnaround"},
	{ "SINGLE_RW_BURST_STOP",	0x6c,	1<<3,		1<<3,	"Single RW burst stop command"},
	{ "CPU_TO_PCI_POSTWRITE",	0x70,	1<<7,		1<<7,	"CPU->PCI posted write"},
	{ "PCI_TO_RAM_POSTWRITE",	0x70,	1<<6,		1<<6,	"PCI->RAM posted write"},
	{ "PCI_TO_RAM_PREFETCH",	0x70,	1<<5,		1<<5,	"PCI->RAM prefetch"},
	{ "DELAYED_TRANSACTION",	0x70,	1<<0,		1<<0,	"Delayed transactions"},
	{ "DYNAMIC_PCI_BURST",		0x71,	1<<7,		1<<7,	"Dynamic PCI burst"},
	{ "BYTE_MERGING",			0x71,	1<<6,		1<<6,	"Byte merging"},
	{ "PCI_IO_POSTWRITE",		0x71,	1<<4,		1<<4,	"PCI I/O cycle post write"},
	{ "PCI_BURST",				0x71,	1<<3,		1<<3,	"PCI Burst"},
	{ "PCI_FAST_B2B_WRITE",		0x71,	1<<2,		1<<2,	"PCI fast back to back write"},
	{ "QUICKFRAME_GENERATE",	0x71,	1<<1,		1<<1,	"Quick frame generation"},
	{ "FAST_PCI_CYCLES",		0x71,	1<<0,		1<<0,	"Fast PCI cycles"},
//    { "CPU_TO_PCI_RETRY_CNT",0x72,	1<<4|1<<5,	1<<,	"CPU->PCI retry count and retry backoff"},
	{ "CPU_BACKOFF_RD_FAIL",	0x72,	1<<2,		1<<2,	"CPU backoff on PCI read retry failure"},
	{ "REDUCE_1T_FRAME_GEN",	0x72,	1<<1,		1<<0,	"Reduce 1T for FRAME# generation"},
	{ "REDUCE_1T_CPU_RD_PCI",	0x72,	1<<0,		0<<0,	"Reduce 1T for CPU read PCI slave"},
	{ "PCI_1WS_WRITE",			0x73,	1<<6,		0<<6,	"PCI Master 1 wait state write"},
	{ "PCI_1WS_READ",			0x73,	1<<5,		0<<5,	"PCI Master 1 wait state read"},
	{ "PCI_RD_PREFETCH",		0x74,	1<<7,		1<<7,	"PCI read prefetch by enhance"},
	{ "PCI_WR_MERGE",			0x74,	1<<6,		1<<6,	"PCI master write merge"},
	{ 0, 0, 0, 0, 0 }
};

static Tweaks_t VIA_82C597_0_EDOFPM_B1_Tweaks[] = {
	{ "3T_RAS_PRECHARGE",		0x64,	1<<7,		0<<7,		"3T RAS precharge time"},
	{ "4T_RAS_PULSE_WIDTH",		0x64,	1<<6,		0<<6,		"4T RAS pulse width"},
	{ "1T_CAS_RD_PULSE_WIDTH",	0x64,	1<<4|1<<5,	0<<4|0<<5,	"1T CAS read pulse width"},
	{ "1T_CAS_WR_PULSE_WIDTH",	0x64,	1<<3,		0<<3,		"1T CAS write pulse width"},
	{ "1T_MA_TO_CAS_DELAY",		0x64,	1<<2,		0<<2,		"1T MA to CAS delay"},
	{ "1T_RAS_TO_MA_DELAY",		0x64,	1<<1,		0<<1,		"1T RAS to MA delay"},
	{ "EDO_BURST_RATE",			0x68,	1<<5,		0<<5,		"x2222222 pipeline burst rate"},
	{ "DRAM_LATCH_AT_CCLK",		0x68,	1<<4,		0<<4,		"DRAM data latch at CCLK"},
	{ 0, 0, 0, 0, 0 }
};
static Tweaks_t VIA_82C597_0_SDRAM_B1_Tweaks[] = {
	{ "2T_PRE_TO_CMD_PERIOD",	0x64,	1<<7,		0<<7,		"2T Precharge command->active period"},
	{ "5T_CMD_TO_PRE_PERIOD",	0x64,	1<<6,		0<<6,		"5T Active command->precharge period"},
	{ "1T_CAS_LATENCY",			0x64,	1<<4|1<<5,	0<<4|0<<5,	"1T CAS latency"},
	{ "2T_ACTCMD_TO_CMD",		0x64,	1<<2,		0<<2,		"2T Active command->CMD period"},
	{ "BANK_INTERLEAVE",		0x64,	1<<1|1<<0,	0<<0|1<<1,	"Bank interleave"},
	{ 0, 0, 0, 0, 0 }
};
static Tweaks_t VIA_82C597_0_SDRAM2_B1_Tweaks[] = {
	{ "DDR_WR_ENABLE",			0x64,	1<<3,		1<<3,		"DDR write enable"},
	{ 0, 0, 0, 0, 0 }
};

static Tweaks_t VIA_82C597_0_EDOFPM_B2_Tweaks[] = {
	{ "3T_RAS_PRECHARGE",		0x65,	1<<7,		0<<7,		"3T RAS precharge time"},
	{ "4T_RAS_PULSE_WITH",		0x65,	1<<6,		0<<6,		"4T RAS pulse width"},
	{ "1T_CAS_RD_PULSE_WIDTH",	0x65,	1<<4|1<<5,	0<<4|0<<5,	"1T CAS read pulse width"},
	{ "1T_CAS_WR_PULSE_WIDTH",	0x65,	1<<3,		0<<3,		"1T CAS write pulse width"},
	{ "1T_MA_TO_CAS_DELAY",		0x65,	1<<2,		0<<2,		"1T MA to CAS delay"},
	{ "1T_RAS_TO_MA_DELAY",		0x65,	1<<1,		0<<1,		"1T RAS to MA delay"},
	{ "EDO_BURST_RATE",			0x68,	1<<5,		0<<5,		"x2222222 pipeline burst rate"},
	{ "DRAM_LATCH_AT_CCLK",		0x68,	1<<4,		0<<4,		"DRAM data latch at CCLK"},
	{ 0, 0, 0, 0, 0 }
};
static Tweaks_t VIA_82C597_0_SDRAM_B2_Tweaks[] = {
	{ "2T_PRE_TO_CMD_PERIOD",	0x65,	1<<7,		0<<7,		"2T Precharge command->active period"},
	{ "5T_CMD_TO_PRE_PERIOD",	0x65,	1<<6,		0<<6,		"5T Active command->precharge period"},
	{ "1T_CAS_LATENCY",			0x65,	1<<4|1<<5,	0<<4|0<<5,	"1T CAS latency"},
	{ "2T_ACTCMD_TO_CMD",		0x65,	1<<2,		0<<2,		"2T Active command->CMD period"},
	{ "BANK_INTERLEAVE",		0x65,	1<<1|1<<0,	0<<0|1<<1,	"Bank interleave"},
	{ 0, 0, 0, 0, 0 }
};
static Tweaks_t VIA_82C597_0_SDRAM2_B2_Tweaks[] = {
	{ "DDR_WR_ENABLE",			0x65,	1<<3,		1<<3,		"DDR write enable"},
	{ 0, 0, 0, 0, 0 }
};

static Tweaks_t VIA_82C597_0_EDOFPM_B3_Tweaks[] = {
	{ "3T_RAS_PRECHARGE",		0x66,	1<<7,		0<<7,		"3T RAS precharge time"},
	{ "4T_RAS_PULSE_WIDTH",		0x66,	1<<6,		0<<6,		"4T RAS pulse width"},
	{ "1T_CAS_RD_PULSE_WIDTH",	0x66,	1<<4|1<<5,	0<<4|0<<5,	"1T CAS read pulse width"},
	{ "1T_CAS_WR_PULSE_WIDTH",	0x66,	1<<3,		0<<3,		"1T CAS write pulse width"},
	{ "1T_MA_TO_CAS_DELAY",		0x66,	1<<2,		0<<2,		"1T MA to CAS delay"},
	{ "1T_RAS_TO_MA_DELAY",		0x66,	1<<1,		0<<1,		"1T RAS to MA delay"},
	{ "EDO_BURST_RATE",			0x68,	1<<5,		0<<5,		"x2222222 pipeline burst rate"},
	{ "DRAM_LATCH_AT_CCLK",		0x68,	1<<4,		0<<4,		"DRAM data latch at CCLK"},
	{ 0, 0, 0, 0, 0 }
};
static Tweaks_t VIA_82C597_0_SDRAM_B3_Tweaks[] = {
	{ "2T_PRE_TO_CMD_PERIOD",	0x66,	1<<7,		0<<7,		"2T Precharge command->active period"},
	{ "5T_CMD_TO_PRE_PERIOD",	0x66,	1<<6,		0<<6,		"5T Active command->precharge period"},
	{ "1T_CAS_LATENCY",			0x66,	1<<4|1<<5,	0<<4|0<<5,	"1T CAS latency"},
	{ "2T_ACTCMD_TO_CMD",		0x66,	1<<2,		0<<2,		"2T Active command->CMD period"},
	{ "BANK_INTERLEAVE",		0x66,	1<<1|1<<0,	0<<0|1<<1,	"Bank interleave"},
	{ 0, 0, 0, 0, 0 }
};
static Tweaks_t VIA_82C597_0_SDRAM2_B3_Tweaks[] = {
	{ "DDR_WR_ENABLE",			0x66,	1<<3,		1<<3,		"DDR write enable"},
	{ 0, 0, 0, 0, 0 }
};
