## This is the plugin to handle the mounting of Appleshare
## network volumes. It requires the afpfs package which
## implements an appleshare mounter
##
## Ethan Gold <etgold@cs.vassar.edu> 2/24/98
##
if {[debug]} { puts "loading Appleshare plugin..." }

## register the plugin with the main chooser
register_plugin appletalk appleshare Appleshare

#### required procedures that simply return plugin information
proc appleshare.geticon {} { return "appleshare.pnm" }
proc appleshare.getpubname {} { return "Appleshare" }
proc appleshare.getprotocol {} { return "appletalk" }

#### real plugin functionality below here##

########## required functions #################

## start function - required
proc appleshare.start {} {
    global plug_globalflat
    if {[debug]} { puts "started Appleshare Plugin" }

    set entlabel [plug_list_label]
    $entlabel configure -text "Appleshare Servers:"
    update
    appleshare.widgets stop
    appleshare.widgets start
    appleshare.newzone
}

## stop funtion - required
proc appleshare.stop {} {
    if {[debug]} { puts "stopped Appleshare Plugin" }
    appleshare.clearentities
    set ID [get_glob afterID]
    if {[string compare $ID ""] != 0 } {
	after cancel $ID
    }
    appleshare.widgets stop
}

## function to call when a listitem is double-clicked
proc appleshare.doubleclick {} {
    if {[debug]} { puts "appleshare: got double-click with [get_curr_item]" }
    appleshare.mountwindow [get_curr_item] [appletalk.getcurrzone]
}

proc appleshare.newzone {} {
    set plugframe [plug_frame]
    $plugframe.status configure -text "scanning [appletalk.getcurrzone]..."
    update
    appleshare.clearentities
    appleshare.showentities [appleshare.getnames]
    $plugframe.status configure -text "ready."
}

############# End required functions ##################

##################################################
## function to build window to mount volumes
##################################################
proc appleshare.mountwindow {server zone} {
    
    set username ""
    set password ""
    ## make sure something's selected
    if {[string compare $server ""] == 0} {
	return
    }
    if {[debug]} { puts "appleshare: pretending to mount $server" }

    set w ".appleshare_mountwin"
    set appleshareguestflag 0

    ## we are only going to support one mount window
    ## at a time for now. this is easily changed.
    catch {destroy $w}
    
    ## build mounting window
    toplevel $w -class Dialog
    set mx [winfo pointerx .]
    set my [winfo pointery .]
    wm geometry $w "+[expr $mx-50]+[expr $my-50]"
    label $w.label -text \
	    " \nConnect to the file server \"$server\" as: \n" \
	    -font [get_propfont]

    checkbutton $w.guest -variable appleshareguestflag \
	    -text "Guest" -font [get_propfont] \
	    -command "toggleentries $w appleshareguestflag"

    label $w.spacelabel1 -text "\n"
    label $w.spacelabel2 -text "\n"
    frame $w.nameframe
    frame $w.passframe
    label $w.nameframe.namelabel -text "Name:     " -font [get_fixedfont]
    label $w.passframe.passlabel -text "Password: " -font [get_fixedfont]
    entry $w.nameframe.name -textvariable username -exportselection 0 \
	    -background white
    entry $w.passframe.pass -textvariable password -exportselection 0 \
	    -show "*" -background white
    pack $w.nameframe.namelabel -side left -anchor n
    pack $w.nameframe.name -side right -anchor n
    pack $w.passframe.passlabel -side left -anchor n
    pack $w.passframe.pass -side right -anchor n
    button $w.cancel -text "Cancel" \
	    -command "destroy $w"
    button $w.ok -text "OK" \
	    -command "destroy $w; appleshare.volist \"$server\" \"$zone\" \"\$username\" \"\$password\" \$appleshareguestflag" -default active

    pack $w.label -side top -padx 5
    pack $w.guest -side top -anchor w -padx 15
    pack $w.spacelabel1 -side top
    pack $w.nameframe -side top -anchor w  -padx 15
    pack $w.passframe -side top -anchor w  -padx 15
    #pack $w.spacelabel2 -side top
    pack $w.cancel -side left -anchor s -padx 10 -pady 10
    pack $w.ok -side right -anchor s -padx 10 -pady 10
    update
    focus $w.nameframe.name
    if {[debug]} { puts "appleshare: finished packing mountwin" }

    bind $w.passframe.pass <Return> "$w.ok invoke"
    bind $w <Control-c> "$w.cancel invoke"
    bind $w.cancel <Return> "$w.cancel invoke"
    bind $w.ok <Return> "$w.ok invoke"
}

##################################################
## procedure to list available volumes and call
## the procedure that does the afpfs interaction
##################################################
proc appleshare.volist {server zone username password guestflag} {
    if {[debug]} {
	regsub -all {.} $password "\*" fakepass
	puts "appleshare: volist: called with $server, $zone, \
		$username, $fakepass, $guestflag"
    }

    set_glob volume ""
    set_glob file ""
    set file ""

    ## build the window
    set w .smbsharewin
    destroy $w
    toplevel $w -class Dialog
    frame $w.lframe
    frame $w.fframe
    label $w.label -text "Volumes on $server: " -relief groove
    listbox $w.lframe.volumes -yscrollcommand "$w.lframe.scroll set" \
	    -height 6 -width 30 -exportselection 0
    scrollbar $w.lframe.scroll -command "$w.lframe.volumes yview" -takefocus 0
    #message $w.fframe.file -width 200 -relief sunken -text ""
    entry $w.fframe.file -width 20 -relief sunken -textvariable file \
	    -exportselection 0
    label $w.fframe.label -text "Mount Point: "
    button $w.mount -text "Mount" -command \
	    "appleshare.mountvol \"mount\" $guestflag \"$username\" \"$password\" \"$server\" \$volume \$file"
    button $w.cancel -text "Close" -command "destroy $w"
   
    pack $w.lframe.volumes -side left -expand 1 -fill both
    pack $w.lframe.scroll -side right -fill y
    pack $w.fframe.label -side left
    pack $w.fframe.file -side right

    pack $w.label -fill x
    pack $w.lframe -expand 1 -fill both
    pack $w.fframe
    pack $w.cancel -side left -anchor s -padx 10 -pady 10
    pack $w.mount -side right -anchor s -padx 10 -pady 10

    bind $w.fframe.file <Return> "$w.mount invoke"
    
    bind $w.lframe.volumes <ButtonRelease> \
	    "set_glob volume \[$w.lframe.volumes get \[$w.lframe.volumes curselection\]\]"

    ## fill the listbox with names
    set services [appleshare.mountvol "list" $server $guestflag $username $password "" ""]
    foreach name $services {
	$w.lframe.volumes insert end $name
    }
    if {[debug]} {puts "appleshare: got volumes: $volumes"}
}

##################################################
## procedure to handle talking to underlying afpfs tools
##################################################
proc appleshare.mountvol {command guestflag username password server volume file} {
    

    if {![string compare "list" $command]} {return [list]}

    if {![string compare "mount" $command]} {
	
	set cmdstring "$file \"$server\" \"$volume\""
	if {!$guestflag} {
	    set cmdstring "-u \"$username\" -p \"$password\" $cmdstring"
	}
	set cmdstring "afpmount $cmdstring"
	
	catch {eval exec $cmdstring} result
	if {[regexp $result "afpmount"]} {error "Appleshare Mount Volume" $result}

    }

}

##################################################
## procedure to build and destroy appleshare widgets
##################################################
proc appleshare.widgets {command} {
    set plugframe [plug_frame]

    if {[string compare $command "start"] == 0} {
	button $plugframe.mount -text "Mount..." \
		-command {appleshare.mountwindow \
		[get_curr_item] [appletalk.getcurrzone]}
	pack $plugframe.mount
    } else {
	destroy $plugframe.mount
    }
    
}

##################################################
## function to return the entities in the current zone
##################################################
proc appleshare.getnames {} {
    return [appletalk.namesfromlkup [appleshare.getentities]]
}

##################################################
proc appleshare.getentities {} {
    set currzone [appletalk.getcurrzone]
    set entity "=:AFPServer@$currzone"
    set results [appletalk.nbplkup $entity]
    set results [appletalk.namesfromlkup $results]
    return $results
}

##################################################
## function to display passed in entities in
## the plugin's entity list frame
##################################################
proc appleshare.showentities {entitylist} {
    set lbox [plug_list]
    foreach entity $entitylist {
	$lbox insert end $entity
    }
}

##################################################
proc appleshare.clearentities {} {
    set lbox [plug_list]
    $lbox delete 0 end
}
##################################################
if {[debug]} { puts "finished loading Appleshare." }

