
/*  A Bison parser, made from ../grammar.y
 by  GNU Bison version 1.27
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	T_SERVICE	257
#define	T_PORT	258
#define	T_EXEC	259
#define	T_PROTO	260
#define	T_UDP	261
#define	T_TCP	262
#define	T_UID	263
#define	T_GID	264
#define	T_BACKLOG	265
#define	T_INSTANCES	266
#define	T_DEFAULT	267
#define	T_NICE	268
#define	T_INTERFACE	269
#define	T_FISH	270
#define	T_CHROOT	271
#define	T_SERVER	272
#define	T_DIR	273
#define	T_RPC	274
#define	T_VERSION	275
#define	T_NAME	276
#define	T_WRAP	277
#define	T_CAPS	278
#define	T_FAMILY	279
#define	T_IPV4	280
#define	T_IPV6	281
#define	T_INITGROUPS	282
#define	T_BANNER	283
#define	T_ECHO	284
#define	T_DISCARD	285
#define	T_FILTER	286
#define	T_CHARGEN	287
#define	T_LOOPBACK	288
#define	T_RLIMIT	289
#define	T_LIM_CPU	290
#define	T_LIM_FSIZE	291
#define	T_LIM_DATA	292
#define	T_LIM_STACK	293
#define	T_LIM_CORE	294
#define	T_LIM_RSS	295
#define	T_LIM_NPROC	296
#define	T_LIM_NOFILE	297
#define	T_LIM_MEMLOCK	298
#define	T_LIM_INFINITY	299
#define	T_SOFT	300
#define	T_HARD	301
#define	T_LOG	302
#define	T_PIPE	303
#define	T_SYSLOG	304
#define	T_PATH	305
#define	T_MODE	306
#define	T_ACCEPT	307
#define	T_DENY	308
#define	T_CLOSE	309
#define	T_EXIT	310
#define	T_NUMERIC	311
#define	T_QSTRING	312
#define	T_IPADDR	313

#line 1 "../grammar.y"


#include <errno.h>
#include <fcntl.h>
#include <grp.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pwd.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sysexits.h>
#include <syslog.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <regex.h>
	
#include <config.h>
#include <installpaths.h>	
#include <port/port.h>

#if HAVE_DIRENT_H
# include <dirent.h>
# define NAMLEN(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NAMLEN(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

#ifdef HAVE_NET_BPF_H
#include <net/bpf.h>
#endif
	
#include "assemble.h"
#include "bytecode.h"
#include "data.h"
#include "db.h"
#include "error.h"
#include "parse.h"
#include "rlinetd.h"
#include "signals.h"
#include "util.h"	

struct userdata *userdata;
 
static struct service *current_service;
extern FILE *yyin;
extern char *rl_config; 
char **files = NULL;
static int curfile = 0, numfiles = 0; 
 
static struct service *defaults;

static struct logdata *logcur, *logdatas;

static struct numlist *numlist = NULL;
static struct stringlist *stringlist = NULL;

void yyerror(char *c);
int yylex();
static int bind_ports();
static void service_copy(struct service *to, struct service *from);
static void service_free(struct service *s); 
static struct service *service_new();
#ifndef HAVE_GETADDRINFO
static int getservport(char *str, char *proto);
#endif
static struct logdata *logdata_get(char *name);
static struct logdata *logdata_new();
static void pidtab_fixup();
static void validate_service(struct service *s);
static void add_directory(char *dir, char *match, char *ignore);
static int chargen_buffer();

void freebufs(); /* from parse.l */


#line 93 "../grammar.y"
typedef union {
	long num;
	char *cp;
	struct passwd *uid;
	struct group *gid;
	struct opmetalist *opml;
	struct opmeta *opm;
	rlim_t rl;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		200
#define	YYFLAG		-32768
#define	YYNTBASE	65

#define YYTRANSLATE(x) ((unsigned)(x) <= 313 ? yytranslate[x] : 97)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    63,    64,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,    60,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    61,     2,    62,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
    57,    58,    59
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     5,     7,     9,    11,    13,    17,    22,    28,
    34,    36,    38,    41,    43,    47,    51,    55,    59,    64,
    70,    72,    75,    77,    80,    83,    85,    87,    89,    92,
    95,    99,   102,   106,   109,   113,   118,   122,   126,   130,
   135,   139,   143,   147,   153,   158,   162,   165,   168,   171,
   175,   178,   181,   182,   184,   186,   190,   194,   198,   202,
   206,   210,   215,   219,   223,   225,   228,   232,   236,   238,
   242,   244,   248,   250,   253,   257,   261,   263,   267,   269,
   271,   275,   277,   279,   282,   286,   288,   290,   292,   294,
   296,   298,   300,   302,   304,   306,   308,   310,   312,   314,
   316,   318,   320,   322
};

static const short yyrhs[] = {    66,
     0,    65,    66,     0,    73,     0,    72,     0,    68,     0,
    67,     0,    19,    58,    60,     0,    19,    58,    58,    60,
     0,    19,    58,    58,    58,    60,     0,    48,    58,    61,
    69,    62,     0,    70,     0,    71,     0,    70,    71,     0,
    60,     0,    51,    58,    60,     0,     9,    93,    60,     0,
    10,    94,    60,     0,    52,    57,    60,     0,    13,    61,
    74,    62,     0,     3,    58,    61,    74,    62,     0,    79,
     0,    74,    79,     0,    77,     0,    74,    77,     0,    74,
    76,     0,    76,     0,    76,     0,    77,     0,    75,    77,
     0,    75,    76,     0,     5,    58,    60,     0,    28,    60,
     0,    14,    57,    60,     0,    16,    60,     0,    35,    92,
    90,     0,    48,    50,    58,    60,     0,     9,    93,    60,
     0,    29,    58,    60,     0,    33,    78,    60,     0,    48,
    58,    58,    60,     0,    10,    94,    60,     0,    17,    58,
    60,     0,    24,    58,    60,     0,    23,    58,    61,    75,
    62,     0,    23,    61,    75,    62,     0,    23,    58,    60,
     0,    23,    60,     0,    55,    60,     0,    56,    60,     0,
    30,    58,    60,     0,    34,    60,     0,    31,    60,     0,
     0,    58,     0,    60,     0,     4,    88,    60,     0,     6,
    95,    60,     0,    11,    57,    60,     0,    12,    57,    60,
     0,    15,    86,    60,     0,    18,    58,    60,     0,    20,
    61,    80,    62,     0,    25,    96,    60,     0,    32,    58,
    60,     0,    81,     0,    80,    81,     0,    22,    58,    60,
     0,    21,    82,    60,     0,    83,     0,    82,    63,    83,
     0,    57,     0,    57,    64,    57,     0,    85,     0,    84,
    85,     0,    46,    91,    60,     0,    47,    91,    60,     0,
    87,     0,    86,    63,    87,     0,    59,     0,    89,     0,
    88,    63,    89,     0,    58,     0,    57,     0,    91,    60,
     0,    61,    84,    62,     0,    57,     0,    45,     0,    36,
     0,    37,     0,    38,     0,    39,     0,    40,     0,    41,
     0,    42,     0,    43,     0,    44,     0,    57,     0,    58,
     0,    57,     0,    58,     0,     8,     0,     7,     0,    26,
     0,    27,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   129,   130,   133,   134,   135,   136,   139,   141,   143,   147,
   162,   180,   181,   184,   185,   195,   199,   203,   209,   218,
   308,   312,   316,   327,   335,   343,   349,   353,   364,   372,
   382,   403,   429,   433,   437,   441,   449,   465,   477,   496,
   510,   529,   533,   548,   563,   580,   597,   616,   620,   624,
   628,   637,   645,   647,   650,   651,   658,   662,   666,   670,
   677,   682,   683,   684,   699,   700,   703,   707,   714,   715,
   718,   722,   732,   733,   736,   740,   746,   747,   750,   756,
   757,   760,   764,   774,   778,   789,   791,   795,   797,   799,
   801,   803,   805,   807,   815,   823,   833,   838,   846,   851,
   859,   865,   873,   877
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","T_SERVICE",
"T_PORT","T_EXEC","T_PROTO","T_UDP","T_TCP","T_UID","T_GID","T_BACKLOG","T_INSTANCES",
"T_DEFAULT","T_NICE","T_INTERFACE","T_FISH","T_CHROOT","T_SERVER","T_DIR","T_RPC",
"T_VERSION","T_NAME","T_WRAP","T_CAPS","T_FAMILY","T_IPV4","T_IPV6","T_INITGROUPS",
"T_BANNER","T_ECHO","T_DISCARD","T_FILTER","T_CHARGEN","T_LOOPBACK","T_RLIMIT",
"T_LIM_CPU","T_LIM_FSIZE","T_LIM_DATA","T_LIM_STACK","T_LIM_CORE","T_LIM_RSS",
"T_LIM_NPROC","T_LIM_NOFILE","T_LIM_MEMLOCK","T_LIM_INFINITY","T_SOFT","T_HARD",
"T_LOG","T_PIPE","T_SYSLOG","T_PATH","T_MODE","T_ACCEPT","T_DENY","T_CLOSE",
"T_EXIT","T_NUMERIC","T_QSTRING","T_IPADDR","';'","'{'","'}'","','","'-'","tles",
"tle","directory","log","log_element","file_elements","file_element","default",
"service","service_elements","opcode_block","complex_opcode_element","opcode_element",
"optionalstring","service_element","rpcents","rpcent","numrangelist","numrange",
"limitents","limitent","ipaddrlists","ipaddrlist","portlists","portlist","limit",
"limitvalue","limittype","userid","groupid","protocol","family", NULL
};
#endif

static const short yyr1[] = {     0,
    65,    65,    66,    66,    66,    66,    67,    67,    67,    68,
    69,    70,    70,    71,    71,    71,    71,    71,    72,    73,
    74,    74,    74,    74,    74,    74,    75,    75,    75,    75,
    76,    76,    77,    77,    77,    77,    77,    77,    77,    77,
    77,    77,    77,    77,    77,    77,    77,    77,    77,    77,
    77,    77,    78,    78,    79,    79,    79,    79,    79,    79,
    79,    79,    79,    79,    80,    80,    81,    81,    82,    82,
    83,    83,    84,    84,    85,    85,    86,    86,    87,    88,
    88,    89,    89,    90,    90,    91,    91,    92,    92,    92,
    92,    92,    92,    92,    92,    92,    93,    93,    94,    94,
    95,    95,    96,    96
};

static const short yyr2[] = {     0,
     1,     2,     1,     1,     1,     1,     3,     4,     5,     5,
     1,     1,     2,     1,     3,     3,     3,     3,     4,     5,
     1,     2,     1,     2,     2,     1,     1,     1,     2,     2,
     3,     2,     3,     2,     3,     4,     3,     3,     3,     4,
     3,     3,     3,     5,     4,     3,     2,     2,     2,     3,
     2,     2,     0,     1,     1,     3,     3,     3,     3,     3,
     3,     4,     3,     3,     1,     2,     3,     3,     1,     3,
     1,     3,     1,     2,     3,     3,     1,     3,     1,     1,
     3,     1,     1,     2,     3,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1
};

static const short yydefact[] = {     0,
     0,     0,     0,     0,     0,     1,     6,     5,     4,     3,
     0,     0,     0,     0,     2,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
     0,     0,     0,    55,     0,    26,    23,    21,     0,     7,
     0,     0,    83,    82,     0,    80,     0,   102,   101,     0,
    97,    98,     0,    99,   100,     0,     0,     0,     0,    79,
     0,    77,    34,     0,     0,     0,     0,    47,     0,     0,
   103,   104,     0,    32,     0,     0,    52,     0,    54,     0,
    51,    88,    89,    90,    91,    92,    93,    94,    95,    96,
     0,     0,     0,    48,    49,    19,    25,    24,    22,     0,
     8,     0,     0,     0,     0,    14,     0,    11,    12,    20,
    56,     0,    31,    57,    37,    41,    58,    59,    33,    60,
     0,    42,    61,     0,     0,     0,    65,    46,     0,     0,
    27,    28,    43,    63,    38,    50,    64,    39,    87,    86,
     0,    35,     0,     0,     0,     9,     0,     0,     0,     0,
    10,    13,    81,    78,    71,     0,    69,     0,    62,    66,
     0,    45,    30,    29,     0,     0,     0,    73,    84,    36,
    40,    16,    17,    15,    18,     0,    68,     0,    67,    44,
     0,     0,    85,    74,    72,    70,    75,    76,     0,     0
};

static const short yydefgoto[] = {     5,
     6,     7,     8,   117,   118,   119,     9,    10,    45,   140,
    46,    47,    90,    48,   136,   137,   166,   167,   177,   178,
    71,    72,    55,    56,   152,   153,   101,    63,    66,    60,
    83
};

static const short yypact[] = {    96,
   -35,   -33,   -21,     0,     3,-32768,-32768,-32768,-32768,-32768,
    21,   231,    33,    31,-32768,   231,    76,    18,   100,    88,
    91,   -42,   -39,    12,    42,    54,    52,    62,    68,    28,
    85,   127,    90,    99,   106,   108,   116,   130,   125,   178,
   -46,   129,   132,-32768,    15,-32768,-32768,-32768,    44,-32768,
     1,   107,-32768,-32768,     2,-32768,   135,-32768,-32768,   136,
-32768,-32768,   143,-32768,-32768,   149,   153,   163,   164,-32768,
    27,-32768,-32768,   166,   167,   139,   118,-32768,    50,   168,
-32768,-32768,   169,-32768,   170,   171,-32768,   174,-32768,   184,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    11,   141,   144,-32768,-32768,-32768,-32768,-32768,-32768,   190,
-32768,    88,    91,   180,   195,-32768,   191,     1,-32768,-32768,
-32768,    76,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    42,-32768,-32768,   200,   209,    -8,-32768,-32768,    50,   142,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
   134,-32768,   198,   208,   210,-32768,   211,   212,   213,   214,
-32768,-32768,-32768,-32768,   205,    40,-32768,   215,-32768,-32768,
   177,-32768,-32768,-32768,   -40,   -40,    -5,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,   219,-32768,   200,-32768,-32768,
   217,   218,-32768,-32768,-32768,-32768,-32768,-32768,   280,-32768
};

static const short yypgoto[] = {-32768,
   276,-32768,-32768,-32768,-32768,   165,-32768,-32768,   266,   145,
   -45,   -43,-32768,   -44,-32768,   152,-32768,    97,-32768,   112,
-32768,   159,-32768,   172,-32768,     8,-32768,   181,   179,-32768,
-32768
};


#define	YYLAST		294


static const short yytable[] = {   107,
   109,   108,   199,   102,   149,     1,   107,   109,   108,   112,
   113,   103,   134,   135,    67,     2,   150,    68,    17,    18,
    19,     3,    11,    20,    21,    22,    23,    12,    24,    25,
    26,    27,    28,   141,    29,   142,    13,    30,    31,    32,
   175,   176,    33,    34,    35,    36,    37,    38,    39,    40,
     4,   114,   115,   169,    18,   149,   193,    14,    20,    21,
   116,   121,    41,    24,   122,    26,    27,   150,    69,    42,
    43,   151,    30,    31,    44,    57,   106,    33,    34,    35,
    36,    16,    38,    39,    40,    77,   130,    78,    79,   131,
    49,    51,    50,   141,   173,   142,   174,    41,     1,   187,
    70,   110,   188,   111,    42,    43,    58,    59,     2,    74,
    17,    18,    19,    73,     3,    20,    21,    22,    23,    75,
    24,    25,    26,    27,    28,   173,    29,   174,    76,    30,
    31,    32,    53,    54,    33,    34,    35,    36,    37,    38,
    39,    40,    80,     4,    61,    62,    18,    64,    65,    84,
    20,    21,    81,    82,    41,    24,    85,    26,    27,   134,
   135,    42,    43,    86,    30,    31,    44,    87,   120,    33,
    34,    35,    36,    88,    38,    39,    40,   138,   139,   175,
   176,    18,   191,   192,    91,    20,    21,    89,   104,    41,
    24,   105,    26,    27,   123,   124,    42,    43,   154,    30,
    31,   155,   125,   172,    33,    34,    35,    36,   126,    38,
    39,    40,   127,    92,    93,    94,    95,    96,    97,    98,
    99,   100,   128,   129,    41,   132,   133,   143,   144,   145,
   146,    42,    43,   147,    17,    18,    19,   159,   190,    20,
    21,    22,    23,   148,    24,    25,    26,    27,    28,   156,
    29,   160,   161,    30,    31,    32,   165,   179,    33,    34,
    35,    36,    37,    38,    39,    40,   168,   180,   186,   181,
   182,   183,   184,   185,   189,   195,   197,   198,    41,   200,
    15,    52,   162,   171,   196,    42,    43,   170,   194,   164,
    44,   158,   157,   163
};

static const short yycheck[] = {    45,
    45,    45,     0,    50,    45,     3,    52,    52,    52,     9,
    10,    58,    21,    22,    57,    13,    57,    57,     4,     5,
     6,    19,    58,     9,    10,    11,    12,    61,    14,    15,
    16,    17,    18,    79,    20,    79,    58,    23,    24,    25,
    46,    47,    28,    29,    30,    31,    32,    33,    34,    35,
    48,    51,    52,    62,     5,    45,    62,    58,     9,    10,
    60,    60,    48,    14,    63,    16,    17,    57,    57,    55,
    56,    61,    23,    24,    60,    58,    62,    28,    29,    30,
    31,    61,    33,    34,    35,    58,    60,    60,    61,    63,
    58,    61,    60,   139,   140,   139,   140,    48,     3,    60,
    59,    58,    63,    60,    55,    56,     7,     8,    13,    58,
     4,     5,     6,    60,    19,     9,    10,    11,    12,    58,
    14,    15,    16,    17,    18,   171,    20,   171,    61,    23,
    24,    25,    57,    58,    28,    29,    30,    31,    32,    33,
    34,    35,    58,    48,    57,    58,     5,    57,    58,    60,
     9,    10,    26,    27,    48,    14,    58,    16,    17,    21,
    22,    55,    56,    58,    23,    24,    60,    60,    62,    28,
    29,    30,    31,    58,    33,    34,    35,    60,    61,    46,
    47,     5,   175,   176,    60,     9,    10,    58,    60,    48,
    14,    60,    16,    17,    60,    60,    55,    56,    58,    23,
    24,    58,    60,    62,    28,    29,    30,    31,    60,    33,
    34,    35,    60,    36,    37,    38,    39,    40,    41,    42,
    43,    44,    60,    60,    48,    60,    60,    60,    60,    60,
    60,    55,    56,    60,     4,     5,     6,    58,    62,     9,
    10,    11,    12,    60,    14,    15,    16,    17,    18,    60,
    20,    57,    62,    23,    24,    25,    57,    60,    28,    29,
    30,    31,    32,    33,    34,    35,    58,    60,    64,    60,
    60,    60,    60,    60,    60,    57,    60,    60,    48,     0,
     5,    16,   118,   139,   188,    55,    56,   136,   177,   131,
    60,   113,   112,   122
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/misc/bison.simple"
/* This file comes from bison-1.27.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/share/misc/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 7:
#line 140 "../grammar.y"
{	add_directory(yyvsp[-1].cp, NULL, NULL);	;
    break;}
case 8:
#line 142 "../grammar.y"
{	add_directory(yyvsp[-2].cp, yyvsp[-1].cp, NULL);	;
    break;}
case 9:
#line 144 "../grammar.y"
{	add_directory(yyvsp[-3].cp, yyvsp[-2].cp, yyvsp[-1].cp);	;
    break;}
case 10:
#line 148 "../grammar.y"
{
		if(logdata_get(yyvsp[-3].cp)) {
			rl_warn("duplicate declaration of log %s, ignoring", yyvsp[-3].cp);
			free(yyvsp[-3].cp);
		} else {
			logcur->name = yyvsp[-3].cp;
			logcur->next = logdatas;
			logdatas = logcur;
			logcur = logdata_new();
		}
		clearuserdata(&userdata);
	;
    break;}
case 11:
#line 163 "../grammar.y"
{
		if(!logcur->path) {
			rl_warn("No path defined for log %s", logcur->name);
		} else {
			if((logcur->index = open(logcur->path, O_CREAT|O_APPEND|O_WRONLY, logcur->mode)) < 0) {
				rl_warn("open(\"%s\", O_CREAT|O_APPEND|O_WRONLY, %o) failed for log %s (%s)",
								logcur->path, logcur->mode, logcur->name, strerror(errno));
			}
			if(fchown(logcur->index, logcur->uid, logcur->gid)) {
				rl_warn("fchown(\"%s\", %d, %d) failed for log %s (%s)",
								logcur->path, logcur->uid, logcur->gid, logcur->name,
								strerror(errno));
			}
		}
	;
    break;}
case 15:
#line 186 "../grammar.y"
{
		if(logcur->path) {
			rl_warn("duplicate path declaration (%s) in log directive, ignoring",
							yyvsp[-1].cp);
			free(yyvsp[-1].cp);
		} else {
			logcur->path = yyvsp[-1].cp;
		}
	;
    break;}
case 16:
#line 196 "../grammar.y"
{
		logcur->uid = yyvsp[-1].uid->pw_uid;
	;
    break;}
case 17:
#line 200 "../grammar.y"
{
		logcur->gid = yyvsp[-1].gid->gr_gid;
	;
    break;}
case 18:
#line 204 "../grammar.y"
{
		logcur->mode = yyvsp[-1].num;
	;
    break;}
case 19:
#line 210 "../grammar.y"
{
		service_free(defaults);
 		service_copy(defaults, current_service);
		opmetalist_free(yyvsp[-1].opml);
		free(yyvsp[-1].opml);
	;
    break;}
case 20:
#line 219 "../grammar.y"
{
		struct opmetalist *parent;
		struct opmetalist *onexit;
		struct oplist *ops;
		int i, bound;
		int fds;
		fd_set *fdst;

		parent = opmetalist_new();
		onexit = opmetalist_new();

		current_service->name = yyvsp[-3].cp;
		current_service->iname = stringtab_add(yyvsp[-3].cp);
 		if(current_service->socktype == SOCK_STREAM) {
 			if(opmetalist_add(yyvsp[-1].opml, opmeta_make(2, OP_ACCEPT, 200))) { /* !200 */
				rl_warn("opcode resolving problem");
				current_service->disabled++;
			}
			opmetalist_add(parent, opmeta_make(1, OP_CLOSE));
		} else {
			opmetalist_add(parent, opmeta_make(1, OP_RET));
		}
		opmetalist_add(onexit, opmeta_make(1, OP_RET));
		validate_service(current_service);
		if(!current_service->disabled)
			fds = bind_ports();
		
		if(current_service->limit) {
			struct opmetalist *o;
			struct oplist *l;
			int match, under;

			o = opmetalist_new();
			opmetalist_add(o, opmeta_make(2, OP_LCLR, fds));
			opmetalist_add(o, opmeta_make(1, OP_RET));
			l = opmetalist_resolve(o);
			match = oplisttab_add(l);
			opmetalist_free(o);
			free(o);
			oplist_free(l);
			free(l);
			
			o = opmetalist_new();
			opmetalist_add(o, opmeta_make(2, OP_LSET, fds));
			opmetalist_add(o, opmeta_make(1, OP_RET));
			l = opmetalist_resolve(o);
			under = oplisttab_add(l);
			opmetalist_free(o);
			free(o);
			oplist_free(l);
			free(l);
			
			i = semaphore_add(current_service->limit, match, under);
			opmetalist_add(yyvsp[-1].opml, opmeta_make(2, OP_DOWN, i));
			opmetalist_add(onexit, opmeta_make(2, OP_UP, i));
		}
		ops = opmetalist_resolve(onexit);
		current_service->onexit = oplisttab_add(ops);
		opmetalist_free(onexit);
		free(onexit);
		oplist_free(ops);
		free(ops);
		
		ops = opmetalist_resolve(parent);
		current_service->parent = oplisttab_add(ops);
		opmetalist_free(parent);
		free(parent);
		oplist_free(ops);
		free(ops);

		opmetalist_add(yyvsp[-1].opml, opmeta_make(2, OP_JUMP, current_service->onexit));
		ops = opmetalist_resolve(yyvsp[-1].opml);
		current_service->run = oplisttab_add(ops);
		opmetalist_free(yyvsp[-1].opml);
		free(yyvsp[-1].opml);
		oplist_free(ops);
		free(ops);

		fdst = fdsettab_get(fds);
		bound = getdtablesize();
		for(i = 0; i < bound; i++)
			if(FD_ISSET(i, fdst))
				read_hook(i, oplisttab_get(current_service->run), NULL);

		service_free(current_service);
		service_copy(current_service, defaults);
	;
    break;}
case 21:
#line 309 "../grammar.y"
{
		yyval.opml = opmetalist_new();
	;
    break;}
case 22:
#line 313 "../grammar.y"
{
		yyval.opml = yyvsp[-1].opml;
	;
    break;}
case 23:
#line 317 "../grammar.y"
{
		struct opmetalist *l;

		l = opmetalist_new();
		if(opmetalist_add(l, yyvsp[0].opm)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		yyval.opml = l;
	;
    break;}
case 24:
#line 328 "../grammar.y"
{
		if(opmetalist_add(yyvsp[-1].opml, yyvsp[0].opm)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		yyval.opml = yyvsp[-1].opml;
	;
    break;}
case 25:
#line 336 "../grammar.y"
{
		yyval.opml = opmetalist_join(yyvsp[-1].opml, yyvsp[0].opml);
		if(!yyval.opml) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
	;
    break;}
case 26:
#line 344 "../grammar.y"
{
		yyval.opml = yyvsp[0].opml;
	;
    break;}
case 27:
#line 350 "../grammar.y"
{
		yyval.opml = yyvsp[0].opml;
	;
    break;}
case 28:
#line 354 "../grammar.y"
{
		struct opmetalist *l;

		l = opmetalist_new();
		if(opmetalist_add(l, yyvsp[0].opm)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		yyval.opml = l;
	;
    break;}
case 29:
#line 365 "../grammar.y"
{
		if(opmetalist_add(yyvsp[-1].opml, yyvsp[0].opm)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		yyval.opml = yyvsp[-1].opml;
	;
    break;}
case 30:
#line 373 "../grammar.y"
{
		yyval.opml = opmetalist_join(yyvsp[-1].opml, yyvsp[0].opml);
		if(!yyval.opml) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
	;
    break;}
case 31:
#line 383 "../grammar.y"
{
		struct opmetalist *l;
		struct opmeta *o;
		
		l = opmetalist_new();
		o = opmeta_make(3, OP_EXEC, 666, argvtab_add(yyvsp[-1].cp));
		opmeta_fixup(o, 1, &current_service->exec);
		if(opmetalist_add(l, o)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		o = opmeta_make(3, OP_FORK, 666, 666);
		opmeta_fixup(o, 1, &current_service->parent);
		opmeta_fixup(o, 2, &current_service->onexit);
		if(opmetalist_add(l, o)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		yyval.opml = l;
	;
    break;}
case 32:
#line 404 "../grammar.y"
{
		struct opmetalist *l;
		struct opmeta *o;

		l = opmetalist_new();
		o = opmeta_make(3, OP_INITGR, 666, 666);
		opmeta_fixup(o, 1, &current_service->iuser);
		opmeta_fixup(o, 2, &current_service->supgid);
		if(opmetalist_add(l, o)) {
			rl_warn("opcode resolving problem");
			current_service->disabled++;
		}
		if(!current_service->sgid) {
			o = opmeta_make(2, OP_SGID, 666);
			opmeta_fixup(o, 1, &current_service->setgid);
			current_service->sgid = 1;
			if(opmetalist_add(l, o)) {
				rl_warn("opcode resolving problem");
				current_service->disabled++;
			}
		}
		yyval.opml = l;
	;
    break;}
case 33:
#line 430 "../grammar.y"
{
		yyval.opm = opmeta_make(2, OP_NICE, yyvsp[-1].num);
	;
    break;}
case 34:
#line 434 "../grammar.y"
{
		yyval.opm = opmeta_make(1, OP_FISH);
	;
    break;}
case 35:
#line 438 "../grammar.y"
{
		yyval.opm = opmeta_make(3, OP_RLIMIT, yyvsp[-1].num, yyvsp[0].num);
	;
    break;}
case 36:
#line 442 "../grammar.y"
{
		int i;

		i = logtab_add(-1, yyvsp[-1].cp);
		yyval.opm = opmeta_make(2, OP_LOG, i);
		free(yyvsp[-1].cp);
	;
    break;}
case 37:
#line 450 "../grammar.y"
{
		if(yyvsp[-1].uid) {
			current_service->iuser = stringtab_add(yyvsp[-1].uid->pw_name);
			if(current_service->setgid != -1) {
				current_service->supgid = yyvsp[-1].uid->pw_gid;
			} else {
				current_service->setgid = yyvsp[-1].uid->pw_gid;
			}
			yyval.opm = opmeta_make(2, OP_SUID, yyvsp[-1].uid->pw_uid);
		} else {
			rl_warn("unknown username");
			current_service->disabled++;
			yyval.opm = NULL;
		}
	;
    break;}
case 38:
#line 466 "../grammar.y"
{
		int ret;

		ret = buftab_addfile(yyvsp[-1].cp);
		if(ret == -1)
			current_service->disabled++;
		yyval.opm = opmeta_make(16, OP_ZERO, OP_BUFCLONE, ret, OP_WHOOK, 0, OP_WUNHOOK,
										 OP_DUP, OP_BUFCOPY, OP_DUP, OP_BZNEG, 3, OP_ADD,
										 OP_WHOOK, -9, OP_POP, OP_BUFFREE);
		free(yyvsp[-1].cp);
	;
    break;}
case 39:
#line 478 "../grammar.y"
{
		int i;

		if(yyvsp[-1].cp) {
			i = buftab_addfile(yyvsp[-1].cp);
			if(i < 0)
				current_service->disabled++;
		} else {
			i = chargen_buffer();
		}
		yyval.opm = opmeta_make(25, OP_ZERO, OP_DUP, OP_BUFCLONE, i, OP_POP,
										 OP_POP, OP_ZERO, OP_WHOOK, 0, OP_WUNHOOK, OP_DUP,
										 OP_BUFCOPY, OP_DUP, OP_BZ, -11, OP_DUP, OP_BZNEG, 3,
										 OP_ADD, OP_WHOOK, -12, OP_POP, OP_BUFFREE, OP_JUMP, 666);
		opmeta_fixup(yyval.opm, 24, &current_service->onexit);
		if(yyvsp[-1].cp)
			free(yyvsp[-1].cp);
	;
    break;}
case 40:
#line 497 "../grammar.y"
{
		struct logdata *ld = logdata_get(yyvsp[-2].cp);

		if(!ld) {
			rl_warn("unknown log %s", yyvsp[-2].cp);
			current_service->disabled++;
		} else {
			int i = logtab_add(ld->index, yyvsp[-1].cp);
			yyval.opm = opmeta_make(2, OP_LOG, i);
		}
		free(yyvsp[-2].cp);
		free(yyvsp[-1].cp);
	;
    break;}
case 41:
#line 511 "../grammar.y"
{
		if(yyvsp[-1].gid) {
			struct opmeta *o = NULL;

			if(!current_service->sgid) {
				o = opmeta_make(2, OP_SGID, 666);
				opmeta_fixup(o, 1, &current_service->setgid);
				current_service->sgid = 1;
			}
			current_service->supgid = current_service->setgid;
			current_service->setgid = yyvsp[-1].gid->gr_gid;
			yyval.opm = o;
		} else {
			rl_warn("unknown group");
			current_service->disabled++;
			yyval.opm = NULL;
		}
	;
    break;}
case 42:
#line 530 "../grammar.y"
{
		yyval.opm = opmeta_make(2, OP_CHROOT, argvtab_add(yyvsp[-1].cp));
	;
    break;}
case 43:
#line 534 "../grammar.y"
{
#ifdef HAVE_CAPABILITIES
		cap_t caps = cap_from_text(yyvsp[-1].cp);
		if(caps) {
			yyval.opm = opmeta_make(2, OP_SETCAP, captab_add(caps));
		} else {
			rl_warn("failed to parse capability string \"%s\"\n", yyvsp[-1].cp);
			current_service->disabled++;
		}
		free(yyvsp[-1].cp);
#else
		rl_fatal(EX_DATAERR, "ABORT - support for capabilities not compiled in");
#endif
	;
    break;}
case 44:
#line 549 "../grammar.y"
{
		int i;
		struct oplist *op;

		opmetalist_add(yyvsp[-1].opml, opmeta_make(1, OP_RET));
		op = opmetalist_resolve(yyvsp[-1].opml);
		i = oplisttab_add(op);
		yyval.opm = opmeta_make(3, OP_WRAP, stringtab_add(yyvsp[-3].cp), i);
		free(yyvsp[-3].cp);
		oplist_free(op);
		free(op);
		opmetalist_free(yyvsp[-1].opml);
		free(yyvsp[-1].opml);
	;
    break;}
case 45:
#line 564 "../grammar.y"
{
		struct opmeta *o;
		int i;
		struct oplist *op;

		opmetalist_add(yyvsp[-1].opml, opmeta_make(1, OP_RET));
		op = opmetalist_resolve(yyvsp[-1].opml);
		i = oplisttab_add(op);
		o = opmeta_make(3, OP_WRAP, 666, i);
		opmeta_fixup(o, 1, &current_service->iname);
		yyval.opm = o;
		oplist_free(op);
		free(op);
		opmetalist_free(yyvsp[-1].opml);
		free(yyvsp[-1].opml);
	;
    break;}
case 46:
#line 581 "../grammar.y"
{
		struct opmetalist *l;
		int i;
		struct oplist *op;

		l = opmetalist_new();
		opmetalist_add(l, opmeta_make(1, OP_EXIT));
		op = opmetalist_resolve(l);
		i = oplisttab_add(op);
		yyval.opm = opmeta_make(3, OP_WRAP, stringtab_add(yyvsp[-1].cp), i);
		free(yyvsp[-1].cp);
		oplist_free(op);
		free(op);
		opmetalist_free(l);
		free(l);
	;
    break;}
case 47:
#line 598 "../grammar.y"
{
		struct opmetalist *l;
		struct opmeta *o;
		int i;
		struct oplist *op;

		l = opmetalist_new();
		opmetalist_add(l, opmeta_make(1, OP_EXIT));
		op = opmetalist_resolve(l);
		i = oplisttab_add(op);
		o = opmeta_make(3, OP_WRAP, 666, i);
		opmeta_fixup(o, 1, &current_service->iname);
		yyval.opm = o;
		oplist_free(op);
		free(op);
		opmetalist_free(l);
		free(l);
	;
    break;}
case 48:
#line 617 "../grammar.y"
{
		yyval.opm = opmeta_make(1, OP_CLOSE);
	;
    break;}
case 49:
#line 621 "../grammar.y"
{
		yyval.opm = opmeta_make(1, OP_EXIT);
	;
    break;}
case 50:
#line 625 "../grammar.y"
{
		yyval.opm = opmeta_make(2, OP_ECHO, argvtab_add(yyvsp[-1].cp));
	;
    break;}
case 51:
#line 629 "../grammar.y"
{
		yyval.opm = opmeta_make(29, OP_ZERO, OP_BUFINIT, 11, OP_RHOOK, 0, OP_BUFREAD,
										 OP_RUNHOOK, OP_DUP, OP_BZNEG, 17, OP_ADD, OP_WHOOK, 0,
										 OP_BUFWRITE, OP_WUNHOOK, OP_DUP, OP_BZ, 6, OP_DUP,
										 OP_BZNEG, 6, OP_SUB, OP_WHOOK, -11, OP_POP, OP_RHOOK, -22,
										 OP_JUMP, 666);
		opmeta_fixup(yyval.opm, 28, &current_service->onexit);
	;
    break;}
case 52:
#line 638 "../grammar.y"
{
		yyval.opm = opmeta_make(13, OP_ZERO, OP_RHOOK, 0, OP_RUNHOOK, OP_BUFINIT, 1024,
										 OP_BUFREAD, OP_BZNEG, 2, OP_RHOOK, -8, OP_JUMP, 666);
		opmeta_fixup(yyval.opm, 12, &current_service->onexit);
	;
    break;}
case 53:
#line 646 "../grammar.y"
{	yyval.cp = NULL;	;
    break;}
case 56:
#line 652 "../grammar.y"
{
		if(current_service->port)
			stringlist_free(current_service->port);
		current_service->port = stringlist;
		stringlist = NULL;
	;
    break;}
case 57:
#line 659 "../grammar.y"
{
		current_service->socktype = yyvsp[-1].num;
	;
    break;}
case 58:
#line 663 "../grammar.y"
{
		current_service->backlog = yyvsp[-1].num;
	;
    break;}
case 59:
#line 667 "../grammar.y"
{
		current_service->limit = yyvsp[-1].num;
	;
    break;}
case 60:
#line 671 "../grammar.y"
{
		if(current_service->interface)
			stringlist_free(current_service->interface);
		current_service->interface = stringlist;
		stringlist = NULL;
	;
    break;}
case 61:
#line 678 "../grammar.y"
{
		current_service->exec = stringtab_add(yyvsp[-1].cp);
		free(yyvsp[-1].cp);
	;
    break;}
case 64:
#line 685 "../grammar.y"
{
#ifdef HAVE_NET_BPF_H
		if(current_service->filter)
			free(current_service->filter);
		if(rl_readfile(yyvsp[-1].cp, &current_service->filter, &current_service->filterlen))
			current_service->disabled++;
		free(yyvsp[-1].cp);
#else
		rl_fatal(EX_DATAERR, "ABORT - support for socket filter not compiled in");
#endif
	;
    break;}
case 67:
#line 704 "../grammar.y"
{
		current_service->rpcname = yyvsp[-1].cp;
	;
    break;}
case 68:
#line 708 "../grammar.y"
{
		current_service->rpcvers = numlist;
		numlist = NULL;
	;
    break;}
case 71:
#line 719 "../grammar.y"
{
		numlist_add(&numlist, yyvsp[0].num);
	;
    break;}
case 72:
#line 723 "../grammar.y"
{
		int i;

		if(yyvsp[0].num >= yyvsp[-2].num)
			for(i = yyvsp[-2].num; i <= yyvsp[0].num; i++)
				numlist_add(&numlist, i);
	;
    break;}
case 75:
#line 737 "../grammar.y"
{
		current_service->r.rlim_cur = yyvsp[-1].rl;
	;
    break;}
case 76:
#line 741 "../grammar.y"
{
		current_service->r.rlim_max = yyvsp[-1].rl;
	;
    break;}
case 79:
#line 751 "../grammar.y"
{
		stringlist_add(&stringlist, yyvsp[0].cp);
	;
    break;}
case 82:
#line 761 "../grammar.y"
{
		stringlist_add(&stringlist, yyvsp[0].cp);
	;
    break;}
case 83:
#line 765 "../grammar.y"
{
		char tmp[20];

		snprintf(tmp, 19, "%ld", yyvsp[0].num);
		tmp[19] = '\0';
		stringlist_add(&stringlist, strdup(tmp));
	;
    break;}
case 84:
#line 775 "../grammar.y"
{
		yyval.num = rlimittab_add(yyvsp[-1].rl, yyvsp[-1].rl);
	;
    break;}
case 85:
#line 779 "../grammar.y"
{
		if((current_service->r.rlim_max != RLIM_INFINITY) &&
			 (current_service->r.rlim_cur > current_service->r.rlim_max)) {
			rl_warn("invalid resource limit");
		}
		yyval.num = rlimittab_add(current_service->r.rlim_cur, current_service->r.rlim_max);
		current_service->r.rlim_cur = current_service->r.rlim_max = RLIM_INFINITY;
	;
    break;}
case 86:
#line 790 "../grammar.y"
{ yyval.rl = (rlim_t)yyvsp[0].num; ;
    break;}
case 87:
#line 792 "../grammar.y"
{ yyval.rl = RLIM_INFINITY; ;
    break;}
case 88:
#line 796 "../grammar.y"
{ yyval.num = RLIMIT_CPU; ;
    break;}
case 89:
#line 798 "../grammar.y"
{ yyval.num = RLIMIT_FSIZE; ;
    break;}
case 90:
#line 800 "../grammar.y"
{ yyval.num = RLIMIT_DATA; ;
    break;}
case 91:
#line 802 "../grammar.y"
{ yyval.num = RLIMIT_STACK; ;
    break;}
case 92:
#line 804 "../grammar.y"
{ yyval.num = RLIMIT_CORE; ;
    break;}
case 93:
#line 806 "../grammar.y"
{ yyval.num = RLIMIT_RSS; ;
    break;}
case 94:
#line 808 "../grammar.y"
{
#ifdef RLIMIT_NPROC
		yyval.num = RLIMIT_NPROC;
#else
		rl_fatal(EX_DATAERR, "nproc limit not available on this system");
#endif
	;
    break;}
case 95:
#line 816 "../grammar.y"
{
#ifdef RLIMIT_NOFILE
		yyval.num = RLIMIT_NOFILE;
#else
		rl_fatal(EX_DATAERR, "nofile limit not available on this system");
#endif
	;
    break;}
case 96:
#line 824 "../grammar.y"
{
#ifdef RLIMIT_MEMLOCK
		yyval.num = RLIMIT_MEMLOCK;
#else
		rl_fatal(EX_DATAERR, "memlock limit not available on this system");
#endif		
	;
    break;}
case 97:
#line 834 "../grammar.y"
{
		yyval.uid = getpwuid(yyvsp[0].num);
		endpwent();
	;
    break;}
case 98:
#line 839 "../grammar.y"
{
		yyval.uid = getpwnam(yyvsp[0].cp);
		free(yyvsp[0].cp);
		endpwent();
	;
    break;}
case 99:
#line 847 "../grammar.y"
{
		yyval.gid = getgrgid(yyvsp[0].num);
		endgrent();
	;
    break;}
case 100:
#line 852 "../grammar.y"
{
		yyval.gid = getgrnam(yyvsp[0].cp);
		free(yyvsp[0].cp);
		endgrent();
	;
    break;}
case 101:
#line 860 "../grammar.y"
{
		yyval.num = SOCK_STREAM;
		current_service->protoname = "tcp";
		current_service->proto = IPPROTO_TCP;
	;
    break;}
case 102:
#line 866 "../grammar.y"
{
		yyval.num = SOCK_DGRAM;
		current_service->protoname = "udp";
		current_service->proto = IPPROTO_UDP;
	;
    break;}
case 103:
#line 874 "../grammar.y"
{
		current_service->family = PF_INET;
	;
    break;}
case 104:
#line 878 "../grammar.y"
{
#ifdef HAVE_SOCKADDR_IN6		
		current_service->family = PF_INET6;
#else		
		rl_warn("you have no ipv6 support");
		current_service->family = PF_INET;
#endif
	;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/share/misc/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 888 "../grammar.y"


void yyerror(char *str) {
	rl_fatal(EX_DATAERR, str);
}

int yywrap() {
	fclose(yyin);
	if(numfiles) {
		while(curfile < numfiles) {
			if((yyin = fopen(files[curfile++], "r")))
				return 0;
		}
	}
	return 1;
}

static struct service *service_new() {
	struct service *p = (struct service *)malloc(sizeof(*p));

	memset(p, 0, sizeof(*p));
	return p;
}

void services_free() {
	struct rl_cleanup *p;

	while(rl_cleanups) {
		rlp_cleanup(rl_cleanups);
		p = rl_cleanups->next;
		free(rl_cleanups);
		rl_cleanups = p;
	}
}

static void validate_service(struct service *s) {
	if(!s->name) {
		rl_warn("service without name");
		s->disabled++;
		return;
	}
	if(s->rpcvers) {
		char *rpcname = s->name;
		struct rpcent *rep;

		if(s->rpcname)
			rpcname = s->rpcname;
		rep = getrpcbyname(rpcname);
		if(!rep) {
			rl_warn("can't find rpc service %s for service %s",
							rpcname, s->name);
			s->disabled++;
		} else {
			s->rpcnum = rep->r_number;
		}
		endrpcent();
	}
}
		 
static int bind_ports() {
	int fd;
	long opt = 1;
	struct stringlist *portp;
	struct stringlist *ifp;
#ifdef HAVE_GETADDRINFO
	struct addrinfo hints;
	struct addrinfo *results = NULL, *ai;
	int ret;
#else
	void *addrbuf;
	int portnum;
	char *ctmp;
#endif	
	char *port, *addr;
	char *lasterror, *errfunc;
	int succeeded;
	fd_set fds;

	int family, socktype, protocol, saddrlen;
	struct sockaddr *saddr = NULL;
	
	FD_ZERO(&fds);
	ifp = current_service->interface;
	do {
		struct stringlist fallback = { current_service->name, NULL };

		addr = ifp ? ifp->str : NULL;
		portp = current_service->port;
		if(!portp)
			portp = &fallback;
		do {
			lasterror = NULL;
			succeeded = 0;
				
			port = portp->str;
#ifdef HAVE_GETADDRINFO
			memset(&hints, 0, sizeof(hints));
			hints.ai_flags = AI_PASSIVE;
			hints.ai_family = current_service->family;
			hints.ai_socktype = current_service->socktype;
			hints.ai_protocol = current_service->proto;
			if(results)
				freeaddrinfo(results);
			results = NULL;
			if((ret = getaddrinfo(addr, port, &hints, &results))) {
				rl_warn("getaddrinfo(%s, %s) failed: %s", addr, port,
#ifdef HAVE_GAI_STRERROR
								gai_strerror(ret)
#else
								"for reasons unknown"
#endif									
								);
				continue;
			}
			ai = results;
			do {
				family = ai->ai_family;
				socktype = ai->ai_socktype;
				protocol = ai->ai_protocol;
				saddr = ai->ai_addr;
				saddrlen = ai->ai_addrlen;
#else
				portnum = strtoul(port, &ctmp, 10);
				if(*ctmp) {
					portnum = getservport(port, current_service->protoname);
					if(portnum == -1) {
						rl_warn("Failed to resolve %s port %s",
										current_service->proto, port);
						continue;
					}
				}
				family = current_service->family;
				socktype = current_service->socktype;
				protocol = current_service->proto;
				if(saddr) {
					free(saddr);
					saddr = NULL;
				}
				switch(family) {
					struct sockaddr_in *sin;
#ifdef HAVE_SOCKADDR_IN6
					struct sockaddr_in6 *sin6;
#endif
						
					case PF_INET:
						saddrlen = sizeof(struct sockaddr_in);
						sin = (struct sockaddr_in *)malloc(saddrlen);
						addrbuf = &sin->sin_addr.s_addr;
						sin->sin_family = current_service->family;
						sin->sin_port = htons(portnum);
						sin->sin_addr.s_addr = INADDR_ANY;
						saddr = (struct sockaddr *)sin;
						break;
#ifdef HAVE_SOCKADDR_IN6
					case PF_INET6:
						saddrlen = sizeof(struct sockaddr_in6);
						sin6 = (struct sockaddr_in6 *)malloc(saddrlen);
						addrbuf = &sin6->sin_addr.s_addr;
						sin6->sin6_family = current_service->family;
						sin6->sin6_port = htons(portnum);
						sin6->sin6_addr = IN6ADDR_ANY_INIT;
						saddr = (struct sockaddr *)sin6;
						break;
#endif							
					default:
						rl_fatal(EX_SOFTWARE, "funky family in service");
				}
				if(addr) {
					if(
#ifdef HAVE_INET_PTON
						 inet_pton(family, addr, addrbuf)
#else						
																/* this cast is a pain */
						 (*(unsigned int *)addrbuf = inet_addr(addr)) == -1
#endif
						 ) {
						rl_warn("bad address %s in service %s", addr,
										current_service->name);
						free(saddr);
						saddr = NULL;
						continue;
					}
				}
#endif				
				if((fd = socket(family, socktype, protocol)) < 0) {
					lasterror = strerror(errno);
					close(fd);
					errfunc = "socket()";
					goto out;
				}
				if(setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))) {
					rl_warn("setsockopt(%d, SOL_SOCKET, SO_REUSEADDR, 1) failed for service %s (%s)",
									fd, current_service->name, strerror(errno));
				}
#ifdef HAVE_NET_BPF_H
				if(current_service->filter) {
					struct bpf_program bp;

					bp.bf_len = current_service->filterlen / sizeof(struct bpf_insn);
					bp.bf_insns = current_service->filter;
					if(setsockopt(fd, SOL_SOCKET, SO_ATTACH_FILTER, &bp, sizeof(bp))) {
						lasterror = strerror(errno);
						close(fd);
						errfunc = "setsockopt(..., SO_ATTACH_FILTER)";
						goto out;
					}
				}
#endif				
				if(bind(fd, saddr, saddrlen) < 0) {
					lasterror = strerror(errno);
					close(fd);
					errfunc = "bind()";
					goto out;
				}
				if(current_service->rpcnum) {
					struct numlist *vers = current_service->rpcvers;
					struct rl_cleanup *p;

					do {
						if(!pmap_set(current_service->rpcnum, vers->num,
												 protocol,
												 ntohs(((struct sockaddr_in *)saddr)->sin_port)))
							rl_warn("pmap_set(%d, %d, %d, %d) failed for service %s",
											current_service->rpcnum, vers->num,
											protocol, ntohs(((struct sockaddr_in *)saddr)->sin_port),
											current_service->name);
					} while((vers = vers->next));
					p = (struct rl_cleanup *)malloc(sizeof(struct rl_cleanup));
					p->next = rl_cleanups;
					p->data =	(struct rlc_unrpc *)malloc(sizeof(struct rlc_unrpc));
					p->type = RLC_UNRPC;
					((struct rlc_unrpc *)p->data)->vers =	current_service->rpcvers;
					((struct rlc_unrpc *)p->data)->prog =	current_service->rpcnum;
					current_service->rpcvers = NULL;
					rl_cleanups = p;
				}
				FD_SET(fd, &fds);
				if(socktype == SOCK_STREAM) {
					if(listen(fd, current_service->backlog)) {
						lasterror = strerror(errno);
						close(fd);
						errfunc = "listen(fd)";
						goto out;
					}
				}
				if(fcntl(fd, F_SETFD, 1)) {
					lasterror = strerror(errno);
					errfunc = "fcntl(fd, F_SETFD, 1)";
					close(fd);
					goto out;
				}
				if(fcntl(fd, F_SETFL, O_NDELAY)) {
					lasterror = strerror(errno);
					close(fd);
					errfunc = "fcntl(fd, F_SETFL, O_NDELAY)";
					goto out;
				}
				succeeded++;
			out:
#ifdef HAVE_GETADDRINFO
			} while((ai = ai->ai_next));
#endif
			if(!succeeded && lasterror)
				rl_warn("%s failed for service %s: %s",
								errfunc, current_service->name, lasterror);
		} while(portp && (portp = portp->next));
	} while(ifp && (ifp = ifp->next));
	stringlist_free(current_service->port);
	current_service->port = NULL;
	stringlist_free(current_service->interface);
	current_service->interface = NULL;
#ifdef HAVE_GETADDRINFO
	if(results) {
		freeaddrinfo(results);
		results = NULL;
	}
#else
	if(saddr) {
		free(saddr);
		saddr = NULL;
	}
#endif	
	return fdsettab_add(&fds);
}

static void service_free(struct service *s) {
	if(s->name) {
		free(s->name);
		s->name = NULL;
	}
	stringlist_free(s->port);
	s->port = NULL;
	stringlist_free(s->interface);
	s->interface = NULL;
	if(s->rpcname) {
		free(s->rpcname);
		s->rpcname = NULL;
	}
	if(s->rpcvers) {
		numlist_free(s->rpcvers);
		s->rpcvers = NULL;
	}
#ifdef HAVE_CAPABILITIES
	if(s->caps) {
		cap_free(&s->caps);
		s->caps = NULL;
	}
#endif	
#ifdef HAVE_NET_BPF_H
	if(s->filter) {
		free(s->filter);
		s->filter = NULL;
		s->filterlen = 0;
	}
#endif	
}

static void service_copy(struct service *to, struct service *from) {
	memcpy(to, from, sizeof(*to));
	to->name = NULL;
	to->port = NULL;
	to->interface = NULL;
	stringlist_copy(&to->port, from->port);
	stringlist_copy(&to->interface, from->interface);
	to->rpcname = from->rpcname ? strdup(from->rpcname) : NULL;
	numlist_copy(&to->rpcvers, from->rpcvers);
#ifdef HAVE_LIBCAP
	to->caps = from->caps ? cap_dup(from->caps) : NULL;
#endif
#ifdef HAVE_NET_BPF_H
	if(from->filter) {
		to->filter = malloc(from->filterlen);
		memcpy(to->filter, from->filter, from->filterlen);
	}
#endif	
}

static struct logdata *logdata_get(char *name) {
	struct logdata *ptr = logdatas;

	if(!ptr)
		return NULL;
	do {
		if(!strcmp(name, ptr->name))
			return ptr;
	} while((ptr = ptr->next));
	return NULL;
}

static void logdatas_free() {
	struct logdata *p, *q;

	p = logdatas;
	while(p) {
		q = p->next;
		if(p->name)
			free(p->name);
		if(p->path)
			free(p->path);
		free(p);
		p = q;
	}
	logdatas = NULL;
}

static struct logdata *logdata_new() {
	struct logdata *ptr = (struct logdata *)malloc(sizeof(*ptr));
	memset(ptr, 0, sizeof(*ptr));
	ptr->index = -1;
	ptr->mode =
#ifdef S_IRUSR
		S_IRUSR|S_IWUSR|S_IRGRP
#else
		0640
#endif
		;
	ptr->uid = -1;
	ptr->gid = -1;
	return ptr;
}

void parse() {
	void freebufs();
	
	numlist = NULL;
	userdata = NULL;
	newuserdata(&userdata);
	pidtab_fixup();
	all_unhook();
	logtabs_free();
	argvtabs_free();
	rlimittabs_free();
	services_free();
	stringtabs_free();
	buftabs_free();
	oplisttabs_free();
#ifdef HAVE_CAPABILITIES
	captabs_free();
#endif	
	semaphores_free();
	fdsettabs_free();
	if(strcmp(rl_config, "-") || !rl_debug)
		if(!(yyin = fopen(rl_config, "r")))
			rl_fatal(EX_NOINPUT, "fopen(%s) failed, aborting", rl_config);
	logcur = logdata_new();
	current_service = service_new();
	defaults = service_new();
#ifdef HAVE_GETADDRINFO
	defaults->family = PF_UNSPEC;
#else	
	defaults->family = PF_INET;
#endif	
	defaults->socktype = SOCK_STREAM;
	defaults->protoname = "tcp";
	defaults->proto = IPPROTO_TCP;
	defaults->backlog = 5;
	defaults->limit = 40;
	defaults->r.rlim_cur = RLIM_INFINITY;
	defaults->r.rlim_max = RLIM_INFINITY;
	defaults->exec = -1;

	defaults->iname = -1;
	defaults->exec = -1;
	defaults->parent = -1;
	defaults->iuser = -1;
	defaults->supgid = -1;
	defaults->setgid = -1;
	service_copy(current_service, defaults);
 	yyparse();
	freebufs();
	service_free(defaults);
	free(defaults);
	defaults = NULL;
	logdatas_free();
	free(logcur);
	logcur = NULL;
	service_free(current_service);
	free(current_service);
	current_service = NULL;
	for(curfile = 0; curfile < numfiles; curfile++) {
		free(files[curfile]);
		files[curfile] = NULL;
	}
	free(files);
	files = NULL;
	clearuserdata(&userdata);
	free(userdata);
}

static void pidtab_fixup() {
	struct pidtab *p;
	int i;

	for(i = 0; i < 8; i++) {
		p = pidtabs[i].next;
		while(p) {
			if(p->inst)
				inst_free(p->inst);
			p->inst = NULL;
			p = p->next;
		}
	}
}

#ifndef HAVE_GETADDRINFO
static int getservport(char *str, char *proto) {
	struct servent *foo;
	int ret = -1;

	foo = getservbyname(str, proto);
	if(foo)
		ret = ntohs(foo->s_port);
	endservent();
	return ret;
}
#endif

static void add_directory(char *dir, char *match, char *ignore) {
	DIR *d;
	struct dirent *de;
	regex_t rmatch, rignore;
	char err[128];
	int e;
	struct stat st;
	char *file;

	if(match)
		if((e = regcomp(&rmatch, match, REG_EXTENDED|REG_NOSUB))) {
			regerror(e, &rmatch, err, 127);
			rl_warn("regexp compile failed for directory %s: %s",
							dir, err);
		}
	if(ignore)
		if((e = regcomp(&rignore, ignore, REG_EXTENDED|REG_NOSUB))) {
			regerror(e, &rignore, err, 127);
			rl_warn("regexp compile failed for directory %s: %s",
							dir, err);
		}
			
	if((d = opendir(dir))) {
		while((de = readdir(d))) {
			if(match)
				if(regexec(&rmatch, de->d_name, 0, NULL, 0))
					continue;
			if(ignore)
				if(!regexec(&rignore, de->d_name, 0, NULL, 0))
					continue;
			if(de->d_name[0] != '.') {
				file = malloc(strlen(dir) + NAMLEN(de) + 2);
				file[0] = '\0';
				strcat(file, dir);
				strcat(file, "/");
				strcat(file, de->d_name);
				if(stat(file, &st) || S_ISDIR(st.st_mode)) {
					free(file);
					continue;
				}
				files = (char **)realloc(files, ++numfiles * sizeof(char *));
				files[numfiles - 1] = file;
			}
		}
	} else {
		rl_fatal(EX_NOINPUT, "Directory open failed");
	}
	closedir(d);
	free(dir);
	if(match) {
		free(match);
		regfree(&rmatch);
	}
	if(ignore) {
		free(ignore);
		regfree(&rignore);
	}
}

int chargen_buffer() {
	static int cb = -1;
	char *b = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\r\n";
	
	if(cb == -1)
		cb = buftab_addbuf(b, strlen(b));
	return cb;
}
