// Constituent:  definition of a constituent (name, speed, equilibrium args,
// node factors).  This is an abstract class implemented by BaseConstituent
// and TabulatedConstituent.  (BaseConstituent is only present in the
// congen package.)
// Last modified by DWF 1998-04-10

/*
    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "common.hh"

Dstr &
Constituent::name () {
  return myname;
}

void
Constituent::name (Dstr &in_name) {
  myname = in_name;
}

Dstr &
Constituent::padname () {
  static Dstr tempname;
  tempname = myname;
  tempname.pad (20);
  return tempname;
}

Speed
Constituent::speed () {
  return myspeed;
}

ostream &operator<< (ostream &out, Constituent &v) {
  v.putspeed (out);
  v.putargs (out);
  v.putnods (out);
  return out;
}

Dstr &
Constituent::putspeed () {
  static Dstr buf;
  buf = padname();
  buf += " ";
  buf += myspeed.ppdeg (7, Speed::HOUR);
  buf += "\n";
  return buf;
}

Dstr &
Constituent::putargs () {
  static Dstr buf;
  buf = padname();
  buf += "\n";
  unsigned y, first, last;
  first = firstvalidyear().val();
  last = lastvalidyear().val();
  for (y=first; y<=last; y++) {
    Year ty (y);
    if (y > first) {
      if (!(y%10))
        buf += "\n";
      else
        buf += " ";
    }
    buf += arg(ty).ppdeg(2);
  }
  buf += "\n";
  return buf;
}

Dstr &
Constituent::putnods () {
  static Dstr buf;
  buf = padname();
  buf += "\n";
  unsigned y, first, last;
  first = firstvalidyear().val();
  last = lastvalidyear().val();
  for (y=first; y<=last; y++) {
    Year ty (y);
    if (y > first) {
      if (!(y%10))
        buf += "\n";
      else
        buf += " ";
    }
    char tempbuf[10];
    sprintf (tempbuf, "%6.4f", nod (ty));
    buf += tempbuf;
  }
  buf += "\n";
  return buf;
}

void
Constituent::putspeed (FILE *fp) {
  fputs (putspeed().aschar(), fp);
}

void
Constituent::putargs (FILE *fp) {
  fputs (putargs().aschar(), fp);
}

void
Constituent::putnods (FILE *fp) {
  fputs (putnods().aschar(), fp);
}

void
Constituent::putspeed (ostream &out) {
  out << putspeed();
}

void
Constituent::putargs (ostream &out) {
  out << putargs();
}

void
Constituent::putnods (ostream &out) {
  out << putnods();
}

Constituent::~Constituent() {
}
