/*
    copyright (c) 1998  dennis roddeman
    email: d.g.roddeman@wb.utwente.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h"

void print_gid( void )

{
  long int inod=0, element=0, max_node=0, max_element=0, name=0,
    element_group=0, length=0, idim=0, jdim=0, ipuknwn=0, iuknwn=0,
    icalcul=0, nval=0, ready=0, indx=0,
    first_name=0, length_post_calcul_scal_vec_mat=0,
    load_type=0, data_type=0, data_loc=0, desc_comp=0,
    swit=0, ldum=0, nnol=0, type=0,
    idum[1], dof_label[MUKNWN], dof_type[MUKNWN],
    post_calcul_scal_vec_mat[DATA_ITEM_SIZE], 
    post_calcul_unknown_operat[DATA_ITEM_SIZE], 
    dof_scal_vec_mat[MUKNWN], nodes[MAXIMUM_NODE], el[MAXIMUM_NODE+1];
  double time_current=0., step_val=0., tmp=0., ddum[1], coord[MDIM], 
    *node_dof=NULL, *node_dof_calcul=NULL;
  char descr_menu[MCHAR], filename[MCHAR], outname[MCHAR];

  db_version_copy( VERSION_NORMAL, VERSION_PRINT );
  renumbering( VERSION_PRINT, 1, 1 );

  db_highest_index( NODE, max_node, VERSION_PRINT );
  db_highest_index( ELEMENT, max_element, VERSION_PRINT );
  if ( ndim==1 || max_element<0 ) return;

  swit = set_swit(-1,-1,"print_gid");
  if ( swit ) pri( "In routine PRINT_GID" );

  strcpy( filename, data_file_base );   
  if ( ndim==2 ) 
    strcat( filename, ".flavia.dat" );
  else 
    strcat( filename, ".flavia.msh" );
  ofstream outmesh( filename, ios::app );

  strcpy( filename, data_file_base );
  strcat( filename, ".flavia.res" );
  ofstream outres( filename, ios::app );

  element = 1; db( ELEMENT, element, el, ddum, length, VERSION_PRINT, GET );
  first_name = el[0];
  if      ( first_name==-TRIA3 ) type = 3;
  else if ( first_name==-TRIA6 ) type = 6;
  else if ( first_name==-QUAD4 ) type = 4;
  else if ( first_name==-QUAD9 ) type = 9;
  else if ( first_name==-TET4  ) type = 3;
  else if ( first_name==-TET10 ) type = 3;
  else if ( first_name==-HEX8  ) type = 1;
  else if ( first_name==-HEX27 ) type = 1;
  else return;

  db( TIME_CURRENT, 0, idum, &time_current, ldum, VERSION_NORMAL, GET );

    // free initial lines
  outmesh << " \n";
  outmesh << " \n";
  outmesh << " \n";
  outmesh << " \n";
  outmesh << " \n";
  outmesh << "n_mesh_element n_mesh_points n_element_type:\n";

  outmesh << max_element << " " << max_node << " " << type << "\n";

  outmesh << "Coordinates:\n";
  for ( inod=1; inod<=max_node; inod++ ) {
    outmesh << inod << " ";
    for ( idim=0; idim<ndim; idim++ ) {
      db( NODE, inod, idum, coord, ldum, VERSION_PRINT, GET );
      if ( materi_displacement ) {
        node_dof = db_dbl( NODE_DOF, inod, VERSION_PRINT );
        outmesh << coord[idim]+node_dof[dis_indx+idim*nder] << " ";
      }
      else {
        outmesh << coord[idim] << " ";
      }
    }
    outmesh << "\n";
  }

  outmesh << "Connectivities:\n";
  for ( element=1; element<=max_element; element++ ) {
    if ( db_active_index( ELEMENT_GROUP, element, VERSION_PRINT ) )
      db( ELEMENT_GROUP, element, &element_group, ddum, ldum, VERSION_PRINT, GET );
    else
      element_group = 0;
    db( ELEMENT, element, el, ddum, length, VERSION_PRINT, GET );
    name = el[0];
    nnol = length - 1; array_move( &el[1], nodes, nnol );
    if ( name!=first_name ) return;
    outmesh << element << " ";
    if      ( name==-TRIA3 ) {
      outmesh << nodes[0] << " " << nodes[1] << " " << nodes[2] << " ";
    }
    else if ( name==-TRIA6 ) {
      outmesh << nodes[0] << " " << nodes[1] << " " << nodes[2] << " " <<
                 nodes[4] << " " << nodes[5] << " " << nodes[3] << " ";
    }
    else if ( name==-QUAD4 ) {
      outmesh << nodes[0] << " " << nodes[1] << " " << nodes[3] << " " << nodes[2] << " ";
    }
    else if ( name==-QUAD9 ) {
      outmesh << nodes[0] << " " << nodes[1] << " " << nodes[2] << " " << 
                 nodes[5] << " " << nodes[8] << " " << nodes[7] << " " << 
                 nodes[6] << " " << nodes[3] << " " << nodes[4] << " ";
    }
    else if ( name==-TET4 ) {
      outmesh << nodes[0] << " " << nodes[1] << " " << nodes[2] << " " << nodes[3] << " ";
    }
    else if ( name==-TET10 ) {
      outmesh << nodes[0] << " " << nodes[2] << " " << nodes[5] << " " << nodes[9] << " ";
    }
    else if ( name==-HEX8 ) {
      outmesh << nodes[0] << " " << nodes[1] << " " << nodes[3] << " " << nodes[2] << " " <<
                 nodes[4] << " " << nodes[5] << " " << nodes[7] << " " << nodes[6] << " ";
    }
    else if ( name==-HEX27 ) {
      outmesh << nodes[0] << " " << nodes[2] << " " << nodes[8] << " " << nodes[6] << " " <<
                 nodes[18] << " " << nodes[20] << " " << nodes[26] << " " << nodes[24] << " ";
    }
    else 
      return;
    outmesh << element_group << "\n";
  }

  load_type = 1;
  step_val = time_current;
  data_loc = 1;

  if ( npuknwn>0 ) {

    db( DOF_LABEL, 0, dof_label, ddum, ldum, VERSION_NORMAL, GET );
    db( DOF_TYPE, 0, dof_type, ddum, ldum, VERSION_NORMAL, GET );
    db( DOF_SCAL_VEC_MAT, 0, dof_scal_vec_mat, ddum, ldum, VERSION_NORMAL, GET );

      // write scalars, vectors and tensors for primary unknowns
    ipuknwn = 0; ready = 0;
    while ( !ready ) {
      iuknwn = ipuknwn*nder;
      if      ( dof_scal_vec_mat[iuknwn]==-SCALAR ) {
        nval = 1;
        data_type = 1;
        desc_comp = 0;
        strcpy( descr_menu, db_name(dof_label[iuknwn]) );
        string_shorten( descr_menu, 15 );
        outres << descr_menu << "                    " << load_type << " " << step_val << " " <<
          data_type << " " << data_loc << " " << desc_comp << "\n";
      }
      else if ( dof_scal_vec_mat[iuknwn]==-VECTOR ) {
        nval = ndim;
        data_type = 2;
        desc_comp = 1;
        if ( dof_type[iuknwn]==-MATERI_VELOCITY_INTEGRATED )
          strcpy( descr_menu, "materi_velint" );
        else
          strcpy( descr_menu, db_name(dof_type[iuknwn]) );
        string_shorten( descr_menu, 15 );
        outres << descr_menu << "                    " << load_type << " " << step_val << " " <<
          data_type << " " << data_loc << " " << desc_comp << "\n";
        for ( idim=0; idim<ndim; idim++ ) {
          indx = iuknwn + idim*nder;
          outres << db_name(dof_label[indx]) << "\n";
        }
      }
      else {
        assert( dof_scal_vec_mat[iuknwn]==-MATRIX );
        nval = 6;
        data_type = 3;
        desc_comp = 1;
        strcpy( descr_menu, db_name(dof_type[iuknwn]) );
        string_shorten( descr_menu, 15 );
        outres << descr_menu << "                    " << load_type << " " << step_val << " " <<
          data_type << " " << data_loc << " " << desc_comp << "\n";
        for ( idim=0; idim<MDIM; idim++ ) {
          for ( jdim=idim; jdim<MDIM; jdim++ ) {
            indx = iuknwn + stress_indx(idim,jdim)*nder;
            outres << db_name(dof_label[indx]) << "\n";
          }
        }
      }
      for ( inod=1; inod<=max_node; inod++ ) {
        outres << inod << " ";
        node_dof = db_dbl( NODE_DOF, inod, VERSION_PRINT );
        if      ( dof_scal_vec_mat[iuknwn]==-SCALAR ) {
          tmp = node_dof[iuknwn];
          if ( tmp==0 ) 
            outres << "0.0";
          else
            outres << tmp;
        }
        else if ( dof_scal_vec_mat[iuknwn]==-VECTOR ) {
          for ( idim=0; idim<ndim; idim++ ) {
            indx = iuknwn+idim*nder;
            tmp = node_dof[indx];
            if ( tmp==0. )
              outres << "0.0" << " ";
            else
              outres << tmp << " ";
          }
        }
        else {
          assert( dof_scal_vec_mat[iuknwn]==-MATRIX );
          for ( idim=0; idim<MDIM; idim++ ) {
            for ( jdim=idim; jdim<MDIM; jdim++ ) {
              indx = iuknwn + stress_indx(idim,jdim)*nder;
              tmp = node_dof[indx];
              if ( tmp==0. )
                outres << "0.0" << " ";
              else
                outres << tmp << " ";
            }
          }
        }
        outres << "\n";
      }
      ipuknwn += nval;
      ready = (ipuknwn>=npuknwn);
    }

    if ( db_active_index( POST_CALCUL, 0, VERSION_NORMAL ) ) {

      db( POST_CALCUL_UNKNOWN_OPERAT, 0, post_calcul_unknown_operat, 
        ddum, ldum, VERSION_NORMAL, GET );
      db( POST_CALCUL_SCAL_VEC_MAT, 0, post_calcul_scal_vec_mat, 
        ddum, length_post_calcul_scal_vec_mat, VERSION_NORMAL, GET );

        // write scalars, vectors and tensors for calculated data
      icalcul = idim = ready = 0;
      while ( !ready ) {
        strcpy( outname, post_calcul_names_without_extension[icalcul] );
        if      ( post_calcul_scal_vec_mat[icalcul]==-SCALAR ) {
          nval = 1;
          data_type = 1;
          desc_comp = 0;
          strcpy( descr_menu, outname );
          string_shorten( descr_menu, 15 );
          outres << descr_menu << "                    " << load_type << " " << step_val << " " <<
            data_type << " " << data_loc << " " << desc_comp << "\n";
        }
        else {
          assert( post_calcul_scal_vec_mat[icalcul]==-VECTOR );
          nval = MDIM;
          data_type = 2;
          desc_comp = 1;
          strcpy( descr_menu, outname );
          string_shorten( descr_menu, 15 );
          outres << descr_menu << "                    " << load_type << " " << step_val << " " <<
            data_type << " " << data_loc << " " << desc_comp << "\n";
          for ( idim=0; idim<MDIM; idim++ ) {
            outres << post_calcul_names[icalcul+idim] << "\n";
          }
        }
        for ( inod=1; inod<=max_node; inod++ ) {
          outres << inod << " ";
          node_dof_calcul = db_dbl( NODE_DOF_CALCUL, inod, VERSION_PRINT );
          if      ( post_calcul_scal_vec_mat[icalcul]==-SCALAR ) {
            tmp = node_dof_calcul[icalcul];
            if ( tmp==0. )
              outres << "0.0";
            else
              outres << tmp;
          }
          else {
            assert( post_calcul_scal_vec_mat[icalcul]==-VECTOR );
            for ( idim=0; idim<MDIM; idim++ ) {
              indx = icalcul+idim;
              tmp = node_dof_calcul[indx];
              if ( tmp==0. )
                outres << "0.0" << " ";
              else
                outres << tmp << " ";
            }
          }
          outres  << "\n";
        }
        icalcul += nval;
        ready = (icalcul>=length_post_calcul_scal_vec_mat);
      }

    }

  }

  outmesh.close();
  outres.close();

  db_version_delete( VERSION_PRINT );

  if ( swit ) pri( "Out routine PRINT_GID" );
}
