#ifndef _winged_edge_
#define _winged_edge_

#ifndef _proj_matrix_
#define _proj_matrix_

typedef double proj_matrix[4][4];
typedef double point[4];

#endif

typedef struct WEvertex {
	double		x[4];	/* coordinates (x[3] == 1) */
	double		dist;	/* distance from slicing plane (used locally) */
	int		ideal;	/* is this an ideal vertex (used locally) */
	struct WEvertex	*next;
} WEvertex;

typedef struct WEedge {
	struct WEvertex	*v0,	/* tail */
			*v1;	/* tip  */
	struct WEedge	*e0L,	/* back left   */
			*e0R,	/* back right  */
			*e1L,	/* front left  */
			*e1R;	/* front right */
	struct WEface	*fL,	/* left face  */
			*fR;	/* right face */
	struct WEedge	*next;
} WEedge;

typedef struct WEface {
	int				order;
	int				fill_tone;
	struct WEedge	*some_edge;
	proj_matrix		group_element;
	struct WEface	*inverse;
	struct WEface	*next;	/* general use */
	struct WEface	*prv;	/* used for clean and dirty lists */
	struct WEface	*nxt;
} WEface;

typedef struct {
	int			num_vertices,
				num_edges,
				num_faces;
	WEvertex	*vertex_list;
	WEedge		*edge_list;
	WEface		*face_list;
	WEface		dirty0,	/* dummy faces to serve as start and	*/
				dirty1,	/* finish of doubly linked lists		*/
				clean0,
				clean1,
				pending0,
				pending1;
} WEpolyhedron;

#endif
