/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"
#include "discgrpP.h"

BBox *
DiscGrpBound(discgrp, T)
	DiscGrp	*discgrp;
	Transform T;
{
    register BBox *geombbox;
    Transform Tnew, T2;
    GeomIter *it;
    Geom *geom;
    int i, nels;

    if( discgrp == NULL)
	return NULL;

    if (discgrp->geom == NULL)  return NULL;

    it = GeomIterate( (Geom *)discgrp, DEEP );
    geombbox = NULL;

    /* this is a horrible hack to allow us to continue to fly around at
     * reasonable speeds when in centercam mode, since the speed is
     * proportional to the bbox of the world.  Solution: we only look
     * at the identity element's bbox */
#ifdef BADVELOCITY	/* strange flying mode velocity comps require this */
    if (discgrp->attributes & DG_SPHERICAL || discgrp->flag & DG_CENTERCAM)	{
        nels = discgrp->big_list->num_el;
        discgrp->big_list->num_el = 1;
	}
#endif

    while(NextTransform(it, Tnew) > 0) {
	register BBox *box;

	TmConcat( Tnew,  T, Tnew );
	if((box = (BBox *)GeomBound( discgrp->geom, Tnew )) != NULL) {
	    if(geombbox) {
		BBoxUnion3(geombbox, box, geombbox);
		GeomDelete((Geom *)box);
	    } else
		geombbox = box;
	}
    }
#ifdef BADVELOCITY
    if (discgrp->attributes & DG_SPHERICAL || discgrp->flag & DG_CENTERCAM)
	discgrp->big_list->num_el = nels;
#endif
    return geombbox;
}

