/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef WINDOWPDEF
#define WINDOWPDEF

#include <stdarg.h>
#include "window.h"

/* Private definitions for Window package */

/*
 * Private flag bits:
 * "flag" indicates whether corresponding field valid,
 * "changed" indicates whether changed since someone last unset "changed".
 */
#define	WNF_ENLARGE	0x01	/* Allow window to be enlarged from pref size*/
#define	WNF_SHRINK	0x02	/* Allow window to be shrunk */
#define WNF_NOBORDER	0x04	/* Draw window without frame */

#define WNF_HASPREF	0x10	/* Requested position */
#define WNF_HASSIZE	0x20	/* Requested size */
#define	WNF_HASVP	0x40	/* Drawing viewport within window */
#define	WNF_HASCUR	0x80	/* Window's "current position" */
#define	WNF_HASNAME	0x100	/* Window's title */
#define	WNF_HASPIXASPECT 0x200	/* pixel aspect ratio? */

struct WnWindow {
    REFERENCEFIELDS
    long	flag;		/* Which fields are set?	 */
    long	xsize, ysize;	/* Window size			 */
    WnPosition	pref;		/* Requested abs win position	 */
    WnPosition	cur;		/* Current position		 */
    WnPosition	viewport;	/* Relative viewport in win	 */
    char	*win_name;	/* Window title			 */
    float	aspect;		/* X/Y Aspect ratio (of cur pos) */
    float	pixaspect;	/* Aspect ratio of hardware pixels */
    long	changed;	/* These fields changed		 */
};

extern WnWindow *_WnSet(WnWindow *, int firstattr, va_list *alist);

#define	WINDOWMAGIC	OOGLMagic('w', 1)

#endif	/* WINDOWPDEF */
