/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef QUADPDEFS
#define QUADPDEFS

#include "geomclass.h"
#include "quad.h"

#define QUAD_P VERT_P
#define QUAD_N VERT_N
#define QUAD_C VERT_C
#define QUAD_4D VERT_4D
#define QUAD_BINARY 0x8

typedef HPoint3 QuadP[4];
typedef Point3 QuadN[4];
typedef ColorA QuadC[4];

struct Quad {
    GEOMFIELDS
    int 	flag;
    int		seq;	 	/* for 4D -> 3D tforms */
    int 	maxquad;
    QuadP 	*p;
    QuadN 	*n;
    QuadC 	*c;
};

Quad *QuadPick( Quad *, Pick *, Appearance *, Transform );

#endif /* ! QUADPDEFS */
