#include <sys/types.h>
#include <sys/wait.h>
#include <gtk/gtk.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

#include "aiinterface.h"
#include "../gui/guiinterface.h"
#include "../coordinate.h"

static int _child_pid = 0;

/*#include <stdio.h>*/

void _cb_receive_move(int *input, int fd)
{
	int rd;
	int buf[3];

	gdk_input_remove(*input);
	rd = read(fd, buf, sizeof(buf));
	if(rd < sizeof(buf)) {
		close(fd);
		gui_dialog_new("Error!", "AI error!");
		return;
	}
	wait(NULL);
	_child_pid = 0;
/*	fprintf(stderr, "Value of move: %d\n", buf[0]);*/
	game_square_modify((Coordinate *)&buf[1], PLAYER_AI);
}

void ai_move_determined(Coordinate *move, int value, int e_turn, int fd)
{
	int buf[3];

	memcpy(&buf[1], move, sizeof(Coordinate));
	buf[0] = value;
	write(fd, buf, sizeof(buf));
}

void ai_move(Coordinate *last_move, Coordinate *my_last_move, int turn, int e_turn)
{
	int fd[2];
	static int input;
	int *p = &input;

	if(pipe(fd)==-1)
		return;
	gdk_flush();
	_child_pid = fork();
	if(_child_pid == -1)
		return;
	if(!_child_pid) { /* AI process - child */
		ai_think(last_move, my_last_move, turn, e_turn, fd[1]);
		_exit(-1);
	}
	input = gdk_input_add(fd[0], GDK_INPUT_READ | GDK_INPUT_EXCEPTION, (GdkInputFunction)_cb_receive_move, p);
}

int ai_init(int *argc, char ***argv)
{
	ai_think_init();

	return 0;
}

void ai_break(void)
{
	if(_child_pid) {
		kill(_child_pid, SIGKILL);
		_child_pid = 0;
		wait(NULL);
	}
}
