
#define DCPLX
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_zswap(const int N, void *X, const int incX,
                 void *Y, const int incY)
{
   double *x = X, *y = Y;
   int incx = incX, incy = incY;

   if (incX < 0)
   {
      if (incY < 0) { incx = -incx; incy = -incY; }
      else x += -incX * ((N-1)<<1);
   }
   else if (incY < 0)
   {
      incy = -incy;
      incx = -incx;
      x += (N-1)*(incX<<1);
   }
   ATL_zswap(N, x, incx, y, incy);
}
