
#define SREAL
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

float cblas_sdot(const int N, const float *X, const int incX, 
                     const float *Y, const int incY)
{
   if (incX < 0)
   {
      if (incY < 0) return(ATL_sdot(N, X, -incX, Y, -incY));
      else return(ATL_sdot(N, X+(1-N)*incX, incX, Y, incY));
   }
   else if (incY < 0) return(ATL_sdot(N, X+(N-1)*incX, -incX, Y, -incY));
   else return(ATL_sdot(N, X, incX, Y, incY));
}
