
#define SREAL
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_scopy(const int N, const float *X, const int incX,
                      float *Y, const int incY)
{
   if (incX < 0)
   {
      if (incY < 0) ATL_scopy(N, X, -incX, Y, -incY);
      else ATL_scopy(N, X+(1-N)*incX, incX, Y, incY);
   }
   else if (incY < 0) ATL_scopy(N, X+(N-1)*incX, -incX, Y, -incY);
   else ATL_scopy(N, X, incX, Y, incY);
}
