
#define DREAL
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_drot(const int N, double *X, const int incX, 
                double *Y, const int incY, const double c, const double s)
{
   if (incX < 0)
   {
      if (incY < 0) ATL_drot(N, X, -incX, Y, -incY, c, s);
      else ATL_drot(N, X+((1-N)*incX), incX, Y, incY, c, s);
   }
   else if (incY < 0) 
      ATL_drot(N, X+((N-1)*incX), -incX, Y, -incY, c, s);
   else ATL_drot(N, X, incX, Y, incY, c, s);
}
