/* ---------------------------------------------------------------------
 *
 * -- Automatically Tuned Linear Algebra Software (ATLAS)
 *    (C) Copyright 1999 All Rights Reserved
 *
 * -- ATLAS routine -- Version 3.0 beta -- December 25, 1999
 *
 * -- Suggestions,  comments,  bugs reports should be sent to the follo-
 *    wing e-mail address: atlas@cs.utk.edu
 *
 * Author         : Antoine P. Petitet
 * Contributor(s) : R. Clint Whaley
 * University of Tennessee - Innovative Computing Laboratory
 * Knoxville TN, 37996-1301, USA.
 *
 * ---------------------------------------------------------------------
 *
 * -- Copyright notice and Licensing terms:
 *
 *  Redistribution  and  use in  source and binary forms, with or without
 *  modification, are  permitted provided  that the following  conditions
 *  are met:
 *
 * 1. Redistributions  of  source  code  must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce  the above copyright
 *    notice,  this list of conditions, and the  following disclaimer in
 *    the documentation and/or other materials provided with the distri-
 *    bution.
 * 3. The name of the University,  the ATLAS group,  or the names of its
 *    contributors  may not be used to endorse or promote products deri-
 *    ved from this software without specific written permission.
 *
 * -- Disclaimer:
 *
 * THIS  SOFTWARE  IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,  INCLUDING,  BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  INDIRECT, INCIDENTAL, SPE-
 * CIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO,  PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEO-
 * RY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT  (IN-
 * CLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ---------------------------------------------------------------------
 */
#ifndef ATLAS_KERNEL2_H
#define ATLAS_KERNEL2_H
/*
 * =====================================================================
 * Include files
 * =====================================================================
 */
/*
 * =====================================================================
 * #define macro constants
 * =====================================================================
 */
/*
 * =====================================================================
 * #define macros definitions
 * =====================================================================
 */
/*
 * =====================================================================
 * Recursive Level 2 BLAS function prototypes
 * =====================================================================
 */
void       ATL_ssymvL
( const int,       const float  *,  const int,       const float  *,
  const float,     float  * );
void       ATL_ssymvU
( const int,       const float  *,  const int,       const float  *,
  const float,     float  * );
void       ATL_dsymvL
( const int,       const double *,  const int,       const double *,
  const double,    double * );
void       ATL_dsymvU
( const int,       const double *,  const int,       const double *,
  const double,    double * );

void       ATL_chemvL
( const int,       const float  *,  const int,       const float  *,
  const float  *,  float  * );
void       ATL_chemvU
( const int,       const float  *,  const int,       const float  *,
  const float  *,  float  * );
void       ATL_zhemvL
( const int,       const double *,  const int,       const double *,
  const double *,  double * );
void       ATL_zhemvU
( const int,       const double *,  const int,       const double *,
  const double *,  double * );

void       ATL_ssyrL
( const int,       const float  *,  const float  *,  const int,
  float  *,        const int );
void       ATL_ssyrU
( const int,       const float  *,  const float  *,  const int,
  float  *,        const int );
void       ATL_dsyrL
( const int,       const double *,  const double *,  const int,
  double *,        const int );
void       ATL_dsyrU
( const int,       const double *,  const double *,  const int,
  double *,        const int );
void       ATL_cherL
( const int,       const float  *,  const float  *,  const int,
  float  *,        const int );
void       ATL_cherU
( const int,       const float  *,  const float  *,  const int,
  float  *,        const int );
void       ATL_zherL
( const int,       const double *,  const double *,  const int,
  double *,        const int );
void       ATL_zherU
( const int,       const double *,  const double *,  const int,
  double *,        const int );

void       ATL_ssyr2L
( const int,       const float  *,  const float  *,  float  *,
  const int );
void       ATL_ssyr2U
( const int,       const float  *,  const float  *,  float  *,
  const int );
void       ATL_dsyr2L
( const int,       const double *,  const double *,  double *,
  const int );
void       ATL_dsyr2U
( const int,       const double *,  const double *,  double *,
  const int );
void       ATL_cher2L
( const int,       const float  *,  const float  *,  float  *,
  const int );
void       ATL_cher2U
( const int,       const float  *,  const float  *,  float  *,
  const int );
void       ATL_zher2L
( const int,       const double *,  const double *,  double *,
  const int );
void       ATL_zher2U
( const int,       const double *,  const double *,  double *,
  const int );

void       ATL_strmvUN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_strmvUT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_strmvLN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_strmvLT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );

void       ATL_strmvUNN
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvUTN
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvUNU
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvUTU
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvLNN
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvLTN
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvLNU
( const int,       const float  *,  const int,       float  * );
void       ATL_strmvLTU
( const int,       const float  *,  const int,       float  * );

void       ATL_dtrmvUN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_dtrmvUT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_dtrmvLN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_dtrmvLT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );

void       ATL_dtrmvUNN
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvUTN
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvUNU
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvUTU
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvLNN
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvLTN
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvLNU
( const int,       const double *,  const int,       double * );
void       ATL_dtrmvLTU
( const int,       const double *,  const int,       double * );

void       ATL_ctrmvUN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvUT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvUC
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvUH
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvLN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvLT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvLC
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrmvLH
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );

void       ATL_ctrmvUNN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUTN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUCN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUHN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUNU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUTU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUCU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvUHU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLNN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLTN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLCN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLHN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLNU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLTU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLCU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrmvLHU
( const int,       const float  *,  const int,       float  * );

void       ATL_ztrmvUN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvUT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvUC
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvUH
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvLN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvLT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvLC
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrmvLH
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );

void       ATL_ztrmvUNN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUTN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUCN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUHN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUNU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUTU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUCU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvUHU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLNN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLTN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLCN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLHN
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLNU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLTU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLCU
( const int,       const double *,  const int,       double * );
void       ATL_ztrmvLHU
( const int,       const double *,  const int,       double * );

void       ATL_strsvUN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_strsvUT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_strsvLN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_strsvLT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );

void       ATL_strsvUNN
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvUTN
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvUNU
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvUTU
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvLNN
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvLTN
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvLNU
( const int,       const float  *,  const int,       float  * );
void       ATL_strsvLTU
( const int,       const float  *,  const int,       float  * );

void       ATL_dtrsvUN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_dtrsvUT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_dtrsvLN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_dtrsvLT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );

void       ATL_dtrsvUNN
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvUTN
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvUNU
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvUTU
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvLNN
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvLTN
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvLNU
( const int,       const double *,  const int,       double * );
void       ATL_dtrsvLTU
( const int,       const double *,  const int,       double * );

void       ATL_ctrsvUN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvUT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvUC
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvUH
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvLN
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvLT
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvLC
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );
void       ATL_ctrsvLH
( const enum ATLAS_DIAG,            const int,       const float  *,
  const int,       float  * );

void       ATL_ctrsvUNN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUTN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUCN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUHN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUNU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUTU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUCU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvUHU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLNN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLTN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLCN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLHN
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLNU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLTU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLCU
( const int,       const float  *,  const int,       float  * );
void       ATL_ctrsvLHU
( const int,       const float  *,  const int,       float  * );

void       ATL_ztrsvUN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvUT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvUC
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvUH
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvLN
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvLT
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvLC
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );
void       ATL_ztrsvLH
( const enum ATLAS_DIAG,            const int,       const double *,
  const int,       double * );

void       ATL_ztrsvUNN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUTN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUCN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUHN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUNU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUTU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUCU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvUHU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLNN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLTN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLCN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLHN
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLNU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLTU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLCU
( const int,       const double *,  const int,       double * );
void       ATL_ztrsvLHU
( const int,       const double *,  const int,       double * );

#endif
/*
 * End of atlas_kernel2.h
 */
