.ds VE LPRng-3.9.0
.TH LPC 1 \*(VE "LPRng"
.ig
lpc.1,v 3.36 1998/03/29 18:37:49 papowell Exp
Mon Jul 17 20:14:17 PDT 1995 Patrick Powell
..
.SH NAME
lpc \- line printer control program
.SH SYNOPSIS
.B lpc
[
.BI \-A
]
[
.BI \-a
]
[
.BI \-D debugopts
]
[
.BI \-P printer
]
[
.BI \-S server
]
[
.BI \-U username
]
[
.B \-V
]
[ command [ argument ... ] ]
.SH DESCRIPTION
.I Lpc
is used by the system administrator to control the
operation of the line printer system.  
For each line printer configured in 
.I _PRINTCAP_PATH_
or the printcaps specified in the configuration file 
.I _LPD_CONF_PATH_
(see lpd.conf(5)),
.I lpc
may be used to:
.IP \(bu 3
disable or enable a single or all printer,
.IP \(bu 3
disable or enable a single printer's or all printer's spooling queue,
.IP \(bu 3
move jobs to the top a queue
.IP \(bu 3
find the status of printers, and their associated
spooling queues and printer dameons,
.IP \(bu 3
start and stop printer servers for a queue with multiple print servers,
.IP \(bu 3
hold and release a specific job in a printer queue,
.IP \(bu 3
redirect printing to another printer,
.IP \(bu 3
restart a printer job after having solved printer problems and let it
print from the beginning, 
.IP \(bu 3
reprint a job
.PP
Without any arguments,
.I lpc
will prompt for commands from the standard input.
If arguments are supplied,
.IR lpc
interprets the first argument as a command and the remaining
arguments as parameters to the command.
Permission to use spool queue control commands is determined by the
printer permissions file
(See FILES).
.SH OPERATION
.PP
The operation of each spool queue is controlled by a
.I "spoolcontrol"
file which has a set of keyword options and values.
(Other print spoolers have used permissions bits of directories and files
for similar purposes).
In addition,
each job in the spool queue can have a
.I "holdfile"
which contains detailed information on how the spooler is to treat the
particular job.
The server will update these files with status and other information as the
job is processed.
The
.I lpc
command operates by sending requests to the
.I lpd
server process to update the information in these files and to signal
server processes that the information has been updated.
.SH OPTIONS
.IP "\fB\-A\fR" 5
Use authentication specified by the value of the AUTH environment variable.
.IP "\fB\-a\fR" 5
Alias for -Pall.
.IP "\fB\-P\fIprinter\fR" 5
Printer spool queue to operate on.
if no name is given,
the -P option,
the printer selected by the value of the PRINTER enviroment variable,
or the first entry in the printcap file will be used.
When all printers are selected,
the LPC command will first attempt to find the
printcap entry for printer ``all'';
the
.I all
printcap field value will be a list of printers to control. 
If there is no printcap entry,
then the request is directly forwarded to the default LPD host,
which will do a lookup for all of the available printers.
By specifying ``all@host'',
the user can control all printers on a given host.
.IP "\fB\-S\fIserver\fR" 5
Send commands to this server,
rather than the one specified by the
\fB\-P\fIprinter\fR"
or printcap entry.
This allows you to use a default printcap entry for
authentication information or other setup information,
but direct queries to a specific server.
.IP "\fB\-V\fR" 5
Print program version information
.IP "\fB\-U\fIusername\fP\fR" 5
Set the user name for the request.  This option is available only to
user root or to the userids listed in the
.I allow_user_setting
configuration option.
.IP "\fB\-D\fIdebugopts\fP" 5
Debugging is controlled using the
.B \-D
option. This accepts a comma-separated list of debugging
settings. These settings take one of two forms: 
.B facility=value , 
or
.B value 
to set an overall default value.
The form -D= will display a list of debugging options.
.SH COMMANDS
.PP
The following is the alphabetical list of recognized commands.
The jobcontrol or holdfile fields effective are listed as
part of the command.
.TP
?
.br
Help.
Also, any unrecognized input produces a help listing.
.TP
active [pr@[host]]
.br
makes a connection to the LPD server for the specified printer.
Closes the connection after making it.
This is useful for checking to see if a non-LPRng server is active.
.TP
abort { all | printer* }
.br
Kill the active job and disables unspooling.
The active job will not be deleted from the queue.
.br
Action: kills server process, updates spool control file
.I printing_disabled
field.
.TP
class {all | printer } (off | classlist | X=globmatch)
.br
Controls the class of jobs currently being printed.
The
.I off
option removes any class restrictions.
The classlist option is a list of classes;
for example A,B,C would release classes A, B, and C for printing.
The X=globmatch form performs a match against a control file entry
starting with the indicated capital letter.
For example,  J=*form1* would allow jobs which had the string
form1 in their job title to be printed.
.TP
defaultq
.br
Lists the default queue for the LPC program.
.TP
defaults
.br
Lists default values for the configuration information.
.TP
debug j all | printer } [string | off ]
.br
Set the debugging string for the specified printer.
This is a diagnostic aid and should be used with caution;
refer to the reference manual for details of the debugging string format.
In general,
you can use:
.br
.I INTEGER
\- the integer number sets the general debugging level
.br
keyword=value
.br
\- sets a debugging variable to a specified value
.br
keyword
\- sets a debugging flag
.br
Action: updates spool control file
.I debug
field.
.TP
disable { all | printer }
.br
Disable spooling to the specified spool queues.
See
.I enable.
.br
Action: updates spool control file
.I printing_disabled
field.
.TP
down {all | printer }
.br
Disable both queuing and printing for all printers or the selected printer.
See
.I up.
.br
Action: updates spool control file
.I printing_disabled
and
.I spooling_disabled
fields.
.TP
enable { all | printer }
.br
Enable spooling for all printers or the selected printer.
.br
Action: updates spool control file
.I spooling_disabled
field.
.TP
exit or quit
.br
terminate LPC program
.TP
help
.br
Print a short help message.
.TP
hold printer { jobid }
.br
Holds the specified printer job (or jobs) in the queue.
The job will not be
printed even if spooling and printing is enabled. It must be released
with the relase command.
The holdall command
or :ah: printcap flag can enable automatic holding of spooled jobs.
.br
Action: updates job holdfile
.I hold
field with time that job was held.
A 0 value release job for printing.
.TP
holdall { all | printer ... }
.br
Turn on automatic job holding of new jobs.
New jobs will be marked as held,
and held until released with the release command.
This will be done until holdall is turned off with the noholdall command.
The :ah: printcap flag can enable automatic holding as well.
.br
Action: updates spool control file
.I holdall
field.
.TP
kill { all | printer ... }
.br
Do an abort command followed by a start command.
This is a quick way to kill off a server that has problems.
Note that due to race conditions and delays,
that the start command may not be effective this action should
be monitored to ensure that the job restarts.
.TP
client { all | printer ... }
.br
Show the LPRng client configuration and printcap information on the local host.
This is an extremely useful diagnostic tool.
.TP
lpd [printer@[host]]
.br
determines if LPD daemon process on the print server is running,
and gets the PID.
This is handy to determine if the LPD daemon was killed or
aborted due to abnormal conditions.
.TP
lpq printer [options]
.br
Run
.I lpq
from inside the 
.I lpc
program.
.TP
lprm printer jobid [jobid]*
.br
Run
.I lprm
from inside the 
.I lpc
program.
Not all options are supported - this form requires
the printer name and jobid to be specified explicitly.
.TP
move printer jobid  destinationPrinter
.br
Send the specified jobs to the destination printer and remove them
from the printer queue.
.br
Action: updates the job holdfile
.I move
field with the destination and starts a server process to do the
job transfer.
.TP
msg printer message text
.br
Update the status message for the printer.
An empty message will remove the status message.
.TP
noholdall { all | printer* }
.br
Turn off automatic job holding.
See holdall command.
.TP
quit or exit
.br
terminate LPC program
.TP
redirect [printer [destinationPrinter | off ]]
.br
redirect the jobs in the printer queue to another printer
or turn redirection off.
.br
Action: updates spool control file
.I redirect
field.
.TP
redo [printer [jobid]]
.br
Reprint the selected job.
.TP
release [printer [jobid]]
.br
Releases the selected job for printing.
.TP
reread [ printer [@host] ]
.br
Sends a request to the LPD server for the printer to reread the
configuration and printcap information.
This is equivalent to using
kill -HUP serverpid,
but can be done for servers on remote hosts.
.TP
server { all | printer }
.br
Shows the printcap entries for the printer or all printers as the LPD server
would use them.
.TP
start { all | printer }
.br
Start the printer.
This is useful when some abnormal condition causes the server to
terminate unexpectedly leaving jobs in the queue.
.I Lpq
will report that there is no daemon present when this condition occurs. 
.TP
status { all | printer }
Display the status of daemons and queues on the local machine.
.TP
stop { all | printer }
.br
Disable any further unspooling after the current job completes.
.TP
topq printer [ jobid ]
.br
Place the selected jobs at the top of the printer queue.
.TP
up {all | printer ...}
Enables queuing and printing for the specified or all printers.
Privileged.
.SH JOBIDS
.PP
The LPQ command displays a job identifier for each job,
which can be used in LPC commands to identify a specific job.
In the commands descriptions above,
the jobid can be a user name,
a job number,
a job identifier,
or a glob pattern.
The glob pattern is matched against the job identifier.
In command which have an optional jobid,
if none is specified then the first printable job in the queue is acted on.
.SH FILES
.PP
The files used by LPRng are set by values in the
printer configuration file.
The following are a commonly used set of default values.
.nf
.ta \w'/var/spool/lpd/printcap.<hostname>           'u
_LPD_CONF_PATH_	LPRng configuration file
${HOME}/.printcap	user printer description file
_PRINTCAP_PATH_	printer description file
_LPD_PERMS_PATH_	permissions
_LOCKFILE_	lock file for queue control
/var/spool/lpd		spool directories
/var/spool/lpd/QUEUE/control	queue control
/var/spool/lpd/QUEUE/log	trace or debug log file
/var/spool/lpd/QUEUE/acct	accounting file
/var/spool/lpd/QUEUE/status	status file
.fi
.SH "SEE ALSO"
lpd.conf(5),
lpd(8),
checkpc(8),
lpr(1),
lpq(1),
lprm(1),
printcap(5),
lpd.perms(5),
pr(1).
.SH DIAGNOSTICS
.nf
Most of the diagnostics are self explanatory.
If you are puzzled over the exact cause of failure,
set the debugging level on (-D5) and run again.
The debugging information will 
help you to pinpoint the exact cause of failure.
.fi
.SH "HISTORY"
LPRng is a enhanced printer spooler system
with functionality similar to the Berkeley LPR software.
The LPRng mailing list is lprng@lprng.com;
subscribe by sending mail to lprng-request@lprng.com with
the word subscribe in the body.
The software is available from ftp://ftp.lprng.com/pub/LPRng.
.SH "AUTHOR"
Patrick Powell <papowell@lprng.com>.
