/***************************************************************************/
/* 		This code is part of Desktop Background changer		   */
/*		called ChBg						   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _gimpgradient_h_
#define _gimpgradient_h_


/***** Types *****/

/* Gradient segment type */

typedef enum {
	GRAD_LINEAR = 0,
	GRAD_CURVED,
	GRAD_SINE,
	GRAD_SPHERE_INCREASING,
	GRAD_SPHERE_DECREASING
} grad_type_t;

typedef enum {
	GRAD_RGB = 0,  /* normal RGB */
	GRAD_HSV_CCW,  /* counterclockwise hue */
	GRAD_HSV_CW    /* clockwise hue */
} grad_color_t;

typedef struct _grad_segment_t {
	double       left, middle, right; /* Left pos, midpoint, right pos */
	double       r0, g0, b0, a0;   	/* Left color */
	double       r1, g1, b1, a1;   	/* Right color */
	grad_type_t  type;             	/* Segment's blending function */
	grad_color_t color;             /* Segment's coloring type */

	struct _grad_segment_t *prev, *next; /* For linked list of segments */
} grad_segment_t;

/* Complete gradient type */

typedef struct _gradient_t {
	grad_segment_t	*segments;
	char		*filename;
} gradient_t;

extern void grad_get_color_at(gradient_t *, double, double *, double *, double *);
extern GSList *grad_load_gradients(char *);
extern gradient_t *grad_load_gradient(char *);
extern gradient_t *grad_get_random(void);
extern void grad_free_gradient(gradient_t *);
extern GdkPixmap *grad_render(gradient_t *, int);

#endif

