/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _SCORE_H
#define _SCORE_H

#include <list>
#include <string>

class Score {
   std::string	_name;
   int		_seconds;
protected:
public:
   Score() {}
   Score(const std::string& name, int seconds) : _name(name), 
      _seconds(seconds) {}
   int operator<(Score& score);
   friend std::ostream& operator<<(std::ostream& s, const Score& score);
   friend std::istream& operator>>(std::istream& s, Score& score);
   const std::string& GetName() const {return _name;}
   int GetSeconds() const {return _seconds;}
};

class ScoreList {
   std::list<Score> _list;
protected:
public:
   ScoreList() {}
   bool IsNewHighScore(int seconds);
   void AddHighScore(Score& score);
   friend std::ostream& operator<<(std::ostream& s, const ScoreList& slist);
   friend std::istream& operator>>(std::istream& s, ScoreList& slist);
   std::list<Score>::const_iterator Begin() const {return _list.begin();}
   std::list<Score>::const_iterator End() const {return _list.end();}
};

#endif // _SCORE_H

