/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_RDFL.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	Functions: rdFile() & clFile()

	int cfg_rdFile(struct Cfg_Getopt *optstru)
 	Read the next character from the file;
 *
 *	Return:
 *		EOF: end of file / read error
 *		else: read character

ob(ject): cfg_clFile
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Close a file
he(ader files): 
lo(ng description): Implements the "close" function for a file.
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_rdfl.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdio.h>
#endif
#include <portable.h>
#include "supplio.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_RDFL.C 1.5 1999/12/13 02:22:04 ska Exp ska $";
#endif


int cfg_rdFile(struct Cfg_Getopt *optstru)
{	DBG_ENTER("cfg_rdFile", Suppl_cmdline)
	assert(optstru);
	assert(C(_stk));
	DBG_RETURN_BI( S(getArg)? getc(cS(FILE *)S(getArg)): EOF)
}

void cfg_clFile(struct Cfg_Getopt *optstru)
{	DBG_ENTER("cfg_clFile", Suppl_cmdline)

	assert(optstru);
	assert(C(_stk));

	chkHeap
	if(S(getArg))
		Fxclose(cS(FILE *)S(getArg));

	DBG_EXIT
}
