/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: regionsw.cxx,v $
 * $Revision: 1.40 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"


#include <hintids.hxx>
#include <uitool.hxx>
#include <svtools/urihelper.hxx>
#include <svtools/PasswordHelper.hxx>
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#include <svtools/stritem.hxx>
#include <svtools/eitem.hxx>
#include <sot/formats.hxx>
#ifndef _PASSWD_HXX //autogen
#include <sfx2/passwd.hxx>
#endif
#include <sfx2/docfilt.hxx>
#include <sfx2/request.hxx>
#include <sfx2/docfile.hxx>
#include <sfx2/linkmgr.hxx>
#ifndef _SVX_SIZEITEM_HXX //autogen

#include <svx/sizeitem.hxx>
#endif

#include <svx/htmlcfg.hxx>
#include <bookmrk.hxx>
#include <section.hxx>
#include <docary.hxx>
#include <regionsw.hxx>
#ifndef _BASESH_HXX
#include <basesh.hxx>
#endif
#ifndef _WDOCSH_HXX
#include <wdocsh.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#include <swmodule.hxx>
#include <wrtsh.hxx>
#include <swundo.hxx>               	// fuer Undo-Ids
#include <column.hxx>
#include <fmtfsize.hxx>
#include <swunodef.hxx>
#include <shellio.hxx>

#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _REGIONSW_HRC
#include <regionsw.hrc>
#endif
#ifndef _COMCORE_HRC
#include <comcore.hrc>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#include <sfx2/bindings.hxx>
#include <svx/htmlmode.hxx>
#include <svx/dlgutil.hxx>
#include "swabstdlg.hxx"

/*--------------------------------------------------------------------
	Beschreibung:	Bereiche einfuegen
 --------------------------------------------------------------------*/


void SwBaseShell::InsertRegionDialog(SfxRequest& rReq)
{
	SwWrtShell& rSh = GetShell();
	const SfxItemSet *pSet = rReq.GetArgs();

	SfxItemSet aSet(GetPool(),
			RES_COL, RES_COL,
            RES_LR_SPACE, RES_LR_SPACE,
            RES_COLUMNBALANCE, RES_FRAMEDIR,
			RES_BACKGROUND, RES_BACKGROUND,
			RES_FRM_SIZE, RES_FRM_SIZE,
			RES_FTN_AT_TXTEND, RES_END_AT_TXTEND,
			SID_ATTR_PAGE_SIZE, SID_ATTR_PAGE_SIZE,
            0);

	if (!pSet || pSet->Count()==0)
	{
		SwRect aRect;
		rSh.CalcBoundRect(aRect, FLY_IN_CNTNT);

		long nWidth = aRect.Width();
		aSet.Put(SwFmtFrmSize(ATT_VAR_SIZE, nWidth));

		// Hoehe=Breite fuer konsistentere Vorschau (analog zu Bereich bearbeiten)
		aSet.Put(SvxSizeItem(SID_ATTR_PAGE_SIZE, Size(nWidth, nWidth)));
		SwAbstractDialogFactory* pFact = SwAbstractDialogFactory::Create();
        DBG_ASSERT(pFact, "Dialogdiet fail!");
        AbstractInsertSectionTabDialog* aTabDlg = pFact->CreateInsertSectionTabDialog( DLG_INSERT_SECTION,
														&GetView().GetViewFrame()->GetWindow(), aSet , rSh);
        DBG_ASSERT(aTabDlg, "Dialogdiet fail!");
        aTabDlg->Execute();
        rReq.Ignore();
        delete aTabDlg;
    }
	else
    {
		const SfxPoolItem *pItem = 0;
        String aTmpStr;
		if ( SFX_ITEM_SET ==
				pSet->GetItemState(FN_PARAM_REGION_NAME, TRUE, &pItem) )
			aTmpStr = rSh.GetUniqueSectionName(
					&((const SfxStringItem *)pItem)->GetValue() );
		else
			aTmpStr = rSh.GetUniqueSectionName();

		SwSection	aSection(CONTENT_SECTION,aTmpStr);
        rReq.SetReturnValue(SfxStringItem(FN_INSERT_REGION, aTmpStr));

		aSet.Put( *pSet );
        if(SFX_ITEM_SET == pSet->GetItemState(SID_ATTR_COLUMNS, FALSE, &pItem)||
            SFX_ITEM_SET == pSet->GetItemState(FN_INSERT_REGION, FALSE, &pItem))
		{
			SwFmtCol aCol;
			SwRect aRect;
			rSh.CalcBoundRect(aRect, FLY_IN_CNTNT);
			long nWidth = aRect.Width();

			USHORT nCol = ((SfxUInt16Item *)pItem)->GetValue();
			if(nCol)
			{
                aCol.Init( nCol, 0, static_cast< USHORT >(nWidth) );
				aSet.Put(aCol);
			}
		}
		else if(SFX_ITEM_SET == pSet->GetItemState(RES_COL, FALSE, &pItem))
		{
			aSet.Put(*pItem);
		}

        const BOOL bHidden = SFX_ITEM_SET ==
			pSet->GetItemState(FN_PARAM_REGION_HIDDEN, TRUE, &pItem)?
			(BOOL)((const SfxBoolItem *)pItem)->GetValue():FALSE;
		const BOOL bProtect = SFX_ITEM_SET ==
			pSet->GetItemState(FN_PARAM_REGION_PROTECT, TRUE, &pItem)?
			(BOOL)((const SfxBoolItem *)pItem)->GetValue():FALSE;
        // --> FME 2004-06-22 #114856# edit in readonly sections
        const BOOL bEditInReadonly = SFX_ITEM_SET ==
            pSet->GetItemState(FN_PARAM_REGION_EDIT_IN_READONLY, TRUE, &pItem)?
            (BOOL)((const SfxBoolItem *)pItem)->GetValue():FALSE;
        // <--

		aSection.SetProtect(bProtect);
		aSection.SetHidden(bHidden);
        // --> FME 2004-06-22 #114856# edit in readonly sections
        aSection.SetEditInReadonly(bEditInReadonly);
        // <--

        if(SFX_ITEM_SET ==
                pSet->GetItemState(FN_PARAM_REGION_CONDITION, TRUE, &pItem))
            aSection.SetCondition(((const SfxStringItem *)pItem)->GetValue());

        String aFile, aSub;
		if(SFX_ITEM_SET ==
				pSet->GetItemState(FN_PARAM_1, TRUE, &pItem))
			aFile = ((const SfxStringItem *)pItem)->GetValue();

        if(SFX_ITEM_SET ==
				pSet->GetItemState(FN_PARAM_3, TRUE, &pItem))
			aSub = ((const SfxStringItem *)pItem)->GetValue();


		if(aFile.Len() || aSub.Len())
		{
            String sLinkFileName(sfx2::cTokenSeperator);
            sLinkFileName += sfx2::cTokenSeperator;
            sLinkFileName.SetToken(0, sfx2::cTokenSeperator,aFile);

			if(SFX_ITEM_SET ==
					pSet->GetItemState(FN_PARAM_2, TRUE, &pItem))
                sLinkFileName.SetToken(1, sfx2::cTokenSeperator,
					((const SfxStringItem *)pItem)->GetValue());

			sLinkFileName += aSub;
			aSection.SetType( FILE_LINK_SECTION );
			aSection.SetLinkFileName(sLinkFileName);
		}
        rSh.InsertSection(aSection, aSet.Count() ? &aSet : 0);
		rReq.Done();
	}
}

IMPL_STATIC_LINK( SwWrtShell, InsertRegionDialog, SwSection*, pSect )
{
	if( pSect )
	{
		SfxItemSet aSet(pThis->GetView().GetPool(),
				RES_COL, RES_COL,
				RES_BACKGROUND, RES_BACKGROUND,
				RES_FRM_SIZE, RES_FRM_SIZE,
				SID_ATTR_PAGE_SIZE, SID_ATTR_PAGE_SIZE,
				0);
		SwRect aRect;
		pThis->CalcBoundRect(aRect, FLY_IN_CNTNT);
		long nWidth = aRect.Width();
		aSet.Put(SwFmtFrmSize(ATT_VAR_SIZE, nWidth));
		// Hoehe=Breite fuer konsistentere Vorschau (analog zu Bereich bearbeiten)
		aSet.Put(SvxSizeItem(SID_ATTR_PAGE_SIZE, Size(nWidth, nWidth)));
		SwAbstractDialogFactory* pFact = SwAbstractDialogFactory::Create();
        DBG_ASSERT(pFact, "Dialogdiet fail!");
        AbstractInsertSectionTabDialog* aTabDlg = pFact->CreateInsertSectionTabDialog( DLG_INSERT_SECTION,
														&pThis->GetView().GetViewFrame()->GetWindow(),aSet , *pThis);
        DBG_ASSERT(aTabDlg, "Dialogdiet fail!");
        aTabDlg->SetSection(*pSect);
        aTabDlg->Execute();

		delete pSect;
        delete aTabDlg;
	}
	return 0;
}

/*--------------------------------------------------------------------
	Beschreibung:	Bereich bearbeiten
 --------------------------------------------------------------------*/

void SwBaseShell::EditRegionDialog(SfxRequest& rReq)
{
	const SfxItemSet* pArgs = rReq.GetArgs();
    USHORT nSlot = rReq.GetSlot();
	const SfxPoolItem* pItem = 0;
	if(pArgs)
		pArgs->GetItemState(nSlot, FALSE, &pItem);
	SwWrtShell& rWrtShell = GetShell();

	switch ( nSlot )
	{
		case FN_EDIT_REGION:
		{
			Window* pParentWin = &GetView().GetViewFrame()->GetWindow();
			BOOL bStart = TRUE;
            if(bStart)
			{
				SwAbstractDialogFactory* pFact = SwAbstractDialogFactory::Create();
                DBG_ASSERT(pFact, "Dialogdiet fail!");
                AbstractEditRegionDlg* pEditRegionDlg = pFact->CreateEditRegionDlg( MD_EDIT_REGION,
														pParentWin, rWrtShell);
                DBG_ASSERT(pEditRegionDlg, "Dialogdiet fail!");
				if(pItem && pItem->ISA(SfxStringItem))
                {
                    pEditRegionDlg->SelectSection(((const SfxStringItem*)pItem)->GetValue());
                }
                pEditRegionDlg->Execute();
				delete pEditRegionDlg;
			}
			else
				InfoBox(pParentWin, SW_RES(REG_WRONG_PASSWORD)).Execute();
		}
		break;
	}
}
