/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: drawvie3.cxx,v $
 * $Revision: 1.16.32.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



// INCLUDE ---------------------------------------------------------------

#include <svx/svdograf.hxx>
#include <svx/svdoole2.hxx>
#include <sfx2/app.hxx>
#include <sfx2/viewfrm.hxx>

#include "drawview.hxx"
#include "drwlayer.hxx"
#include "viewdata.hxx"
#include "dbfunc.hxx"
#include "document.hxx"
#include "userdat.hxx"
#include "tabvwsh.hxx"
#include "docsh.hxx"

void ScIMapDlgSet( const Graphic& rGraphic, const ImageMap* pImageMap,
					const TargetList* pTargetList, void* pEditingObj );		// imapwrap
USHORT ScIMapChildWindowId();

// STATIC DATA -----------------------------------------------------------

ScDrawView::ScDrawView( OutputDevice* pOut, ScViewData* pData ) :
	FmFormView( pData->GetDocument()->GetDrawLayer(), pOut ),
	pViewData( pData ),
	pDev( pOut ),
	pDoc( pData->GetDocument() ),
	nTab( pData->GetTabNo() ),
	pDropMarker( NULL ),
	pDropMarkObj( NULL ),
	bInConstruct( TRUE )
	//HMHbDisableHdl( FALSE )
{
	// #i73602# Use default from the configuration
	SetBufferedOverlayAllowed(getOptionsDrawinglayer().IsOverlayBuffer_Calc());

	// #i74769#, #i75172# Use default from the configuration
	SetBufferedOutputAllowed(getOptionsDrawinglayer().IsPaintBuffer_Calc());

	Construct();
}

// Verankerung setzen

void ScDrawView::SetAnchor( ScAnchorType eType )
{
	SdrObject* pObj = NULL;
	if( AreObjectsMarked() )
	{
		const SdrMarkList* pMark = &GetMarkedObjectList();
		ULONG nCount = pMark->GetMarkCount();
		for( ULONG i=0; i<nCount; i++ )
		{
			pObj = pMark->GetMark(i)->GetMarkedSdrObj();
			ScDrawLayer::SetAnchor( pObj, eType );
		}

		if ( pViewData )
			pViewData->GetDocShell()->SetDrawModified();
	}
}

ScAnchorType ScDrawView::GetAnchor() const
{
	BOOL bPage = FALSE;
	BOOL bCell = FALSE;
	const SdrObject* pObj = NULL;
	if( AreObjectsMarked() )
	{
		const SdrMarkList* pMark = &GetMarkedObjectList();
		ULONG nCount = pMark->GetMarkCount();
		Point p0;
		for( ULONG i=0; i<nCount; i++ )
		{
			pObj = pMark->GetMark(i)->GetMarkedSdrObj();
			if( ScDrawLayer::GetAnchor( pObj ) == SCA_CELL )
				bCell =TRUE;
			else
				bPage = TRUE;
		}
	}
	if( bPage && !bCell )
		return SCA_PAGE;
	if( !bPage && bCell )
		return SCA_CELL;
	return SCA_DONTKNOW;
}

void __EXPORT ScDrawView::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
{
	if (rHint.ISA(ScTabDeletedHint))						// Tabelle geloescht
	{
		SCTAB nDelTab = ((ScTabDeletedHint&)rHint).GetTab();
		if (ValidTab(nDelTab))
		{
            // used to be: HidePagePgNum(nDelTab) - hide only if the deleted sheet is shown here
            if ( nDelTab == nTab )
                HideSdrPage();
		}
	}
	else if (rHint.ISA(ScTabSizeChangedHint))				// Groesse geaendert
	{
		if ( nTab == ((ScTabSizeChangedHint&)rHint).GetTab() )
			UpdateWorkArea();
	}
	else
		FmFormView::Notify( rBC,rHint );
}

void ScDrawView::UpdateIMap( SdrObject* pObj )
{
	if ( pViewData &&
		 pViewData->GetViewShell()->GetViewFrame()->HasChildWindow( ScIMapChildWindowId() ) &&
		 pObj && ( pObj->ISA(SdrGrafObj) || pObj->ISA(SdrOle2Obj) ) )
	{
		Graphic		aGraphic;
		TargetList	aTargetList;
		ScIMapInfo* pIMapInfo = ScDrawLayer::GetIMapInfo( pObj );
		const ImageMap* pImageMap = NULL;
		if ( pIMapInfo )
			pImageMap = &pIMapInfo->GetImageMap();

		// Target-Liste besorgen
		pViewData->GetViewShell()->GetViewFrame()->GetTargetList( aTargetList );

		// Grafik vom Objekt besorgen
		if ( pObj->ISA( SdrGrafObj ) )
			aGraphic = ( (SdrGrafObj*) pObj )->GetGraphic();
		else
        {
            Graphic* pGraphic = ((const SdrOle2Obj*) pObj )->GetGraphic();
            if ( pGraphic )
                aGraphic = *pGraphic;
        }

		ScIMapDlgSet( aGraphic, pImageMap, &aTargetList, pObj );	// aus imapwrap

		// TargetListe kann von uns wieder geloescht werden
		String* pEntry = aTargetList.First();
		while( pEntry )
		{
			delete pEntry;
			pEntry = aTargetList.Next();
		}
	}
}




