/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: Exception.cxx,v $
 * $Revision: 1.6 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_connectivity.hxx"
#include "java/lang/Exception.hxx"
using namespace connectivity;
//**************************************************************
//************ Class: java.lang.Exception
//**************************************************************

jclass java_lang_Exception::theClass = 0;

java_lang_Exception::~java_lang_Exception()
{}

jclass java_lang_Exception::getMyClass()
{
	// die Klasse muss nur einmal geholt werden, daher statisch
	if( !theClass ){
		SDBThreadAttach t;
		if( !t.pEnv ) return (jclass)NULL;
		jclass tempClass = t.pEnv->FindClass("java/lang/Exception"); OSL_ENSURE(tempClass,"Java : FindClass nicht erfolgreich!");
		jclass globClass = (jclass)t.pEnv->NewGlobalRef( tempClass );
		t.pEnv->DeleteLocalRef( tempClass );
		saveClassRef( globClass );
	}
	return theClass;
}

void java_lang_Exception::saveClassRef( jclass pClass )
{
	if( pClass==NULL  )
		return;
	// der uebergebe Klassen-Handle ist schon global, daher einfach speichern
	theClass = pClass;
}

