/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import org.emboss.jemboss.gui.SequenceData;
import org.emboss.jemboss.gui.SequenceListTableModel;
import org.emboss.jemboss.gui.filetree.FileNode;
import org.emboss.jemboss.gui.filetree.RemoteFileNode;

class DragJTable
extends JTable
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private SequenceListTableModel seqModel;

    public DragJTable(SequenceListTableModel seqModel) {
        this.seqModel = seqModel;
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setDropTarget(new DropTarget(this, this));
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Point p = e.getDragOrigin();
        int ncol = this.columnAtPoint(p);
        if (ncol == this.convertColumnIndexToView(0)) {
            int nrow = this.getSelectedRow();
            e.startDrag(DragSource.DefaultCopyDrop, this.seqModel.getSequenceData(nrow), this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    protected Boolean isListFile(int row) {
        return (Boolean)this.seqModel.getValueAt(row, 3);
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE) || e.isDataFlavorSupported(FileNode.FILENODE) || e.isDataFlavorSupported(DataFlavor.stringFlavor) || e.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            e.acceptDrag(3);
        }
    }

    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(FileNode.FILENODE)) {
            try {
                FileNode fn = (FileNode)t.getTransferData(FileNode.FILENODE);
                this.insertData(this.seqModel, e.getLocation(), fn.getFile().getCanonicalPath(), "", "", new Boolean(false), new Boolean(false), new Boolean(false));
                e.getDropTargetContext().dropComplete(true);
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {}
        } else if (t.isDataFlavorSupported(RemoteFileNode.REMOTEFILENODE)) {
            try {
                String dropS = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.insertData(this.seqModel, e.getLocation(), dropS, "", "", new Boolean(false), new Boolean(false), new Boolean(true));
                e.getDropTargetContext().dropComplete(true);
            }
            catch (Exception exp) {
                e.rejectDrop();
            }
        } else if (t.isDataFlavorSupported(SequenceData.SEQUENCEDATA)) {
            try {
                SequenceData seqData = (SequenceData)t.getTransferData(SequenceData.SEQUENCEDATA);
                this.insertData(this.seqModel, e.getLocation(), seqData.s_name, seqData.s_beg, seqData.s_end, seqData.s_listFile, seqData.s_default, seqData.s_remote);
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void insertData(SequenceListTableModel seqModel, Point ploc, String fileName, String sbeg, String send, Boolean lis, Boolean def, Boolean bremote) {
        int row = this.rowAtPoint(ploc);
        SequenceListTableModel.modelVector.insertElementAt(new SequenceData(fileName, sbeg, send, lis, def, bremote), row);
        this.tableChanged(new TableModelEvent(seqModel, row + 1, row + 1, -1, 1));
    }

    public void dragOver(DropTargetDragEvent e) {
        Point ploc = e.getLocation();
        int row = this.rowAtPoint(ploc);
        this.setRowSelectionInterval(row, row);
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }
}

