/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner.gui;

import gnu.bioinformatics.jaligner.JAligner;
import gnu.bioinformatics.jaligner.formats.FASTA;
import gnu.bioinformatics.jaligner.util.Alignment;
import gnu.bioinformatics.jaligner.util.Matrices;
import gnu.bioinformatics.jaligner.util.Parser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.text.DecimalFormat;
import javax.jnlp.ClipboardService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class JAlignerWindow
extends JFrame {
    private static final String NEW_LINE = "\n";
    private static final int WIDTH = 800;
    private static final int HEIGHT = 400;
    private static final float DEFAULT_OPEN_GAP_PENALTY = 10.0f;
    private static final float DEFAULT_EXTEND_GAP_PENALTY = 0.5f;
    private static final String DEFAULT_SCORING_MATRIX = "BLOSUM62";
    private FileContents fc1 = null;
    private FileContents fc2 = null;
    private ClipboardService cs = null;
    private JLabel jLabelSequence2;
    private JScrollPane jScrollPaneOutput;
    private JTabbedPane jTabbedPaneJAligner;
    private JLabel jLabelOpenGapPenalty;
    private JLabel jLabelInput;
    private JLabel jLabelOutput;
    private JButton jButtonOutputDelete;
    private JPanel jPanelInput;
    private JLabel jLabelScoringMatrix;
    private JButton jButtonBroswe2;
    private JTextField jTextFieldExtendGapPenalty;
    private JPanel jPanelControls;
    private JPanel jPanelOutput;
    private JPanel jPanelAlignButton;
    private JComboBox jComboBoxScoringMatrix;
    private JButton jButtonOutputCopy;
    private JPanel jPanelParameters;
    private JButton jButtonAlign;
    private JTextArea jTextAreaOutput;
    private JButton jButtonOutputSave;
    private JPanel jPanelSmithWaterman;
    private JToolBar jToolBarOutput;
    private JButton jButtonBroswe1;
    private JLabel jLabelExtendGapPenalty;
    private JTextField jTextFieldOpenGapPenalty;
    private JLabel jLabelSequence1;
    static /* synthetic */ Class class$0;

    public JAlignerWindow() {
        this.initComponents();
        try {
            URL url = this.getClass().getResource("/gnu/bioinformatics/jaligner/gui/gifs/jaligner.gif");
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            ((Frame)this).setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ((Component)this).setSize(800, 400);
        this.jTextFieldOpenGapPenalty.setText(new Float(10.0f).toString());
        this.jTextFieldExtendGapPenalty.setText(new Float(0.5f).toString());
        try {
            this.cs = (ClipboardService)ServiceManager.lookup((String)"javax.jnlp.ClipboardService");
            this.jButtonOutputCopy.setEnabled(true);
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
        }
        try {
            this.populateComboBox(this.jComboBoxScoringMatrix, Matrices.list());
            this.setDefaultItem(this.jComboBoxScoringMatrix, DEFAULT_SCORING_MATRIX);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void initComponents() {
        this.jTabbedPaneJAligner = new JTabbedPane();
        this.jPanelSmithWaterman = new JPanel();
        this.jPanelInput = new JPanel();
        this.jLabelInput = new JLabel();
        this.jPanelControls = new JPanel();
        this.jPanelParameters = new JPanel();
        this.jLabelScoringMatrix = new JLabel();
        this.jComboBoxScoringMatrix = new JComboBox();
        this.jLabelOpenGapPenalty = new JLabel();
        this.jTextFieldOpenGapPenalty = new JTextField();
        this.jLabelExtendGapPenalty = new JLabel();
        this.jTextFieldExtendGapPenalty = new JTextField();
        this.jLabelSequence1 = new JLabel();
        this.jButtonBroswe1 = new JButton();
        this.jLabelSequence2 = new JLabel();
        this.jButtonBroswe2 = new JButton();
        this.jPanelAlignButton = new JPanel();
        this.jButtonAlign = new JButton();
        this.jPanelOutput = new JPanel();
        this.jLabelOutput = new JLabel();
        this.jScrollPaneOutput = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jToolBarOutput = new JToolBar();
        this.jButtonOutputSave = new JButton();
        this.jButtonOutputCopy = new JButton();
        this.jButtonOutputDelete = new JButton();
        this.setTitle("JAligner");
        this.setName("JAlignerFrame");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JAlignerWindow.this.exitForm(evt);
            }
        });
        this.jTabbedPaneJAligner.setToolTipText("");
        this.jPanelSmithWaterman.setLayout(new BorderLayout());
        this.jPanelInput.setLayout(new BorderLayout());
        this.jLabelInput.setText("Input");
        this.jPanelInput.add((Component)this.jLabelInput, "North");
        this.jPanelParameters.setLayout(new GridBagLayout());
        this.jLabelScoringMatrix.setText("Scoring Matrix");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jLabelScoringMatrix, gridBagConstraints);
        this.jComboBoxScoringMatrix.setToolTipText("Scoring Matrix");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jComboBoxScoringMatrix, gridBagConstraints);
        this.jLabelOpenGapPenalty.setText("Open");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jLabelOpenGapPenalty, gridBagConstraints);
        this.jTextFieldOpenGapPenalty.setText("0.0");
        this.jTextFieldOpenGapPenalty.setToolTipText("Open gap penalty");
        this.jTextFieldOpenGapPenalty.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jTextFieldOpenGapPenalty, gridBagConstraints);
        this.jLabelExtendGapPenalty.setText("Extend");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jLabelExtendGapPenalty, gridBagConstraints);
        this.jTextFieldExtendGapPenalty.setText("0.0");
        this.jTextFieldExtendGapPenalty.setToolTipText("Extend gap penalty");
        this.jTextFieldExtendGapPenalty.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jTextFieldExtendGapPenalty, gridBagConstraints);
        this.jLabelSequence1.setText("Sequence #1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jLabelSequence1, gridBagConstraints);
        this.jButtonBroswe1.setIcon(new ImageIcon(this.getClass().getResource("/gnu/bioinformatics/jaligner/gui/gifs/open.gif")));
        this.jButtonBroswe1.setToolTipText("Select file for sequence #1");
        this.jButtonBroswe1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JAlignerWindow.this.jButtonBroswe1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jButtonBroswe1, gridBagConstraints);
        this.jLabelSequence2.setText("Sequence #2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jLabelSequence2, gridBagConstraints);
        this.jButtonBroswe2.setIcon(new ImageIcon(this.getClass().getResource("/gnu/bioinformatics/jaligner/gui/gifs/open.gif")));
        this.jButtonBroswe2.setToolTipText("Select file for sequence #2");
        this.jButtonBroswe2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JAlignerWindow.this.jButtonBroswe2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.jPanelParameters.add((Component)this.jButtonBroswe2, gridBagConstraints);
        this.jPanelControls.add(this.jPanelParameters);
        this.jPanelInput.add((Component)this.jPanelControls, "Center");
        this.jButtonAlign.setText("Align");
        this.jButtonAlign.setToolTipText("Align");
        this.jButtonAlign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JAlignerWindow.this.jButtonAlignActionPerformed(evt);
            }
        });
        this.jPanelAlignButton.add(this.jButtonAlign);
        this.jPanelInput.add((Component)this.jPanelAlignButton, "South");
        this.jPanelSmithWaterman.add((Component)this.jPanelInput, "West");
        this.jPanelOutput.setLayout(new BorderLayout());
        this.jLabelOutput.setText("Output");
        this.jPanelOutput.add((Component)this.jLabelOutput, "North");
        this.jTextAreaOutput.setEditable(false);
        this.jTextAreaOutput.setFont(new Font("DialogInput", 0, 12));
        this.jTextAreaOutput.setTabSize(0);
        this.jTextAreaOutput.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JAlignerWindow.this.jTextAreaOutputPropertyChange(evt);
            }
        });
        this.jTextAreaOutput.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                JAlignerWindow.this.jTextAreaOutputVetoableChange(evt);
            }
        });
        this.jScrollPaneOutput.setViewportView(this.jTextAreaOutput);
        this.jPanelOutput.add((Component)this.jScrollPaneOutput, "Center");
        this.jToolBarOutput.setOrientation(1);
        this.jButtonOutputSave.setIcon(new ImageIcon(this.getClass().getResource("/gnu/bioinformatics/jaligner/gui/gifs/save.gif")));
        this.jButtonOutputSave.setToolTipText("Save");
        this.jButtonOutputSave.setPreferredSize(new Dimension(24, 24));
        this.jButtonOutputSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JAlignerWindow.this.jButtonOutputSaveActionPerformed(evt);
            }
        });
        this.jToolBarOutput.add(this.jButtonOutputSave);
        this.jButtonOutputCopy.setIcon(new ImageIcon(this.getClass().getResource("/gnu/bioinformatics/jaligner/gui/gifs/copy.gif")));
        this.jButtonOutputCopy.setToolTipText("Copy");
        this.jButtonOutputCopy.setPreferredSize(new Dimension(24, 24));
        this.jButtonOutputCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JAlignerWindow.this.jButtonOutputCopyActionPerformed(evt);
            }
        });
        this.jToolBarOutput.add(this.jButtonOutputCopy);
        this.jButtonOutputDelete.setIcon(new ImageIcon(this.getClass().getResource("/gnu/bioinformatics/jaligner/gui/gifs/delete.gif")));
        this.jButtonOutputDelete.setToolTipText("Delete");
        this.jButtonOutputDelete.setPreferredSize(new Dimension(24, 24));
        this.jButtonOutputDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JAlignerWindow.this.jButtonOutputDeleteActionPerformed(evt);
            }
        });
        this.jToolBarOutput.add(this.jButtonOutputDelete);
        this.jPanelOutput.add((Component)this.jToolBarOutput, "East");
        this.jPanelSmithWaterman.add((Component)this.jPanelOutput, "Center");
        this.jTabbedPaneJAligner.addTab("Smith-Waterman", null, this.jPanelSmithWaterman, "Local alignment with Smith-Waterman algorithm");
        this.getContentPane().add((Component)this.jTabbedPaneJAligner, "Center");
        this.pack();
    }

    private void jTextAreaOutputPropertyChange(PropertyChangeEvent evt) {
    }

    private void jTextAreaOutputVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    private void jButtonOutputSaveActionPerformed(ActionEvent evt) {
        FileSaveService fss = null;
        try {
            fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
            this.errorMessage(e.getMessage());
            return;
        }
        if (fss != null) {
            try {
                StringBufferInputStream sb = new StringBufferInputStream(this.jTextAreaOutput.getText());
                FileContents fc = fss.saveFileDialog(null, null, (InputStream)sb, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage(e.getMessage());
            }
        }
    }

    private void jButtonOutputCopyActionPerformed(ActionEvent evt) {
        String s = this.jTextAreaOutput.getSelectedText();
        StringSelection ss = new StringSelection(s);
        this.cs.setContents((Transferable)ss);
    }

    private void jButtonOutputDeleteActionPerformed(ActionEvent evt) {
        this.jTextAreaOutput.setText("");
    }

    private void jButtonAlignActionPerformed(ActionEvent evt) {
        FASTA fasta2;
        FASTA fasta1;
        InputStream is;
        float extend;
        float open;
        System.gc();
        String matrix = (String)this.jComboBoxScoringMatrix.getSelectedItem();
        try {
            open = Float.parseFloat(this.jTextFieldOpenGapPenalty.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage("Open gap penalty: " + e.getMessage());
            return;
        }
        try {
            extend = Float.parseFloat(this.jTextFieldExtendGapPenalty.getText());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage("Extend gap penalty: " + e.getMessage());
            return;
        }
        try {
            System.out.println("Loading sequence #1 " + this.fc1.getName() + "...");
            this.setCursor(new Cursor(3));
            is = this.fc1.getInputStream();
            fasta1 = Parser.loadFASTA(is);
            is.close();
            System.out.println("Finished loading sequence #1");
            this.setCursor(new Cursor(0));
        }
        catch (Exception e) {
            this.setCursor(new Cursor(0));
            e.printStackTrace();
            this.errorMessage("Sequence #1: " + e.getMessage());
            return;
        }
        try {
            System.out.println("Loading sequence #2 " + this.fc2.getName() + "...");
            this.setCursor(new Cursor(3));
            is = this.fc2.getInputStream();
            fasta2 = Parser.loadFASTA(is);
            is.close();
            System.out.println("Finished loading sequence #2");
            this.setCursor(new Cursor(0));
        }
        catch (Exception e) {
            this.setCursor(new Cursor(0));
            e.printStackTrace();
            this.errorMessage("Sequence #2: " + e.getMessage());
            return;
        }
        int m = fasta1.getSequence().length;
        int n = fasta2.getSequence().length;
        if (Runtime.getRuntime().freeMemory() < (long)(12 * n + n * m)) {
            this.log("No enough memory!");
            this.errorMessage("No enough memory!");
            return;
        }
        Alignment alignment = null;
        try {
            this.setCursor(new Cursor(3));
            long start = System.currentTimeMillis();
            alignment = JAligner.sw(fasta1, fasta2, matrix, open, extend);
            long end = System.currentTimeMillis();
            DecimalFormat f1 = new DecimalFormat("0.00");
            DecimalFormat f2 = new DecimalFormat("0.00%");
            int length = alignment.getSequence1().length;
            int identity = alignment.getIdentity();
            int similarity = alignment.getSimilarity();
            int gaps = alignment.getGaps();
            float score = alignment.getScore();
            this.log("----------------------------------------");
            this.log("Matrix: " + matrix);
            this.log("Open gap: " + open);
            this.log("Extend gap: " + extend);
            this.log("----------------------------------------");
            this.log("Length: " + length);
            this.log("Identity: " + identity + "/" + length + " (" + f2.format((float)identity / (float)length) + ")");
            this.log("Similarity: " + similarity + "/" + length + " (" + f2.format((float)similarity / (float)length) + ")");
            this.log("Gaps: " + gaps + "/" + length + " (" + f2.format((float)gaps / (float)length) + ")");
            this.log("Score: " + f1.format(alignment.getScore()));
            this.log("----------------------------------------");
            this.log(alignment.toPair());
            this.log("----------------------------------------");
            this.setCursor(new Cursor(0));
        }
        catch (Exception e) {
            this.setCursor(new Cursor(0));
            e.printStackTrace();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("gnu.bioinformatics.jaligner.JAligner");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.errorMessage(String.valueOf(clazz.getName()) + ": " + e.getMessage());
        }
    }

    private void jButtonBroswe1ActionPerformed(ActionEvent evt) {
        FileOpenService fos = null;
        try {
            fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
            this.errorMessage(e.getMessage());
        }
        if (fos != null) {
            try {
                this.fc1 = fos.openFileDialog(null, null);
                String message = "sequence #1: " + this.fc1.getName();
                System.out.println(message);
                this.log(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage(e.getMessage());
            }
        }
    }

    private void jButtonBroswe2ActionPerformed(ActionEvent evt) {
        FileOpenService fos = null;
        try {
            fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
        }
        catch (UnavailableServiceException e) {
            e.printStackTrace();
            this.errorMessage(e.getMessage());
        }
        if (fos != null) {
            try {
                this.fc2 = fos.openFileDialog(null, null);
                String message = "sequence #2: " + this.fc2.getName();
                System.out.println(message);
                this.log(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMessage(e.getMessage());
            }
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new JAlignerWindow().show();
    }

    private void populateComboBox(JComboBox combobox, String[] items) {
        int i = 0;
        while (i < items.length) {
            combobox.addItem(items[i]);
            ++i;
        }
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(null, message, this.getClass().getName(), 0);
    }

    private void informationMessage(String message) {
        JOptionPane.showMessageDialog(null, message, this.getClass().getName(), 1);
    }

    private void log(String message) {
        this.jTextAreaOutput.append(String.valueOf(message) + NEW_LINE);
    }

    private void setDefaultItem(JComboBox combobox, String item) {
        int i = 0;
        while (i < combobox.getItemCount()) {
            if (((String)combobox.getItemAt(i)).equals(item)) {
                combobox.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }
}

