// Written by James A. Pattie (james@pcxperience.com) Xperience, Inc. (www.pcxperience.com)
// Additions by Aecio F. Neto (afn@harvest.com.br) - Harvest Consultoria (http://www.harvest.com.br)
// Additions by Nerijus Baliunas (nerijus@users.sourceforge.net)

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "autoconf/platform.h"
#include "VirusEngine.hpp"
#include "VirusScanner.hpp"
#include "String.hpp"
#include <libesmtp.h>
#include <syslog.h>
#include <unistd.h>
#include <errno.h>
#define MAX_BUF 262144 // 256k
#define SIZE 32768 // 32k

extern OptionContainer o;

VirusScanner::VirusScanner()
:file_length(0),isInfected(0),virname(0),tempFileName(new char[0]),tempfileFD(0),timeout(60),trickle_pos(0) {}

VirusScanner::~VirusScanner() {
    unlink(tempFileName);
    
    delete[] tempFileName;
    // delete temporary file when class is destroyed
    // basically this is for when an exception is caught
}

void VirusScanner::handleScanning(Socket *proxysock, Socket *peerconn, String url, int docsize, int contentLength,
				  std::string username, std::string clientip, int filtergroup,
				  std::string location, int reporting_level, int scantype) throw(exception) {
    if (scantype == 0) {
	// scantype 0 indicates that a temporary file has to be created and
	// its content will be retrieved by this class
	createTempFile();
    }
    
    if (contentLength >= docsize) {
	// this means that some bytes were already written to disk
	// but not all of them. So, continue receiving them from proxy
	try {
	    in(proxysock, peerconn, url, docsize, contentLength, username, clientip, scantype);
	} catch (exception& e) {
	    #ifdef DGDEBUG
		std::cout << "***exception on Viruscanner::in***" << std::endl;
	    #endif
	    throw e;
	}
    }

    // scantype indicates that a temporary file already exists and
    // its content has a FD in this class
    scan(peerconn, url, username, clientip, filtergroup, location, reporting_level, scantype);
}

void VirusScanner::createTempFile(void) throw (exception) {
    fstream tmpFile;
    
    tempFileName = new char[256];
    strcpy(tempFileName, o.download_dir.c_str());
    strcat(tempFileName, "/tfXXXXXX");
    

    if ((tempfileFD = mkstemp(tempFileName)) < 0) {
	#ifdef DGDEBUG
    	    std::cout << "VirusScanner could not create temp file " << tempFileName <<  std::endl;
        #endif
	
	if (mkdir(o.download_dir.c_str(), S_IRWXU) == -1) {
	    if (errno != EEXIST) {
		#ifdef DGDEBUG
    		    std::cout << "VirusScanner could not re-create temp dir" <<  std::endl;
    		#endif
		throw exception();
	    }
	}

	strcpy(tempFileName, o.download_dir.c_str());
	strcat(tempFileName, "/tfXXXXXX");
	if ((tempfileFD = mkstemp(tempFileName)) < 0) {
	    #ifdef DGDEBUG
    		std::cout << "VirusScanner could not create temp file " << tempFileName <<  std::endl;
    	    #endif
	    throw exception();
	}
    }
}

bool VirusScanner::out(Socket *sock, char *block, int size) throw(exception) {

    // exceptions on timeout or error
    (*sock).readyForOutput(timeout);  

    // need exception or something for a bad write
    if (!(*sock).writeToSocket(block, size, 0, timeout)) {
	#ifdef DGDEBUG
	    std::cout << "Error sending data to socket" << endl;
	#endif
        throw exception();
	return false;
    }  // write the data block out to the stream

    return true;
}

void VirusScanner::in(Socket *proxysock, Socket *peerconn, String url, int docsize, int contentLength,
		      std::string username, std::string clientip, int scantype) throw(exception) {

    // ConnectionHandler had received all data. Bye... we will only scan it.
    if ((contentLength > 0) && (docsize == contentLength)) {
    	#ifdef DGDEBUG
    	    std::cout << "ConnectionHandler had received all data. returning..." << std::endl;
        #endif
	return;
    }
        
    time_t lastWrite;
    time_t current;

    char input[MAX_BUF];  // buffer for storing a grabbed block from the input stream
    char output[SIZE];

    int tricklelength = o.trickle_length;
    int followingtrickledelay = o.following_trickle_delay;
    int delay = o.first_trickle_delay;
    int size = 1;
    int bufferlength = 0;
    int lastsize = 0;
    int flush = 0;
    int rci = 0;
    int rco = 0;

    bool flushed = false;
        
    if (contentLength > 0) {
	file_length = contentLength;
	// lastsize is only used for positive tricklelength 
	lastsize = contentLength - tricklelength;
    }
    else {
	// bad web server don't provide file sizes.
	// switches back to 1 byte trickle method
	// because we don't know when to stop sending data in trickle mode
    	tricklelength = 1;
	lastsize = 0;
    }

    if (scantype == 1) {
	lseek(tempfileFD, 0, SEEK_SET);
	
	while(true) {
	    rci = read(tempfileFD, input, tricklelength);
	    
	    if (rci < 1) {
		break;
	    }
	    
	    if (rci > 0) {
		bufferlength += rci;

		if (out(peerconn, input, rci)) {
		    trickle_pos += rci;
		}
		else {
		    #ifdef DGDEBUG
			std::cout << "Could not write block to socket." << std::endl;
		    #endif
		    throw exception();
		}
	    }
	    
	    if ((tricklelength > 0) && (trickle_pos + tricklelength) >= lastsize) {
		break;
	    }
	}
    }

    // position file pointer to append more data
    lseek(tempfileFD, 0, SEEK_END);
    
    lastWrite = time(NULL);
    current = lastWrite;
    while(true) {
	flushed = false;
	try {
    	    // grab a fixed amount of input
            (*proxysock).checkForInput(timeout);
    	    rci = (*proxysock).readFromSocket(&input[flush], SIZE, 0, timeout);
        } catch (exception& e) {
            break;
        }

        if (rci < 1) {
            break;  // nothing received or an error ocurred
        }

	if ((flush + rci + SIZE) >= MAX_BUF) {
	    // write direct to block instead of looping to insert 1 byte each time
	    // based on code from Alexander Marx
	    lseek(tempfileFD, 0, SEEK_END);
	    write(tempfileFD, input, flush + rci);
    	    bufferlength += (flush + rci);  // update data size counter
	    flushed = true;
    	    #ifdef DGDEBUG
    	        std::cout << "flushed data to disk due to a full buffer" << std::endl;
            #endif
	}

	if (tricklelength > 0) {
	    if ((trickle_pos + SIZE + tricklelength) < lastsize) {
		if (out(peerconn, &input[flush], rci)) {
		    trickle_pos += rci;
		}
		else {
		    break;
		}
	    }
	}
	else if (bufferlength > trickle_pos) {
	    if (trickle_pos > 0) {
		delay = followingtrickledelay;
	    }

    	    current = time(NULL);
	    if ((current - lastWrite) >= delay) {
    		#ifdef DGDEBUG
    	    	    std::cout << "It is time to send some data to client" << std::endl;
    		#endif

		lseek(tempfileFD, trickle_pos, SEEK_SET);
		rco = read(tempfileFD, output, size);

		// write the data block out to the stream
          	if (out(peerconn, output, rco)) {
		    lastWrite = current;
		    trickle_pos += rco;
		}
              	#ifdef DGDEBUG
		    else {
            	        std::cout << "Could not trickle byte " << trickle_pos << " - filename: " << tempFileName << "'" << std::endl;
          	    }
          	#endif
	    }
	}

	#ifdef DGDEBUG
	    std::cout << "flush: " << flush << std::endl;
	    std::cout << "rci: " << rci << std::endl;
	    std::cout << "trickle_pos: " << trickle_pos << std::endl;
    	    std::cout << "bufferlength: " << bufferlength << std::endl;
    	    std::cout << "tricklelength: " << tricklelength << std::endl;
	    std::cout << "size: " << size << std::endl;
	#endif
	
	if (flushed) {
	    flush = 0;
	}
	else {
	    flush += rci;
	}
    }

    // There is data left in memory block
    if (!flushed && (flush > 0)) {
	#ifdef DGDEBUG
	    std::cout << "Writing data left in memory to disk" << std::endl;
	#endif
	lseek(tempfileFD, 0, SEEK_END);
	write(tempfileFD, input, flush);
    }
}

void VirusScanner::scan(Socket *peerconn, String url, std::string username, std::string clientip, int filtergroup, std::string location, int reporting_level, int scantype) throw(exception) {
    int rc = 0;
    char block[MAX_BUF]; // buffer for storing a grabbed block from the input stream

    VirusEngine avEngine;

    #ifdef DGDEBUG
        std::cout << "Scanning file: '" << tempFileName << "' for user '" << username << "'..." << std::endl;
    #endif

    if (file_length == 0) {
	lseek(tempfileFD, 0, SEEK_SET);
	file_length = lseek(tempfileFD, 0, SEEK_END);
    }
    lseek(tempfileFD, 0, SEEK_SET);
        
    #ifdef DGDEBUG
        std::cout << "Starting file scanning..." << endl;
        system("date");
    #endif
    isInfected = avEngine.scan(tempFileName);
    #ifdef DGDEBUG
        system("date");
        std::cout << "End of file scanning" << endl;
	std::cout << "VirusScanner - isInfected = " << isInfected << std::endl;
    #endif

    if (isInfected == AV_CLEAN) {
        #ifdef DGDEBUG
            std::cout << "sending data from trickle_pos = '" << trickle_pos << "', length = '" << file_length << std::endl;
        #endif

        // position ourselves.
	lseek(tempfileFD, trickle_pos, SEEK_SET);
	while(true) {
	    rc = read(tempfileFD, block, MAX_BUF);
	    #ifdef DGDEBUG
		std::cout << "rc = " << rc << std::endl;
	    #endif

    	    if (rc < 1) {
        	break;  // an error occured so end the while()
                	// or none received so pipe is closed
    	    }

    	    if (rc > 0) {
        	if (out(peerconn, block, rc)) {
		#ifdef DGDEBUG
		    std::cout << "Wrote block to client socket." << std::endl;
		#endif
		}
		#ifdef DGDEBUG
		    else {
			std::cout << "Could not write block to client socket." << std::endl;
		    }
		#endif
    	    }
	}
    }
    else if (isInfected == AV_VIRUS) {
	virname = avEngine.virname;
        // send the browser an error html document stating that the file was infected with virus.
	// Added feature to use dansguardian.pl
        try {
		// HTTP header was already sent to client
		// Sending only HTTP body to client
	    if (reporting_level == 3) {
		String msg;
		msg = "Virus ";
		msg += virname;
		msg += " found";
		o.html_template.display(peerconn,
		url.toCharArray(),
		msg,
		o.language_list.getTranslation(1100),
		username.c_str(),
		clientip.c_str(),
		String (filtergroup + 1),
		""
		);
	    }
	    else {
		(*peerconn).writeString("<html><head>");
		(*peerconn).writeString("<script language=JavaScript>");
		(*peerconn).writeString("location.href=");
		(*peerconn).writeString(location.c_str());
		(*peerconn).writeString("?USER==");
		(*peerconn).writeString(username.c_str());
		(*peerconn).writeString("::REASON==Virus%20'");
		(*peerconn).writeString(virname);
		(*peerconn).writeString("'%20found");
		(*peerconn).writeString("::URL==");
		(*peerconn).writeString(url.toCharArray());
		(*peerconn).writeString("</script>");
		(*peerconn).writeString("</head></html>");
	    }

	    if (o.notify) {
		#ifdef DGDEBUG
		    std::cout << "Sending email..." << endl;
		#endif
		sendmail(username, url, clientip);
	    }
        }   catch (exception& e) {
            #ifdef DGDEBUG
                std::cout << "sending infected message failed!" << std::endl;
            #endif
            throw e;
        }
	#ifdef DGDEBUG
	    std::cout << "VirusName: " << virname << endl;
	#endif
    }
    else {
	try {
	    (*peerconn).writeString("<html><head><title>DansGuardian - Antivirus Error</title></head>");
    	    (*peerconn).writeString("<body><center><h1>DansGuardian Antivirus Patch - Error during scanning</h1>");
	    (*peerconn).writeString("Error message: '");
	    (*peerconn).writeString(avEngine.strError);
    	    (*peerconn).writeString("'</center></body></html>");
	} catch (exception& e) {
	    throw e;
	}
    }

    close(tempfileFD);
    unlink(tempFileName);
}

void VirusScanner::sendmail (std::string username, String url, std::string clientip) {
    smtp_session_t session;
    smtp_message_t message;
    smtp_recipient_t recipient;
    char *host = (char *)o.email_server.c_str();
    std::string from = "\"DansGuardian Anti-Virus\" <dgvirus@";
    from += o.email_domain;
    from += ">";
    std::string return_path = "dgvirus@";
    return_path += o.email_domain;
    char *subject = "Virus Found by DansGuardian Anti-Virus";

    session = smtp_create_session ();
    message = smtp_add_message (session);

    // Set the host running the SMTP server.  LibESMTP has a default port
    // number of 587, however this is not widely deployed so the port
    // is specified as 25 along with the default MTA host.
    smtp_set_server (session, host);

    // Set the reverse path for the mail envelope.  (NULL is ok)
    smtp_set_reverse_path (message, return_path.c_str());

    // RFC 2822 doesn't require recipient headers but a To: header would
    // be nice to have if not present.
    smtp_set_header (message, "To", NULL, NULL);

    // Set the Subject: header.  For no reason, we want the supplied subject
    // to override any subject line in the message headers.
    if (subject != NULL) {
	smtp_set_header (message, "Subject", subject);
	smtp_set_header_option (message, "Subject", Hdr_OVERRIDE, 1);
    }
  
    std::string str = "MIME-Version: 1.0\r\n";
    str += "Content-Type: text/plain; charset=iso-8859-1\r\n";
    str += "Content-Transfer-Encoding: 7bit\r\n";
    str += "From: ";
    str += from;
    str += "\r\n\r\n";
    str += "Virus        : ";
    str += virname;
    str += "\r\n";
    str += "User         : ";
    str += username;
    str += "\r\nURL          : ";
    str += url.toCharArray();
    str += "\r\nUser IP      : ";
    str += clientip;
    smtp_set_message_str(message, (char *)str.c_str());

    if (o.notify > 1)
	recipient = smtp_add_recipient (message, o.postmaster.c_str());
	
    if (o.notify != 2)
	if (username != "-")
	recipient = smtp_add_recipient (message, (username + "@" + o.email_domain).c_str());

    // Initiate a connection to the SMTP server and transfer the message.
    if (!smtp_start_session (session)) {
	char buf[128];
	syslog(LOG_ERR, "SMTP server problem: %s",
	       smtp_strerror (smtp_errno (), buf, sizeof buf));
    }

    smtp_destroy_session (session);
}
