/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.RunnableLock;

public class Synchronizer {
    Display display;
    int messageCount;
    RunnableLock[] messages;
    Object messageLock = new Object();
    Thread syncThread;

    public Synchronizer(Display display) {
        this.display = display;
    }

    void addLast(RunnableLock runnableLock) {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messages == null) {
                this.messages = new RunnableLock[4];
            }
            if (this.messageCount == this.messages.length) {
                RunnableLock[] runnableLockArray = new RunnableLock[this.messageCount + 4];
                System.arraycopy(this.messages, 0, runnableLockArray, 0, this.messageCount);
                this.messages = runnableLockArray;
            }
            this.messages[this.messageCount++] = runnableLock;
            if (this.messageCount == 1) {
                this.display.wakeThread();
            }
        }
    }

    protected void asyncExec(Runnable runnable) {
        if (runnable == null) {
            this.display.wake();
            return;
        }
        this.addLast(new RunnableLock(runnable));
    }

    int getMessageCount() {
        return this.messageCount;
    }

    void releaseSynchronizer() {
        this.display = null;
        this.messages = null;
        this.messageLock = null;
        this.syncThread = null;
    }

    RunnableLock removeFirst() {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.messageCount == 0) {
                return null;
            }
            RunnableLock runnableLock = this.messages[0];
            System.arraycopy(this.messages, 1, this.messages, 0, --this.messageCount);
            this.messages[this.messageCount] = null;
            if (this.messageCount == 0) {
                this.messages = null;
            }
            return runnableLock;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean runAsyncMessages() {
        if (this.messageCount == 0) {
            return false;
        }
        RunnableLock runnableLock = this.removeFirst();
        if (runnableLock == null) {
            return true;
        }
        RunnableLock runnableLock2 = runnableLock;
        synchronized (runnableLock2) {
            this.syncThread = runnableLock.thread;
            try {
                try {
                    runnableLock.run();
                }
                catch (Throwable throwable) {
                    runnableLock.throwable = throwable;
                    SWT.error(46, throwable);
                }
                Object var4_6 = null;
                this.syncThread = null;
                runnableLock.notifyAll();
                return true;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.syncThread = null;
                runnableLock.notifyAll();
                throw throwable;
            }
        }
    }

    protected void syncExec(Runnable runnable) {
        if (this.display.isValidThread()) {
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        if (runnable == null) {
            this.display.wake();
            return;
        }
        RunnableLock runnableLock = new RunnableLock(runnable);
        runnableLock.thread = Thread.currentThread();
        RunnableLock runnableLock2 = runnableLock;
        synchronized (runnableLock2) {
            this.addLast(runnableLock);
            boolean bl = false;
            while (!runnableLock.done()) {
                try {
                    runnableLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Compatibility.interrupt();
            }
            if (runnableLock.throwable != null) {
                SWT.error(46, runnableLock.throwable);
            }
        }
    }
}

