/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

class EventTable {
    int[] types;
    Listener[] listeners;
    int level;

    EventTable() {
    }

    public void hook(int n, Listener listener) {
        if (this.types == null) {
            this.types = new int[4];
        }
        if (this.listeners == null) {
            this.listeners = new Listener[4];
        }
        int n2 = this.types.length;
        int n3 = n2 - 1;
        while (n3 >= 0) {
            if (this.types[n3] != 0) break;
            --n3;
        }
        if (++n3 == n2) {
            if (this.level == 0) {
                n3 = 0;
                int n4 = 0;
                while (n4 < this.types.length) {
                    if (this.types[n4] != 0) {
                        this.types[n3] = this.types[n4];
                        this.listeners[n3] = this.listeners[n4];
                        ++n3;
                    }
                    ++n4;
                }
                n4 = n3;
                while (n4 < this.types.length) {
                    this.types[n4] = 0;
                    this.listeners[n4] = null;
                    ++n4;
                }
            }
            if (n3 == n2) {
                int[] nArray = new int[n2 + 4];
                System.arraycopy(this.types, 0, nArray, 0, n2);
                this.types = nArray;
                Listener[] listenerArray = new Listener[n2 + 4];
                System.arraycopy(this.listeners, 0, listenerArray, 0, n2);
                this.listeners = listenerArray;
            }
        }
        this.types[n3] = n;
        this.listeners[n3] = listener;
    }

    public boolean hooks(int n) {
        if (this.types == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.types.length) {
            if (this.types[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendEvent(Event event) {
        if (this.types == null) {
            return;
        }
        ++this.level;
        try {
            int n = 0;
            while (n < this.types.length) {
                Listener listener;
                if (event.type == 0) {
                    Object var4_4 = null;
                    --this.level;
                    return;
                }
                if (this.types[n] == event.type && (listener = this.listeners[n]) != null) {
                    listener.handleEvent(event);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.level;
            throw throwable;
        }
        {
            Object var4_6 = null;
            --this.level;
            return;
        }
    }

    public int size() {
        if (this.types == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.types.length) {
            if (this.types[n2] != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    void remove(int n) {
        if (this.level == 0) {
            int n2 = this.types.length - 1;
            System.arraycopy(this.types, n + 1, this.types, n, n2 - n);
            System.arraycopy(this.listeners, n + 1, this.listeners, n, n2 - n);
            n = n2;
        }
        this.types[n] = 0;
        this.listeners[n] = null;
    }

    public void unhook(int n, Listener listener) {
        if (this.types == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.types.length) {
            if (this.types[n2] == n && this.listeners[n2] == listener) {
                this.remove(n2);
                return;
            }
            ++n2;
        }
    }

    public void unhook(int n, SWTEventListener sWTEventListener) {
        if (this.types == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.types.length) {
            TypedListener typedListener;
            if (this.types[n2] == n && this.listeners[n2] instanceof TypedListener && (typedListener = (TypedListener)this.listeners[n2]).getEventListener() == sWTEventListener) {
                this.remove(n2);
                return;
            }
            ++n2;
        }
    }
}

